/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.id.KnownIds;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.codegen.BinaryenCompat;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmBlockContext;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmIRWalker;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCompilationResult;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmNodeLowerer;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.hightiercodegen.Keyword;
import jdk.graal.compiler.hightiercodegen.variables.VariableAllocation;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class WasmCodeGenTool
extends CodeGenTool {
    private final CoreProviders providers;
    public final WebImageWasmCompilationResult compilationResult;
    public final WasmIdFactory idFactory;
    private final KnownIds knownIds;
    public final WebImageWasmProviders wasmProviders;
    private final WebImageWasmNodeLowerer nodeLowerer;
    protected final WasmBlockContext topContext;
    private WasmBlockContext currentContext;
    protected final ResolvedJavaMethod method;

    protected WasmCodeGenTool(CoreProviders provider, VariableAllocation variableAllocation, WebImageWasmCompilationResult compilationResult, WebImageWasmProviders wasmProviders, WasmBlockContext topContext, StructuredGraph graph) {
        super(null, variableAllocation);
        this.providers = provider;
        this.compilationResult = compilationResult;
        this.idFactory = wasmProviders.idFactory();
        this.knownIds = wasmProviders.knownIds();
        this.wasmProviders = wasmProviders;
        this.method = graph.method();
        this.nodeLowerer = wasmProviders.getNodeLowerer(this);
        this.topContext = topContext;
        this.currentContext = topContext;
    }

    public CoreProviders getProviders() {
        return this.providers;
    }

    public WebImageWasmProviders getWasmProviders() {
        return this.wasmProviders;
    }

    public KnownIds getKnownIds() {
        return this.knownIds;
    }

    public Instructions getInstructions() {
        return this.currentContext.currentBlock;
    }

    public void childScope(Instructions instructions, Object label) {
        this.currentContext = this.currentContext.getChildContext(instructions, label);
    }

    public void parentScope(Object expectedLabel) {
        assert (this.currentContext.parent != null);
        assert (this.currentContext.checkLabel(expectedLabel));
        this.currentContext = this.currentContext.parent;
    }

    public void recordCall(int posBefore, int posAfter, InvokeTarget target, boolean direct) {
        this.compilationResult.recordCall(posBefore, posAfter - posBefore, target, null, direct);
    }

    private Instruction.Relocation recordRelocation(Instruction.Relocation relocation) {
        this.compilationResult.recordDataPatch(0, relocation.target);
        return relocation;
    }

    public Instruction.Relocation getRelocation(Reference reference) {
        return this.recordRelocation(new Instruction.Relocation(reference));
    }

    public Instruction.Relocation getConstantRelocation(JavaConstant constant) {
        return this.recordRelocation(Instruction.Relocation.forConstant(constant));
    }

    public abstract Instruction.AbstractCall getCall(InvokeTarget var1, boolean var2, Instruction.AbstractCall var3);

    public void genInst(Instruction inst, Node n) {
        this.genInst(inst, this.getNodeComment(n));
    }

    public void genInst(Instruction inst) {
        this.genInst(inst, (Object)null);
    }

    public void genInst(Instruction inst, Object comment) {
        if (comment != null && inst.getComment() == null) {
            inst.setComment(comment);
        }
        this.currentContext.currentBlock.add(inst);
    }

    public void genComment(String comment) {
    }

    public void genInlineComment(String comment) {
    }

    public void lowerPreamble() {
    }

    public void lowerCatchBlock(Instruction.Try tryBlock, Runnable blockLowerer) {
        Instructions catchInstructions = tryBlock.addCatch(this.getKnownIds().getJavaThrowableTag());
        this.childScope(catchInstructions, tryBlock);
        if (BinaryenCompat.usesBinaryen()) {
            Instruction.Relocation pop = new Instruction.Relocation(new BinaryenCompat.Pop(this.nodeLowerer.exceptionObjectVariable.getVariableType()));
            pop.setValue(new Instruction.Nop());
            this.genInst((Instruction)this.nodeLowerer.exceptionObjectVariable.setter(pop), "Store exception object");
        } else {
            this.genInst((Instruction)this.nodeLowerer.exceptionObjectVariable.setter(new Instruction.Nop()), "Store exception object");
        }
        this.lowerCatchPreamble();
        blockLowerer.run();
        this.parentScope(tryBlock);
    }

    protected void lowerCatchPreamble() {
        this.genInst((Instruction)this.getKnownIds().stackPointer.setter(this.nodeLowerer.stackPointerHolder.getter()), "Restore stack pointer");
    }

    public Instruction lowerExpression(ValueNode node, WasmIRWalker.Requirements reqs) {
        return this.nodeLowerer().lowerExpression(node, reqs);
    }

    public Instruction lowerExpression(ValueNode node) {
        return this.nodeLowerer().lowerExpression(node);
    }

    public Object getNodeComment(Node n) {
        if (WebImageWasmOptions.genComments(WebImageOptions.CommentVerbosity.VERBOSE)) {
            return this.nodeLowerer().nodeDebugInfo(n);
        }
        return n;
    }

    public void finish() {
        assert (this.currentContext == this.topContext) : this.currentContext;
    }

    public void genBinaryOperation(Keyword operator, ValueNode leftOperand, ValueNode righOperand) {
        throw GraalError.unimplementedOverride();
    }

    public void genUnaryOperation(Keyword operator, ValueNode operand) {
        throw GraalError.unimplementedOverride();
    }

    public WebImageWasmNodeLowerer nodeLowerer() {
        return this.nodeLowerer;
    }

    public void genMethodHeader(StructuredGraph graph, ResolvedJavaMethod resolvedJavaMethod, List<ParameterNode> parameters) {
        throw GraalError.unimplementedOverride();
    }

    protected void genArrayAccessPostfix() {
        throw GraalError.unimplementedOverride();
    }

    protected void genArrayAccessPrefix() {
        throw GraalError.unimplementedOverride();
    }

    public void genClassHeader(ResolvedJavaType type) {
        throw GraalError.unimplementedOverride();
    }

    public void genResolvedVarDeclPostfix(String comment) {
        throw GraalError.unimplementedOverride();
    }

    public void genNewInstance(ResolvedJavaType t) {
        throw GraalError.unimplementedOverride();
    }

    public void genNewArray(ResolvedJavaType arrayType, IEmitter length) {
        throw GraalError.unimplementedOverride();
    }

    public void genEmptyDeclaration(ValueNode node) {
        throw GraalError.unimplementedOverride();
    }

    public void genCommaList(IEmitter ... inputs) {
        throw GraalError.unimplementedOverride();
    }

    public void genThrow(ValueNode exception) {
        throw GraalError.unimplementedOverride();
    }

    public void genAssignment() {
        throw GraalError.unimplementedOverride();
    }

    public void genNull() {
        throw GraalError.unimplementedOverride();
    }

    public void genFieldName(ResolvedJavaField field) {
        throw GraalError.unimplementedOverride();
    }

    public void genFieldName(Field field) {
        throw GraalError.unimplementedOverride();
    }

    public void genTypeName(ResolvedJavaType type) {
        throw GraalError.unimplementedOverride();
    }

    public void genTypeName(Class<?> type) {
        throw GraalError.unimplementedOverride();
    }

    public void genMethodName(ResolvedJavaMethod resolvedJavaMethod) {
        throw GraalError.unimplementedOverride();
    }

    public void genMethodName(Method type) {
        throw GraalError.unimplementedOverride();
    }

    protected void genPropertyAccessInfix() {
        throw GraalError.unimplementedOverride();
    }

    public void genFunctionCall(IEmitter receiver, IEmitter fun, IEmitter ... params) {
        throw GraalError.unimplementedOverride();
    }

    protected void genFunctionParameterInfix() {
        throw GraalError.unimplementedOverride();
    }

    protected void genFunctionParameterPostfix() {
        throw GraalError.unimplementedOverride();
    }

    public void genStaticMethodReference(ResolvedJavaMethod m) {
        throw GraalError.unimplementedOverride();
    }

    public void genStaticField(ResolvedJavaField m) {
        throw GraalError.unimplementedOverride();
    }

    public void genStaticCall(ResolvedJavaMethod m, IEmitter ... params) {
        throw GraalError.unimplementedOverride();
    }

    public void genIndirectCall(IEmitter address, IEmitter ... params) {
        throw GraalError.unimplementedOverride();
    }

    public void genShouldNotReachHere(String msg) {
        throw GraalError.unimplementedOverride();
    }
}

