/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.libc.TemporaryBuildDirectoryProvider;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import com.oracle.svm.hosted.webimage.wasm.codegen.BinaryenCompat;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class WasmAssembler {
    public final Path tempDirectory;
    public final AssemblerInfo assemblerInfo;

    protected WasmAssembler(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
        try {
            this.assemblerInfo = this.getAssemblerInfo();
        }
        catch (UserError.UserException err) {
            throw this.rethrowWithInfo(err);
        }
    }

    public static WasmAssembler singleton() {
        return (WasmAssembler)ImageSingletons.lookup(WasmAssembler.class);
    }

    public static void install() {
        assert (!ImageSingletons.contains(WasmAssembler.class));
        Path tempDirectory = ((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory();
        WasmAssembler assembler = BinaryenCompat.usesBinaryen() ? new Binaryen(tempDirectory) : new Wat2Wasm(tempDirectory);
        ImageSingletons.add(WasmAssembler.class, (Object)assembler);
        assembler.verifyAssembler();
    }

    public void assemble(Path watPath, Path wasmPath, OptionValues options, Consumer<String> printer) throws IOException, InterruptedException {
        RunResult result = this.runAssembler(watPath, wasmPath);
        List<String> outLines = result.outputLines();
        int exitCode = result.exitCode;
        if (!outLines.isEmpty() && (exitCode != 0 || ((Boolean)DebugOptions.LogVerbose.getValue(options)).booleanValue())) {
            printer.accept("Output for " + String.valueOf(result.commandLine) + ":");
            outLines.forEach(printer);
        }
        UserError.guarantee((exitCode == 0 ? 1 : 0) != 0, (String)"%s failed with exit code: %s", (Object[])new Object[]{result.executable.toString(), exitCode});
    }

    public RunResult runAssembler(Path watPath, Path wasmPath) throws IOException, InterruptedException {
        Path executable = this.assemblerInfo.assemblerPath;
        ArrayList<String> flags = new ArrayList<String>();
        if (((Boolean)WebImageWasmOptions.DebugNames.getValue()).booleanValue()) {
            flags.add(this.getDebugNamesFlag());
        }
        flags.addAll(this.getExtraFlags());
        List<String> args = this.createAssemblerFlags(flags, wasmPath, watPath);
        return WasmAssembler.runCommand(executable, args);
    }

    private static RunResult runCommand(Path executable, List<String> args) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>(args.size() + 1);
        command.add(executable.toString());
        command.addAll(args);
        Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
        try (InputStream inputStream = p.getInputStream();){
            List outLines = FileUtils.readAllLines((InputStream)inputStream);
            int exitCode = p.waitFor();
            RunResult runResult = new RunResult(executable, command, outLines, exitCode);
            return runResult;
        }
    }

    protected abstract String getExecutable();

    protected abstract HostedOptionKey<String> getPathOption();

    protected abstract String getDebugNamesFlag();

    protected abstract List<String> getOutputFlags(Path var1);

    protected abstract List<String> getExtraFlags();

    protected abstract String getVerificationFile();

    protected List<String> getVersionInfoOptions() {
        return List.of("--version");
    }

    public void verifyAssembler() {
        if (((Boolean)SubstrateOptions.CheckToolchain.getValue()).booleanValue()) {
            try {
                this.verify();
            }
            catch (UserError.UserException err) {
                throw this.rethrowWithInfo(err);
            }
        }
    }

    private UserError.UserException rethrowWithInfo(UserError.UserException err) {
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        err.getMessages().forEach(messages::add);
        HostedOptionKey<String> pathOption = this.getPathOption();
        if (!pathOption.hasBeenSet()) {
            messages.add((CallSite)((Object)("A custom path to the " + this.getExecutable() + " executable can be set with the " + SubstrateOptionsParser.commandArgument(this.getPathOption(), (String)"<path>") + " command-line option")));
        }
        messages.add((CallSite)((Object)("To prevent native-toolchain checking provide command-line option " + SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.CheckToolchain, (String)"-"))));
        return UserError.abort(messages);
    }

    private static String formatCommandInfo(RunResult result) {
        return WasmAssembler.formatCommandInfo(result.commandLine(), result.exitCode(), result.outputLines);
    }

    private static String formatCommandInfo(List<String> cmd, int exitCode, List<String> outputLines) {
        assert (exitCode != 0);
        String message = "Command '%s' failed with exit code %d. Output:%n%s";
        return message.formatted(SubstrateUtil.getShellCommandString(cmd, (boolean)false), exitCode, outputLines.stream().map(str -> "  " + str).collect(Collectors.joining(System.lineSeparator())));
    }

    private void verify() {
        String fileName = this.getVerificationFile();
        try (InputStream stream = WasmAssembler.class.getResourceAsStream(fileName);){
            VMError.guarantee((stream != null ? 1 : 0) != 0, (String)"Couldn't find file (%s) used to verify Wasm assembler", (Object)fileName);
            Path path = this.tempDirectory.resolve(fileName);
            Path outputPath = this.tempDirectory.resolve(fileName + ".wasm");
            Files.copy(stream, path, new CopyOption[0]);
            RunResult result = this.runAssembler(path, outputPath);
            if (result.exitCode != 0) {
                throw UserError.abort((String)"Wasm assembler could not assemble sample Wasm text format file. The chosen assembler may not support all required features.%n%s", (Object[])new Object[]{WasmAssembler.formatCommandInfo(result)});
            }
        }
        catch (InterruptedException e) {
            throw new InterruptImageBuilding("Interrupted while checking Wasm assembler " + String.valueOf(this.assemblerInfo.assemblerPath));
        }
        catch (IOException e) {
            throw UserError.abort((Throwable)e, (String)"Assembling sample Wasm text format file failed", (Object[])new Object[0]);
        }
    }

    private AssemblerInfo getAssemblerInfo() {
        String versionString;
        Path executablePath = this.getAssemblerPath().toAbsolutePath();
        if (!((Boolean)SubstrateOptions.CheckToolchain.getValue()).booleanValue()) {
            return new AssemblerInfo(executablePath, null);
        }
        try {
            List<String> helpFlags = this.createAssemblerFlags(this.getVersionInfoOptions(), null, null);
            RunResult result = WasmAssembler.runCommand(executablePath, helpFlags);
            if (result.exitCode() != 0) {
                throw UserError.abort((String)"Collecting Wasm assembler info failed.%n%s", (Object[])new Object[]{WasmAssembler.formatCommandInfo(result)});
            }
            versionString = String.join((CharSequence)System.lineSeparator(), result.outputLines());
        }
        catch (InterruptedException e) {
            throw new InterruptImageBuilding("Interrupted while checking Wasm assembler " + String.valueOf(executablePath));
        }
        catch (IOException e) {
            throw UserError.abort((Throwable)e, (String)"Collecting Wasm assembler info failed", (Object[])new Object[0]);
        }
        return new AssemblerInfo(executablePath, versionString);
    }

    private Path getAssemblerPath() {
        Path executablePath;
        HostedOptionKey<String> pathOption = this.getPathOption();
        String userDefinedPath = (String)pathOption.getValue();
        if (userDefinedPath != null) {
            executablePath = Paths.get(userDefinedPath, new String[0]);
        } else {
            String executableName = this.asExecutableName(this.getExecutable());
            Optional optPath = CCompilerInvoker.lookupSearchPath((String)executableName);
            if (optPath.isPresent()) {
                executablePath = (Path)optPath.get();
            } else {
                throw UserError.abort((String)"'%s' not found on the system path. Please extend the PATH environment variable so that it provides a Wasm assembler executable called '%s'.", (Object[])new Object[]{executableName, executableName});
            }
        }
        if (Files.isDirectory(executablePath, new LinkOption[0]) || !Files.isExecutable(executablePath)) {
            Object msgSubject = userDefinedPath != null ? SubstrateOptionsParser.commandArgument(pathOption, (String)userDefinedPath) : "Default Wasm assembler '" + String.valueOf(executablePath) + "'";
            throw UserError.abort((String)"%s does not specify a path to an executable.", (Object[])new Object[]{msgSubject});
        }
        return executablePath;
    }

    protected String asExecutableName(String basename) {
        String suffix;
        if (OS.WINDOWS.isCurrent() && !basename.endsWith(suffix = ".exe")) {
            return basename + suffix;
        }
        return basename;
    }

    private List<String> createAssemblerFlags(List<String> flags, Path output, Path input) {
        ArrayList<String> command = new ArrayList<String>(flags);
        if (output != null) {
            command.addAll(this.getOutputFlags(output));
        }
        if (input != null) {
            command.add(input.toString());
        }
        return command;
    }

    public record AssemblerInfo(Path assemblerPath, String versionString) {
    }

    public static class Binaryen
    extends WasmAssembler {
        protected Binaryen(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        protected String getExecutable() {
            return "wasm-as";
        }

        @Override
        protected HostedOptionKey<String> getPathOption() {
            return Options.WasmAsPath;
        }

        @Override
        protected String getDebugNamesFlag() {
            return "-g";
        }

        @Override
        protected List<String> getOutputFlags(Path wasmPath) {
            return Collections.singletonList("--output=" + String.valueOf(wasmPath));
        }

        @Override
        protected List<String> getExtraFlags() {
            return List.of("--enable-exception-handling", "--enable-nontrapping-float-to-int", "--enable-bulk-memory", "--enable-reference-types", "--enable-gc");
        }

        @Override
        protected String getVerificationFile() {
            return "verify-wasm-as.wast";
        }
    }

    public static class Wat2Wasm
    extends WasmAssembler {
        protected Wat2Wasm(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        protected String getExecutable() {
            return "wat2wasm";
        }

        @Override
        protected HostedOptionKey<String> getPathOption() {
            return Options.Wat2WasmPath;
        }

        @Override
        protected String getDebugNamesFlag() {
            return "--debug-names";
        }

        @Override
        protected List<String> getOutputFlags(Path wasmPath) {
            return Collections.singletonList("--output=" + String.valueOf(wasmPath));
        }

        @Override
        protected List<String> getExtraFlags() {
            return List.of("--enable-exceptions", "--enable-function-references");
        }

        @Override
        protected String getVerificationFile() {
            return "verify-wat2wasm.wast";
        }
    }

    public record RunResult(Path executable, List<String> commandLine, List<String> outputLines, int exitCode) {
    }

    public static class Options {
        public static final HostedOptionKey<String> Wat2WasmPath = new HostedOptionKey(null, Options::validateWat2WasmPath);
        public static final HostedOptionKey<String> WasmAsPath = new HostedOptionKey(null, Options::validateWasmWasPath);

        private static void validateWat2WasmPath(HostedOptionKey<String> optionKey) {
            if (optionKey.hasBeenSet() && BinaryenCompat.usesBinaryen()) {
                throw UserError.abort((String)"The option %s cannot be used if Binaryen is enabled (%s)", (Object[])new Object[]{optionKey.getName(), SubstrateOptionsParser.commandArgument(BinaryenCompat.Options.UseBinaryen, (String)"+")});
            }
        }

        private static void validateWasmWasPath(HostedOptionKey<String> optionKey) {
            if (optionKey.hasBeenSet() && !BinaryenCompat.usesBinaryen()) {
                throw UserError.abort((String)"The option %s can only be used if Binaryen is enabled (%s)", (Object[])new Object[]{optionKey.getName(), SubstrateOptionsParser.commandArgument(BinaryenCompat.Options.UseBinaryen, (String)"+")});
            }
        }
    }
}

