/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.visitors;

import com.oracle.svm.hosted.webimage.wasm.ast.Data;
import com.oracle.svm.hosted.webimage.wasm.ast.Export;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Global;
import com.oracle.svm.hosted.webimage.wasm.ast.Import;
import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.Memory;
import com.oracle.svm.hosted.webimage.wasm.ast.ModuleField;
import com.oracle.svm.hosted.webimage.wasm.ast.StartFunction;
import com.oracle.svm.hosted.webimage.wasm.ast.Table;
import com.oracle.svm.hosted.webimage.wasm.ast.Tag;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.WasmModule;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasmgc.ast.ArrayType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.FunctionType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.RecursiveGroup;
import com.oracle.svm.hosted.webimage.wasmgc.ast.StructType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.TypeDefinition;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmStorageType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import jdk.graal.compiler.debug.GraalError;

public abstract class WasmVisitor {
    protected WasmModule module;

    public void visitModule(WasmModule m) {
        this.module = m;
        for (Iterator<Tag> importDecl : m.getImports().values()) {
            this.visitModuleField((ModuleField)((Object)importDecl));
            this.visitImport((Import)((Object)importDecl));
        }
        Memory memory = m.getMemory();
        if (memory != null) {
            this.visitModuleField(memory);
            this.visitMemory(memory);
        }
        for (RecursiveGroup def : m.getRecursiveGroups()) {
            assert (def.size() > 0) : "Empty recursive group";
            if (def.size() == 1) {
                this.visitSingletonRecursiveGroup(def);
                continue;
            }
            this.visitModuleField(def);
            this.visitRecursiveGroup(def);
        }
        for (Tag tag : m.getTags()) {
            this.visitModuleField(tag);
            this.visitTag(tag);
        }
        for (Global global : m.getGlobals().sequencedValues()) {
            this.visitModuleField(global);
            this.visitGlobal(global);
        }
        for (Export export : m.getExports().sequencedValues()) {
            this.visitModuleField(export);
            this.visitExport(export);
        }
        StartFunction startFunction = m.getStartFunction();
        if (startFunction != null) {
            this.visitModuleField(startFunction);
            this.visitStartFunction(startFunction);
        }
        for (Table table : m.getTables()) {
            this.visitModuleField(table);
            this.visitTable(table);
        }
        for (Function function : m.getFunctions()) {
            this.visitModuleField(function);
            this.visitFunction(function);
        }
        for (Data data : m.getDataSegments()) {
            this.visitModuleField(data);
            this.visitData(data);
        }
        this.module = null;
    }

    protected void visitId(WasmId id) {
        if (id instanceof WasmId.Variable) {
            WasmId.Variable variable = (WasmId.Variable)id;
            this.visitType(variable.getVariableType());
        }
    }

    protected void visitType(WasmStorageType type) {
        if (type instanceof WasmRefType.TypeIndex) {
            WasmRefType.TypeIndex typeIndex = (WasmRefType.TypeIndex)type;
            this.visitId(typeIndex.id);
        }
    }

    protected void visitTypeUse(TypeUse typeUse) {
        typeUse.params.forEach(this::visitType);
        typeUse.results.forEach(this::visitType);
    }

    public void visitModuleField(ModuleField f) {
    }

    public void visitMemory(Memory m) {
    }

    public void visitData(Data data) {
        this.visitId(data.id);
    }

    public void visitTypeDefinition(TypeDefinition def) {
        this.visitId(def.getId());
        this.visitId(def.supertype);
        TypeDefinition typeDefinition = def;
        Objects.requireNonNull(typeDefinition);
        TypeDefinition typeDefinition2 = typeDefinition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StructType.class, ArrayType.class, FunctionType.class}, (Object)typeDefinition2, n)) {
            case 0: {
                StructType structType = (StructType)typeDefinition2;
                this.visitStructTypeDefinition(structType);
                break;
            }
            case 1: {
                ArrayType arrayType = (ArrayType)typeDefinition2;
                this.visitArrayTypeDefinition(arrayType);
                break;
            }
            case 2: {
                FunctionType functionType = (FunctionType)typeDefinition2;
                this.visitFunctionTypeDefinition(functionType);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)def.toString());
            }
        }
    }

    public void visitStructTypeDefinition(StructType structType) {
        for (StructType.Field field : structType.fields) {
            this.visitId(field.id);
            this.visitType(field.fieldType.storageType);
        }
    }

    public void visitArrayTypeDefinition(ArrayType arrayType) {
        this.visitType(arrayType.elementType.storageType);
    }

    public void visitFunctionTypeDefinition(FunctionType functionType) {
        this.visitTypeUse(functionType.typeUse);
    }

    public void visitSingletonRecursiveGroup(RecursiveGroup def) {
        assert (def.size() == 1) : def.size();
        TypeDefinition typeDefinition = def.getTypeDefinitions().getFirst();
        this.visitModuleField(typeDefinition);
        this.visitTypeDefinition(typeDefinition);
    }

    public void visitRecursiveGroup(RecursiveGroup def) {
        for (TypeDefinition typeDefinition : def.getTypeDefinitions()) {
            this.visitModuleField(typeDefinition);
            this.visitTypeDefinition(typeDefinition);
        }
    }

    public void visitTag(Tag tag) {
        this.visitId(tag.id);
    }

    public void visitGlobal(Global global) {
        this.visitId(global.getId());
        this.visitInstruction(global.init);
    }

    public void visitImport(Import importDecl) {
        this.visitId(importDecl.getId());
        ImportDescriptor importDescriptor = importDecl.getDescriptor();
        Objects.requireNonNull(importDescriptor);
        ImportDescriptor importDescriptor2 = importDescriptor;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImportDescriptor.Function.class}, (Object)importDescriptor2, n)) {
            case 0: {
                ImportDescriptor.Function functionImport = (ImportDescriptor.Function)importDescriptor2;
                this.visitFunImport(functionImport);
                break;
            }
            default: {
                throw GraalError.unimplemented((String)("Import: " + String.valueOf(importDecl)));
            }
        }
    }

    public void visitFunImport(ImportDescriptor.Function funcImport) {
        this.visitTypeUse(funcImport.typeUse);
    }

    public void visitExport(Export e) {
        this.visitId(e.getId());
    }

    public void visitStartFunction(StartFunction startFunction) {
        this.visitId(startFunction.function);
    }

    public void visitFunction(Function f) {
        this.visitId(f.getId());
        this.visitId(f.getFuncType());
        f.getParams().forEach(this::visitId);
        f.getLocals().forEach(this::visitId);
        f.getResults().forEach(this::visitType);
        this.visitInstructions(f.getInstructions());
    }

    public void visitTable(Table t) {
        this.visitId(t.id);
        this.visitType(t.elementType);
        if (t.elements != null) {
            for (Instruction element : t.elements) {
                this.visitInstruction(element);
            }
        }
    }

    public void visitInstructions(Instructions instructions) {
        for (Instruction instruction : instructions) {
            this.visitInstruction(instruction);
        }
    }

    protected void maybeVisitInstruction(Instruction inst) {
        if (inst != null) {
            this.visitInstruction(inst);
        }
    }

    public void visitInstruction(Instruction inst) {
        Instruction instruction = inst;
        Objects.requireNonNull(instruction);
        Instruction instruction2 = instruction;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instruction.Block.class, Instruction.Loop.class, Instruction.If.class, Instruction.Try.class, Instruction.Nop.class, Instruction.Unreachable.class, Instruction.Break.class, Instruction.Return.class, Instruction.LocalGet.class, Instruction.LocalSet.class, Instruction.LocalTee.class, Instruction.GlobalGet.class, Instruction.GlobalSet.class, Instruction.Const.class, Instruction.Relocation.class, Instruction.Binary.class, Instruction.Unary.class, Instruction.Call.class, Instruction.CallRef.class, Instruction.CallIndirect.class, Instruction.Throw.class, Instruction.Drop.class, Instruction.Select.class, Instruction.BreakTable.class, Instruction.TableGet.class, Instruction.TableSet.class, Instruction.TableSize.class, Instruction.TableGrow.class, Instruction.TableFill.class, Instruction.TableCopy.class, Instruction.Load.class, Instruction.Store.class, Instruction.MemorySize.class, Instruction.MemoryGrow.class, Instruction.MemoryFill.class, Instruction.MemoryCopy.class, Instruction.MemoryInit.class, Instruction.DataDrop.class, Instruction.RefNull.class, Instruction.RefFunc.class, Instruction.RefTest.class, Instruction.RefCast.class, Instruction.StructNew.class, Instruction.StructGet.class, Instruction.StructSet.class, Instruction.ArrayNew.class, Instruction.ArrayNewFixed.class, Instruction.ArrayNewData.class, Instruction.ArrayLen.class, Instruction.ArrayFill.class, Instruction.ArrayGet.class, Instruction.ArraySet.class, Instruction.ArrayCopy.class, Instruction.ArrayInitData.class, Instruction.AnyExternConversion.class}, (Object)instruction2, n)) {
            case 0: {
                Instruction.Block i = (Instruction.Block)instruction2;
                this.visitBlockInstr(i);
                this.visitBlock(i);
                break;
            }
            case 1: {
                Instruction.Loop i = (Instruction.Loop)instruction2;
                this.visitBlockInstr(i);
                this.visitLoop(i);
                break;
            }
            case 2: {
                Instruction.If i = (Instruction.If)instruction2;
                this.visitBlockInstr(i);
                this.visitIf(i);
                break;
            }
            case 3: {
                Instruction.Try i = (Instruction.Try)instruction2;
                this.visitBlockInstr(i);
                this.visitTry(i);
                break;
            }
            case 4: {
                Instruction.Nop i = (Instruction.Nop)instruction2;
                this.visitNop(i);
                break;
            }
            case 5: {
                Instruction.Unreachable i = (Instruction.Unreachable)instruction2;
                this.visitUnreachable(i);
                break;
            }
            case 6: {
                Instruction.Break i = (Instruction.Break)instruction2;
                this.visitBreak(i);
                break;
            }
            case 7: {
                Instruction.Return i = (Instruction.Return)instruction2;
                this.visitReturn(i);
                break;
            }
            case 8: {
                Instruction.LocalGet i = (Instruction.LocalGet)instruction2;
                this.visitLocalGet(i);
                break;
            }
            case 9: {
                Instruction.LocalSet i = (Instruction.LocalSet)instruction2;
                this.visitLocalSet(i);
                break;
            }
            case 10: {
                Instruction.LocalTee i = (Instruction.LocalTee)instruction2;
                this.visitLocalTee(i);
                break;
            }
            case 11: {
                Instruction.GlobalGet i = (Instruction.GlobalGet)instruction2;
                this.visitGlobalGet(i);
                break;
            }
            case 12: {
                Instruction.GlobalSet i = (Instruction.GlobalSet)instruction2;
                this.visitGlobalSet(i);
                break;
            }
            case 13: {
                Instruction.Const i = (Instruction.Const)instruction2;
                this.visitConst(i);
                break;
            }
            case 14: {
                Instruction.Relocation i = (Instruction.Relocation)instruction2;
                this.visitRelocation(i);
                break;
            }
            case 15: {
                Instruction.Binary i = (Instruction.Binary)instruction2;
                this.visitBinary(i);
                break;
            }
            case 16: {
                Instruction.Unary i = (Instruction.Unary)instruction2;
                this.visitUnary(i);
                break;
            }
            case 17: {
                Instruction.Call i = (Instruction.Call)instruction2;
                this.visitCall(i);
                break;
            }
            case 18: {
                Instruction.CallRef i = (Instruction.CallRef)instruction2;
                this.visitCallRef(i);
                break;
            }
            case 19: {
                Instruction.CallIndirect i = (Instruction.CallIndirect)instruction2;
                this.visitCallIndirect(i);
                break;
            }
            case 20: {
                Instruction.Throw i = (Instruction.Throw)instruction2;
                this.visitThrow(i);
                break;
            }
            case 21: {
                Instruction.Drop i = (Instruction.Drop)instruction2;
                this.visitDrop(i);
                break;
            }
            case 22: {
                Instruction.Select i = (Instruction.Select)instruction2;
                this.visitSelect(i);
                break;
            }
            case 23: {
                Instruction.BreakTable i = (Instruction.BreakTable)instruction2;
                this.visitBreakTable(i);
                break;
            }
            case 24: {
                Instruction.TableGet i = (Instruction.TableGet)instruction2;
                this.visitTableGet(i);
                break;
            }
            case 25: {
                Instruction.TableSet i = (Instruction.TableSet)instruction2;
                this.visitTableSet(i);
                break;
            }
            case 26: {
                Instruction.TableSize i = (Instruction.TableSize)instruction2;
                this.visitTableSize(i);
                break;
            }
            case 27: {
                Instruction.TableGrow i = (Instruction.TableGrow)instruction2;
                this.visitTableGrow(i);
                break;
            }
            case 28: {
                Instruction.TableFill i = (Instruction.TableFill)instruction2;
                this.visitTableFill(i);
                break;
            }
            case 29: {
                Instruction.TableCopy i = (Instruction.TableCopy)instruction2;
                this.visitTableCopy(i);
                break;
            }
            case 30: {
                Instruction.Load i = (Instruction.Load)instruction2;
                this.visitLoad(i);
                break;
            }
            case 31: {
                Instruction.Store i = (Instruction.Store)instruction2;
                this.visitStore(i);
                break;
            }
            case 32: {
                Instruction.MemorySize i = (Instruction.MemorySize)instruction2;
                this.visitMemorySize(i);
                break;
            }
            case 33: {
                Instruction.MemoryGrow i = (Instruction.MemoryGrow)instruction2;
                this.visitMemoryGrow(i);
                break;
            }
            case 34: {
                Instruction.MemoryFill i = (Instruction.MemoryFill)instruction2;
                this.visitMemoryFill(i);
                break;
            }
            case 35: {
                Instruction.MemoryCopy i = (Instruction.MemoryCopy)instruction2;
                this.visitMemoryCopy(i);
                break;
            }
            case 36: {
                Instruction.MemoryInit i = (Instruction.MemoryInit)instruction2;
                this.visitMemoryInit(i);
                break;
            }
            case 37: {
                Instruction.DataDrop i = (Instruction.DataDrop)instruction2;
                this.visitDataDrop(i);
                break;
            }
            case 38: {
                Instruction.RefNull i = (Instruction.RefNull)instruction2;
                this.visitRefNull(i);
                break;
            }
            case 39: {
                Instruction.RefFunc i = (Instruction.RefFunc)instruction2;
                this.visitRefFunc(i);
                break;
            }
            case 40: {
                Instruction.RefTest i = (Instruction.RefTest)instruction2;
                this.visitRefTest(i);
                break;
            }
            case 41: {
                Instruction.RefCast i = (Instruction.RefCast)instruction2;
                this.visitRefCast(i);
                break;
            }
            case 42: {
                Instruction.StructNew i = (Instruction.StructNew)instruction2;
                this.visitStructNew(i);
                break;
            }
            case 43: {
                Instruction.StructGet i = (Instruction.StructGet)instruction2;
                this.visitStructGet(i);
                break;
            }
            case 44: {
                Instruction.StructSet i = (Instruction.StructSet)instruction2;
                this.visitStructSet(i);
                break;
            }
            case 45: {
                Instruction.ArrayNew i = (Instruction.ArrayNew)instruction2;
                this.visitArrayNew(i);
                break;
            }
            case 46: {
                Instruction.ArrayNewFixed i = (Instruction.ArrayNewFixed)instruction2;
                this.visitArrayNewFixed(i);
                break;
            }
            case 47: {
                Instruction.ArrayNewData i = (Instruction.ArrayNewData)instruction2;
                this.visitArrayNewData(i);
                break;
            }
            case 48: {
                Instruction.ArrayLen i = (Instruction.ArrayLen)instruction2;
                this.visitArrayLen(i);
                break;
            }
            case 49: {
                Instruction.ArrayFill i = (Instruction.ArrayFill)instruction2;
                this.visitArrayFill(i);
                break;
            }
            case 50: {
                Instruction.ArrayGet i = (Instruction.ArrayGet)instruction2;
                this.visitArrayGet(i);
                break;
            }
            case 51: {
                Instruction.ArraySet i = (Instruction.ArraySet)instruction2;
                this.visitArraySet(i);
                break;
            }
            case 52: {
                Instruction.ArrayCopy i = (Instruction.ArrayCopy)instruction2;
                this.visitArrayCopy(i);
                break;
            }
            case 53: {
                Instruction.ArrayInitData i = (Instruction.ArrayInitData)instruction2;
                this.visitArrayInitData(i);
                break;
            }
            case 54: {
                Instruction.AnyExternConversion i = (Instruction.AnyExternConversion)instruction2;
                this.visitAnyExternConversion(i);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)inst.toString());
            }
        }
    }

    public void visitBlockInstr(Instruction.WasmBlock block) {
        this.visitId(block.getLabel());
    }

    public void visitBlock(Instruction.Block block) {
        this.visitInstructions(block.instructions);
    }

    public void visitLoop(Instruction.Loop loop) {
        this.visitInstructions(loop.instructions);
    }

    public void visitIf(Instruction.If ifBlock) {
        this.visitInstruction(ifBlock.condition);
        this.visitInstructions(ifBlock.thenInstructions);
        if (ifBlock.hasElse()) {
            this.visitInstructions(ifBlock.elseInstructions);
        }
    }

    public void visitTry(Instruction.Try tryBlock) {
        for (Instruction.Try.Catch catchBlock : tryBlock.catchBlocks) {
            this.visitId(catchBlock.tag);
        }
        this.visitInstructions(tryBlock.instructions);
        for (Instruction.Try.Catch catchBlock : tryBlock.catchBlocks) {
            this.visitInstructions(catchBlock.instructions);
        }
    }

    public void visitNop(Instruction.Nop inst) {
    }

    public void visitUnreachable(Instruction.Unreachable unreachable) {
    }

    public void visitBreak(Instruction.Break inst) {
        this.visitId(inst.getTarget());
        this.maybeVisitInstruction(inst.condition);
    }

    public void visitBreakTable(Instruction.BreakTable inst) {
        this.visitId(inst.getDefaultTarget());
        for (int i = 0; i < inst.numTargets(); ++i) {
            this.visitId(inst.getTarget(i));
        }
        this.visitInstruction(inst.index);
    }

    public void visitReturn(Instruction.Return ret) {
        this.maybeVisitInstruction(ret.result);
    }

    public void visitLocalGet(Instruction.LocalGet localGet) {
        this.visitId(localGet.getLocal());
    }

    public void visitLocalSet(Instruction.LocalSet localSet) {
        this.visitId(localSet.getLocal());
        this.visitInstruction(localSet.value);
    }

    public void visitLocalTee(Instruction.LocalTee localTee) {
        this.visitId(localTee.getLocal());
        this.visitInstruction(localTee.value);
    }

    public void visitGlobalGet(Instruction.GlobalGet globalGet) {
        this.visitId(globalGet.getGlobal());
    }

    public void visitGlobalSet(Instruction.GlobalSet globalSet) {
        this.visitId(globalSet.getGlobal());
        this.visitInstruction(globalSet.value);
    }

    public void visitConst(Instruction.Const constValue) {
    }

    public void visitRelocation(Instruction.Relocation relocation) {
        if (relocation.wasProcessed()) {
            this.visitInstruction(relocation.getValue());
        }
    }

    public void visitCall(Instruction.Call inst) {
        this.visitId(inst.getTarget());
        this.visitInstructions(inst.args);
    }

    public void visitCallRef(Instruction.CallRef inst) {
        this.visitId(inst.functionType);
        this.visitInstructions(inst.args);
        this.visitInstruction(inst.functionReference);
    }

    public void visitCallIndirect(Instruction.CallIndirect inst) {
        this.visitId(inst.table);
        this.visitId(inst.funcId);
        this.visitInstructions(inst.args);
        this.visitInstruction(inst.index);
    }

    public void visitThrow(Instruction.Throw inst) {
        this.visitId(inst.tag);
        this.visitInstructions(inst.arguments);
    }

    public void visitBinary(Instruction.Binary inst) {
        this.visitType(inst.op.leftInputType);
        this.visitType(inst.op.rightInputType);
        this.visitType(inst.op.outputType);
        this.visitInstruction(inst.left);
        this.visitInstruction(inst.right);
    }

    public void visitUnary(Instruction.Unary inst) {
        this.visitType(inst.op.inputType);
        this.visitType(inst.op.outputType);
        this.visitInstruction(inst.value);
    }

    public void visitDrop(Instruction.Drop inst) {
        this.visitInstruction(inst.value);
    }

    public void visitSelect(Instruction.Select inst) {
        this.visitType(inst.type);
        this.visitInstruction(inst.trueValue);
        this.visitInstruction(inst.falseValue);
        this.visitInstruction(inst.condition);
    }

    public void visitTableGet(Instruction.TableGet inst) {
        this.visitId(inst.table);
        this.visitInstruction(inst.index);
    }

    public void visitTableSet(Instruction.TableSet inst) {
        this.visitId(inst.table);
        this.visitInstruction(inst.index);
        this.visitInstruction(inst.value);
    }

    public void visitTableSize(Instruction.TableSize inst) {
        this.visitId(inst.table);
    }

    public void visitTableGrow(Instruction.TableGrow inst) {
        this.visitId(inst.table);
        this.visitInstruction(inst.initValue);
        this.visitInstruction(inst.delta);
    }

    public void visitTableFill(Instruction.TableFill inst) {
        this.visitId(inst.table);
        this.visitInstruction(inst.offset);
        this.visitInstruction(inst.value);
        this.visitInstruction(inst.size);
    }

    public void visitTableCopy(Instruction.TableCopy inst) {
        this.visitId(inst.destTable);
        this.visitId(inst.srcTable);
        this.visitInstruction(inst.destOffset);
        this.visitInstruction(inst.srcOffset);
        this.visitInstruction(inst.size);
    }

    public void visitLoad(Instruction.Load inst) {
        this.visitInstruction(inst.getOffset());
        this.visitInstruction(inst.baseAddress);
    }

    public void visitStore(Instruction.Store inst) {
        this.visitInstruction(inst.getOffset());
        this.visitInstruction(inst.baseAddress);
        this.visitInstruction(inst.value);
    }

    public void visitMemorySize(Instruction.MemorySize inst) {
    }

    public void visitMemoryGrow(Instruction.MemoryGrow inst) {
        this.visitInstruction(inst.numPages);
    }

    public void visitMemoryFill(Instruction.MemoryFill inst) {
        this.visitInstruction(inst.start);
        this.visitInstruction(inst.fillValue);
        this.visitInstruction(inst.size);
    }

    public void visitMemoryCopy(Instruction.MemoryCopy inst) {
        this.visitInstruction(inst.destOffset);
        this.visitInstruction(inst.srcOffset);
        this.visitInstruction(inst.size);
    }

    public void visitMemoryInit(Instruction.MemoryInit inst) {
        this.visitId(inst.dataSegment);
        this.visitInstruction(inst.destOffset);
        this.visitInstruction(inst.srcOffset);
        this.visitInstruction(inst.size);
    }

    public void visitDataDrop(Instruction.DataDrop inst) {
        this.visitId(inst.dataSegment);
    }

    public void visitRefNull(Instruction.RefNull inst) {
        this.visitType(inst.heapType);
    }

    public void visitRefFunc(Instruction.RefFunc inst) {
        this.visitId(inst.func);
    }

    public void visitRefTest(Instruction.RefTest inst) {
        this.visitType(inst.testType);
        this.visitInstruction(inst.input);
    }

    public void visitRefCast(Instruction.RefCast inst) {
        this.visitType(inst.newType);
        this.visitInstruction(inst.input);
    }

    public void visitStructNew(Instruction.StructNew inst) {
        this.visitId(inst.type);
        if (!inst.isDefault()) {
            this.visitInstructions(inst.getFieldValues());
        }
    }

    public void visitStructGet(Instruction.StructGet inst) {
        this.visitId(inst.refType);
        this.visitId(inst.fieldId);
        this.visitInstruction(inst.ref);
    }

    public void visitStructSet(Instruction.StructSet inst) {
        this.visitId(inst.refType);
        this.visitId(inst.fieldId);
        this.visitInstruction(inst.ref);
        this.visitInstruction(inst.value);
    }

    public void visitArrayNew(Instruction.ArrayNew inst) {
        this.visitId(inst.type);
        if (!inst.isDefault()) {
            this.visitInstruction(inst.getElementValue());
        }
        this.visitInstruction(inst.length);
    }

    public void visitArrayNewFixed(Instruction.ArrayNewFixed inst) {
        this.visitId(inst.type);
        this.visitInstructions(inst.elementValues);
    }

    public void visitArrayNewData(Instruction.ArrayNewData inst) {
        this.visitId(inst.type);
        this.visitId(inst.dataSegment);
        this.visitInstruction(inst.offset);
        this.visitInstruction(inst.size);
    }

    public void visitArrayLen(Instruction.ArrayLen inst) {
        this.visitInstruction(inst.ref);
    }

    public void visitArrayFill(Instruction.ArrayFill inst) {
        this.visitId(inst.arrayType);
        this.visitInstruction(inst.array);
        this.visitInstruction(inst.offset);
        this.visitInstruction(inst.value);
        this.visitInstruction(inst.size);
    }

    public void visitArrayGet(Instruction.ArrayGet inst) {
        this.visitId(inst.refType);
        this.visitInstruction(inst.ref);
        this.visitInstruction(inst.idx);
    }

    public void visitArraySet(Instruction.ArraySet inst) {
        this.visitId(inst.refType);
        this.visitInstruction(inst.ref);
        this.visitInstruction(inst.idx);
        this.visitInstruction(inst.value);
    }

    public void visitArrayCopy(Instruction.ArrayCopy inst) {
        this.visitId(inst.destType);
        this.visitId(inst.srcType);
        this.visitInstruction(inst.dest);
        this.visitInstruction(inst.destOffset);
        this.visitInstruction(inst.src);
        this.visitInstruction(inst.srcOffset);
        this.visitInstruction(inst.size);
    }

    public void visitArrayInitData(Instruction.ArrayInitData inst) {
        this.visitId(inst.type);
        this.visitId(inst.dataSegment);
        this.visitInstruction(inst.dest);
        this.visitInstruction(inst.destOffset);
        this.visitInstruction(inst.srcOffset);
        this.visitInstruction(inst.size);
    }

    public void visitAnyExternConversion(Instruction.AnyExternConversion inst) {
        this.visitInstruction(inst.input);
    }
}

