/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.visitors;

import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import com.oracle.svm.hosted.webimage.wasm.ast.Data;
import com.oracle.svm.hosted.webimage.wasm.ast.Export;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Global;
import com.oracle.svm.hosted.webimage.wasm.ast.Import;
import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Limit;
import com.oracle.svm.hosted.webimage.wasm.ast.Literal;
import com.oracle.svm.hosted.webimage.wasm.ast.Memory;
import com.oracle.svm.hosted.webimage.wasm.ast.ModuleField;
import com.oracle.svm.hosted.webimage.wasm.ast.StartFunction;
import com.oracle.svm.hosted.webimage.wasm.ast.Table;
import com.oracle.svm.hosted.webimage.wasm.ast.Tag;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.WasmModule;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmVisitor;
import com.oracle.svm.hosted.webimage.wasm.codegen.BinaryenCompat;
import com.oracle.svm.hosted.webimage.wasmgc.ast.ArrayType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.FieldType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.FunctionType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.RecursiveGroup;
import com.oracle.svm.hosted.webimage.wasmgc.ast.StructType;
import com.oracle.svm.hosted.webimage.wasmgc.ast.TypeDefinition;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmPackedType;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmStorageType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.site.Reference;

public class WasmPrinter
extends WasmVisitor {
    private static final int INDENT_SIZE = 2;
    private final WriterWrapper writer;

    public WasmPrinter(Writer writer) {
        this.writer = new WriterWrapper(writer);
    }

    private void print(String str) {
        this.writer.print(str);
    }

    private void print(char c) {
        this.writer.print(c);
    }

    private void newline() {
        this.writer.newline();
    }

    private void space() {
        this.print(' ');
    }

    private void parenOpen() {
        this.parenOpen(null);
    }

    private void parenOpen(String op) {
        this.print('(');
        if (op != null) {
            this.print(op);
        }
    }

    private void parenClose() {
        this.print(')');
    }

    private void printId(String id) {
        String validPattern = "^[0-9A-Za-z!#$%&'*+\\-./:<=>?@\\\\^_`|~]+$";
        GraalError.guarantee((boolean)id.matches(validPattern), (String)"Id contains invalid character: %s", (Object)id);
        this.print('$');
        this.print(id);
    }

    private void printId(WasmId id) {
        if (id == null) {
            this.forcePrintComment("no id");
        } else {
            assert (id.isResolved()) : "Unresolved Id found: " + String.valueOf(id);
            this.printId(id.getName());
            this.printVerboseComment(id);
        }
    }

    private void printString(String str) {
        GraalError.guarantee((!str.matches("[\u0000-\u001f\u007f\"\\\\]") ? 1 : 0) != 0, (String)"String does not contain invalid characters: '%s'", (Object)str);
        this.print('\"');
        this.print(str);
        this.print('\"');
    }

    private void printInt(int i) {
        this.print(Integer.toString(i));
    }

    private void printHeapType(WasmRefType refType) {
        if (refType instanceof WasmRefType.AbsHeap) {
            WasmRefType.AbsHeap absHeapType = (WasmRefType.AbsHeap)refType;
            this.print(switch (absHeapType.kind) {
                default -> throw new MatchException(null, null);
                case WasmRefType.Kind.ANY -> "any";
                case WasmRefType.Kind.EQ -> "eq";
                case WasmRefType.Kind.I31 -> "i31";
                case WasmRefType.Kind.STRUCT -> "struct";
                case WasmRefType.Kind.ARRAY -> "array";
                case WasmRefType.Kind.NONE -> "none";
                case WasmRefType.Kind.FUNC -> "func";
                case WasmRefType.Kind.NOFUNC -> "nofunc";
                case WasmRefType.Kind.EXTERN -> "extern";
                case WasmRefType.Kind.NOEXTERN -> "noextern";
            });
        } else if (refType instanceof WasmRefType.TypeIndex) {
            WasmRefType.TypeIndex typeIndex = (WasmRefType.TypeIndex)refType;
            this.printId(typeIndex.id);
        } else {
            throw GraalError.shouldNotReachHereUnexpectedValue((Object)refType);
        }
    }

    private void printType(WasmStorageType type) {
        WasmStorageType wasmStorageType = type;
        Objects.requireNonNull(wasmStorageType);
        WasmStorageType wasmStorageType2 = wasmStorageType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WasmPrimitiveType.class, WasmRefType.class, WasmPackedType.class}, (Object)wasmStorageType2, n)) {
            case 0: {
                WasmPrimitiveType primitiveType = (WasmPrimitiveType)wasmStorageType2;
                this.print(primitiveType.name());
                break;
            }
            case 1: {
                WasmRefType refType = (WasmRefType)wasmStorageType2;
                if (refType.nullable && refType instanceof WasmRefType.AbsHeap) {
                    WasmRefType.AbsHeap absHeapType = (WasmRefType.AbsHeap)refType;
                    this.print(switch (absHeapType.kind) {
                        default -> throw new MatchException(null, null);
                        case WasmRefType.Kind.ANY -> "anyref";
                        case WasmRefType.Kind.EQ -> "eqref";
                        case WasmRefType.Kind.I31 -> "i31ref";
                        case WasmRefType.Kind.STRUCT -> "structref";
                        case WasmRefType.Kind.ARRAY -> "arrayref";
                        case WasmRefType.Kind.NONE -> "nullref";
                        case WasmRefType.Kind.FUNC -> "funcref";
                        case WasmRefType.Kind.NOFUNC -> "nullfuncref";
                        case WasmRefType.Kind.EXTERN -> "externref";
                        case WasmRefType.Kind.NOEXTERN -> "nullexternref";
                    });
                    break;
                }
                this.parenOpen("ref");
                if (refType.nullable) {
                    this.space();
                    this.print("null");
                }
                this.space();
                this.printHeapType(refType);
                this.parenClose();
                break;
            }
            case 2: {
                WasmPackedType packedType = (WasmPackedType)wasmStorageType2;
                this.print(packedType.name());
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)type);
            }
        }
    }

    private void printLocal(boolean isParam, WasmId.Local id, WasmValType type) {
        this.parenOpen(isParam ? "param" : "local");
        if (id != null) {
            this.space();
            this.printId(id);
        }
        this.space();
        this.printType(type);
        this.parenClose();
    }

    private void printParam(WasmId.Local id, WasmValType type) {
        this.printLocal(true, id, type);
    }

    private void printParam(WasmId.Local param) {
        this.printParam(param, param.getVariableType());
    }

    private void printTypeUse(TypeUse typeUse) {
        for (WasmValType param : typeUse.params) {
            this.space();
            this.printParam(null, param);
        }
        for (WasmValType result : typeUse.results) {
            this.space();
            this.printResult(result);
        }
    }

    private void printLocal(WasmId.Local local) {
        this.printLocal(false, local, local.getVariableType());
    }

    private void printResult(WasmValType type) {
        this.parenOpen("result");
        this.space();
        this.printType(type);
        this.parenClose();
    }

    private void forcePrintComment(Object comment) {
        this.printComment(comment, WebImageOptions.CommentVerbosity.NONE);
    }

    private boolean printComment(Object comment) {
        return this.printComment(comment, WebImageOptions.CommentVerbosity.NORMAL);
    }

    private boolean printVerboseComment(Object comment) {
        return this.printComment(comment, WebImageOptions.CommentVerbosity.VERBOSE);
    }

    private boolean printComment(Object comment, WebImageOptions.CommentVerbosity requiredVerbosity) {
        if (!WebImageWasmOptions.genComments(requiredVerbosity) || comment == null) {
            return false;
        }
        this.print("(; ");
        this.print(comment.toString().replace("(;", "??").replace(";)", "??").replaceAll("[^\\x20-\\x7F]", "?"));
        this.print(" ;)");
        return true;
    }

    private void printLimit(Limit limit) {
        this.printInt(limit.getMin());
        if (limit.hasMax()) {
            this.space();
            this.printInt(limit.getMax());
        }
    }

    private void printExtensionSuffix(WasmUtil.Extension extension) {
        switch (extension) {
            case None: {
                break;
            }
            case Sign: {
                this.print("_s");
                break;
            }
            case Zero: {
                this.print("_u");
            }
        }
    }

    @Override
    public void visitModule(WasmModule m) {
        this.parenOpen("module");
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitModule(m);
        }
        this.newline();
        this.print(')');
        this.newline();
    }

    @Override
    public void visitModuleField(ModuleField f) {
        this.newline();
        this.newline();
        if (this.printComment(f.getComment())) {
            this.newline();
        }
        super.visitModuleField(f);
    }

    @Override
    public void visitMemory(Memory m) {
        this.parenOpen("memory");
        this.space();
        this.printId(m.id);
        this.space();
        this.printLimit(m.limit);
        this.parenClose();
    }

    @Override
    public void visitData(Data data) {
        this.parenOpen("data");
        this.space();
        this.printId(data.id);
        this.space();
        if (data.active) {
            this.parenOpen("offset");
            this.space();
            this.parenOpen();
            this.visitConst(Instruction.Const.forInt((int)data.offset));
            this.parenClose();
            this.parenClose();
        }
        this.space();
        StringBuilder memorySb = new StringBuilder();
        block12: for (byte signed : data.data) {
            int b = signed & 0xFF;
            switch (b) {
                case 9: {
                    memorySb.append("\\t");
                    continue block12;
                }
                case 10: {
                    memorySb.append("\\n");
                    continue block12;
                }
                case 13: {
                    memorySb.append("\\r");
                    continue block12;
                }
                case 34: {
                    memorySb.append("\\\"");
                    continue block12;
                }
                case 92: {
                    memorySb.append("\\\\");
                    continue block12;
                }
                default: {
                    if (b >= 32 && b < 127) {
                        memorySb.append((char)b);
                        continue block12;
                    }
                    memorySb.append("\\");
                    memorySb.append(Character.forDigit(b >> 4 & 0xF, 16));
                    memorySb.append(Character.forDigit(b & 0xF, 16));
                }
            }
        }
        try (Indenter ignored = new Indenter();){
            this.newline();
            this.printString(memorySb.toString());
        }
        this.newline();
        this.parenClose();
    }

    protected void printFieldType(FieldType fieldType) {
        if (fieldType.mutable) {
            this.parenOpen("mut");
            this.space();
        }
        this.printType(fieldType.storageType);
        if (fieldType.mutable) {
            this.parenClose();
        }
    }

    @Override
    public void visitTypeDefinition(TypeDefinition def) {
        boolean isSimplified;
        this.parenOpen("type");
        this.space();
        this.printId(def.getId());
        boolean bl = isSimplified = def.isFinal && def.supertype == null;
        if (!isSimplified) {
            this.space();
            this.parenOpen("sub");
            if (def.isFinal) {
                this.space();
                this.print("final");
            }
            if (def.supertype != null) {
                this.space();
                this.printId(def.supertype);
            }
        }
        this.space();
        if (def instanceof StructType) {
            StructType struct = (StructType)def;
            this.parenOpen("struct");
            for (StructType.Field field : struct.fields) {
                try (Indenter ignored = new Indenter();){
                    this.newline();
                    if (this.printComment(field.comment)) {
                        this.newline();
                    }
                    this.parenOpen("field");
                    this.space();
                    this.printId(field.id);
                    this.space();
                    this.printFieldType(field.fieldType);
                    this.parenClose();
                }
            }
            this.newline();
            this.parenClose();
        } else if (def instanceof ArrayType) {
            ArrayType array = (ArrayType)def;
            this.parenOpen("array");
            this.space();
            this.printFieldType(array.elementType);
            this.parenClose();
        } else if (def instanceof FunctionType) {
            FunctionType function = (FunctionType)def;
            this.parenOpen("func");
            this.printTypeUse(function.typeUse);
            this.parenClose();
        } else {
            throw GraalError.unimplemented((String)def.toString());
        }
        if (!isSimplified) {
            this.parenClose();
        }
        this.parenClose();
    }

    @Override
    public void visitRecursiveGroup(RecursiveGroup def) {
        this.parenOpen("rec");
        try (Indenter ignored = new Indenter();){
            super.visitRecursiveGroup(def);
        }
        this.newline();
        this.parenClose();
    }

    @Override
    public void visitTag(Tag tag) {
        this.parenOpen("tag");
        this.space();
        this.printId(tag.id);
        this.printTypeUse(tag.id.typeUse);
        this.parenClose();
    }

    @Override
    public void visitGlobal(Global global) {
        this.parenOpen("global");
        this.space();
        this.printId(global.getId());
        if (global.mutable) {
            this.space();
            this.parenOpen("mut");
        }
        this.space();
        this.printType(global.getType());
        if (global.mutable) {
            this.parenClose();
        }
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitGlobal(global);
        }
        this.newline();
        this.parenClose();
    }

    @Override
    public void visitImport(Import importDecl) {
        this.parenOpen("import");
        this.space();
        this.printString(importDecl.getModule());
        this.space();
        this.printString(importDecl.getName());
        this.space();
        this.parenOpen(importDecl.getDescriptor().getType());
        this.space();
        this.printId(importDecl.getId());
        super.visitImport(importDecl);
        this.parenClose();
        this.parenClose();
    }

    @Override
    public void visitFunImport(ImportDescriptor.Function funcImport) {
        this.printTypeUse(funcImport.typeUse);
        super.visitFunImport(funcImport);
    }

    @Override
    public void visitExport(Export e) {
        this.parenOpen("export");
        this.space();
        this.printString(e.name);
        this.space();
        this.parenOpen(e.type.name);
        this.space();
        this.printId(e.getId());
        this.parenClose();
        this.parenClose();
    }

    @Override
    public void visitStartFunction(StartFunction startFunction) {
        this.parenOpen("start");
        this.space();
        this.printId(startFunction.function);
        this.parenClose();
    }

    @Override
    public void visitFunction(Function f) {
        this.parenOpen("func");
        this.space();
        this.printId(f.getId());
        this.space();
        this.parenOpen("type");
        this.space();
        this.printId(f.getFuncType());
        this.parenClose();
        for (WasmId.Local param : f.params) {
            this.space();
            this.printParam(param);
        }
        for (WasmValType result : f.getResults()) {
            this.space();
            this.printResult(result);
        }
        try (Indenter ignored = new Indenter();){
            for (WasmId.Local local : f.getLocals()) {
                this.newline();
                this.printLocal(local);
            }
            super.visitFunction(f);
        }
        this.newline();
        this.parenClose();
    }

    @Override
    public void visitTable(Table t) {
        this.parenOpen("table");
        this.space();
        this.printId(t.id);
        if (t.elements == null) {
            this.space();
            this.printLimit(t.limit);
            this.space();
            this.printType(t.elementType);
        } else {
            this.space();
            this.printType(t.elementType);
            this.space();
            this.parenOpen("elem");
            try (Indenter ignored = new Indenter();){
                int idx = 0;
                for (Instruction elem : t.elements) {
                    this.newline();
                    this.parenOpen("item");
                    this.space();
                    try (Indenter ignored2 = new Indenter();){
                        this.printComment(String.format("index: %d, 0x%x", idx, idx));
                        this.visitInstruction(elem);
                    }
                    this.newline();
                    this.parenClose();
                    ++idx;
                }
            }
            this.newline();
            this.parenClose();
        }
        this.parenClose();
    }

    @Override
    public void visitBlock(Instruction.Block block) {
        this.print("block");
        this.space();
        this.printId(block.getLabel());
        this.space();
        this.printComment(block.getComment());
        try (Indenter ignored = new Indenter();){
            super.visitBlock(block);
        }
        this.newline();
    }

    @Override
    public void visitLoop(Instruction.Loop loop) {
        this.print("loop");
        this.space();
        this.printId(loop.getLabel());
        this.space();
        this.printComment(loop.getComment());
        try (Indenter ignored = new Indenter();){
            super.visitLoop(loop);
        }
        this.newline();
    }

    @Override
    public void visitIf(Instruction.If ifBlock) {
        block16: {
            this.print("if");
            this.space();
            this.printId(ifBlock.getLabel());
            this.space();
            this.printComment(ifBlock.getComment());
            try (Indenter ignored = new Indenter();){
                this.visitInstruction(ifBlock.condition);
                this.newline();
                this.parenOpen("then");
                try (Indenter ignored2 = new Indenter();){
                    super.visitInstructions(ifBlock.thenInstructions);
                }
                this.newline();
                this.parenClose();
                if (!ifBlock.hasElse()) break block16;
                this.newline();
                this.parenOpen("else");
                ignored2 = new Indenter();
                try {
                    super.visitInstructions(ifBlock.elseInstructions);
                }
                finally {
                    ignored2.close();
                }
                this.newline();
                this.parenClose();
            }
        }
        this.newline();
    }

    @Override
    public void visitTry(Instruction.Try tryBlock) {
        this.print("try");
        this.space();
        this.printId(tryBlock.getLabel());
        this.space();
        this.printComment(tryBlock.getComment());
        try (Indenter ignored = new Indenter();){
            this.newline();
            this.parenOpen("do");
            try (Indenter ignored2 = new Indenter();){
                super.visitInstructions(tryBlock.instructions);
            }
            this.newline();
            this.parenClose();
            for (Instruction.Try.Catch catchBlock : tryBlock.catchBlocks) {
                this.newline();
                this.parenOpen("catch");
                this.space();
                this.printId(catchBlock.tag);
                try (Indenter ignored2 = new Indenter();){
                    super.visitInstructions(catchBlock.instructions);
                }
                this.newline();
                this.parenClose();
            }
        }
        this.newline();
    }

    @Override
    public void visitNop(Instruction.Nop inst) {
        this.print("nop");
    }

    @Override
    public void visitInstruction(Instruction inst) {
        this.newline();
        this.parenOpen();
        super.visitInstruction(inst);
        this.parenClose();
        this.space();
        this.printComment(inst.getComment());
    }

    @Override
    public void visitUnreachable(Instruction.Unreachable unreachable) {
        this.print("unreachable");
    }

    @Override
    public void visitBreak(Instruction.Break inst) {
        this.print(inst.condition == null ? "br" : "br_if");
        this.space();
        this.printId(inst.getTarget());
        super.visitBreak(inst);
    }

    @Override
    public void visitBreakTable(Instruction.BreakTable inst) {
        this.print("br_table");
        for (int i = 0; i < inst.numTargets(); ++i) {
            this.space();
            this.printId(inst.getTarget(i));
        }
        this.space();
        this.printId(inst.getDefaultTarget());
        try (Indenter ignored = new Indenter();){
            super.visitBreakTable(inst);
        }
        this.newline();
    }

    @Override
    public void visitReturn(Instruction.Return ret) {
        this.print("return");
        if (!ret.isVoid()) {
            try (Indenter ignored = new Indenter();){
                this.visitInstruction(ret.result);
            }
            this.newline();
        }
    }

    @Override
    public void visitLocalGet(Instruction.LocalGet localGet) {
        this.print("local.get");
        this.space();
        this.printId(localGet.getLocal());
    }

    @Override
    public void visitLocalSet(Instruction.LocalSet localSet) {
        this.print("local.set");
        this.space();
        this.printId(localSet.getLocal());
        try (Indenter ignored = new Indenter();){
            this.visitInstruction(localSet.value);
        }
        this.newline();
    }

    @Override
    public void visitLocalTee(Instruction.LocalTee localTee) {
        this.print("local.tee");
        this.space();
        this.printId(localTee.getLocal());
        try (Indenter ignored = new Indenter();){
            this.visitInstruction(localTee.value);
        }
        this.newline();
    }

    @Override
    public void visitGlobalGet(Instruction.GlobalGet globalGet) {
        this.print("global.get");
        this.space();
        this.printId(globalGet.getGlobal());
    }

    @Override
    public void visitGlobalSet(Instruction.GlobalSet globalSet) {
        this.print("global.set");
        this.space();
        this.printId(globalSet.getGlobal());
        try (Indenter ignored = new Indenter();){
            this.visitInstruction(globalSet.value);
        }
        this.newline();
    }

    @Override
    public void visitConst(Instruction.Const constValue) {
        this.printType(constValue.literal.type);
        this.print(".const");
        this.space();
        this.printLiteral(constValue.literal);
    }

    @Override
    public void visitRelocation(Instruction.Relocation relocation) {
        assert (relocation.wasProcessed()) : "Unprocessed relocation found in image: " + String.valueOf(relocation);
        Reference reference = relocation.target;
        if (reference instanceof BinaryenCompat.Pop) {
            BinaryenCompat.Pop pop = (BinaryenCompat.Pop)reference;
            this.print("pop");
            this.space();
            this.printType(pop.type);
        } else {
            super.visitInstruction(relocation.getValue());
        }
    }

    @Override
    public void visitBinary(Instruction.Binary inst) {
        this.print(inst.op.opName);
        try (Indenter ignored = new Indenter();){
            super.visitBinary(inst);
        }
        this.newline();
    }

    @Override
    public void visitUnary(Instruction.Unary inst) {
        this.print(inst.op.opName);
        try (Indenter ignored = new Indenter();){
            super.visitUnary(inst);
        }
        this.newline();
    }

    @Override
    public void visitDrop(Instruction.Drop inst) {
        this.print("drop");
        try (Indenter ignored = new Indenter();){
            super.visitDrop(inst);
        }
        this.newline();
    }

    @Override
    public void visitCall(Instruction.Call inst) {
        this.print("call");
        this.space();
        this.printId(inst.getTarget());
        try (Indenter ignored = new Indenter();){
            super.visitCall(inst);
        }
        this.newline();
    }

    @Override
    public void visitCallRef(Instruction.CallRef inst) {
        this.print("call_ref");
        this.space();
        this.printId(inst.functionType);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitCallRef(inst);
        }
        this.newline();
    }

    @Override
    public void visitCallIndirect(Instruction.CallIndirect inst) {
        this.print("call_indirect");
        this.space();
        this.printId(inst.table);
        this.space();
        this.parenOpen("type");
        this.space();
        this.printId(inst.funcId);
        this.parenClose();
        try (Indenter ignored = new Indenter();){
            super.visitCallIndirect(inst);
        }
        this.newline();
    }

    @Override
    public void visitThrow(Instruction.Throw inst) {
        this.print("throw");
        this.space();
        this.printId(inst.tag);
        try (Indenter ignored = new Indenter();){
            super.visitThrow(inst);
        }
        this.newline();
    }

    private void printLiteral(Literal literal) {
        this.print(literal.asText());
    }

    @Override
    public void visitSelect(Instruction.Select inst) {
        this.print("select");
        if (!inst.type.isNumeric()) {
            this.space();
            this.printResult(inst.type);
        }
        try (Indenter ignored = new Indenter();){
            super.visitSelect(inst);
        }
        this.newline();
    }

    @Override
    public void visitTableGet(Instruction.TableGet inst) {
        this.print("table.get");
        this.space();
        this.printId(inst.table);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitTableGet(inst);
        }
        this.newline();
    }

    @Override
    public void visitTableSet(Instruction.TableSet inst) {
        this.print("table.set");
        this.space();
        this.printId(inst.table);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitTableSet(inst);
        }
        this.newline();
    }

    @Override
    public void visitTableSize(Instruction.TableSize inst) {
        this.print("table.size");
        this.space();
        this.printId(inst.table);
    }

    @Override
    public void visitTableGrow(Instruction.TableGrow inst) {
        this.print("table.grow");
        this.space();
        this.printId(inst.table);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitTableGrow(inst);
        }
        this.newline();
    }

    @Override
    public void visitTableFill(Instruction.TableFill inst) {
        this.print("table.fill");
        this.space();
        this.printId(inst.table);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitTableFill(inst);
        }
        this.newline();
    }

    @Override
    public void visitTableCopy(Instruction.TableCopy inst) {
        this.print("table.get");
        this.space();
        this.printId(inst.destTable);
        this.space();
        this.printId(inst.srcTable);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitTableCopy(inst);
        }
        this.newline();
    }

    private void printMemarg(Instruction.Memory memoryInst) {
        int offset = memoryInst.calculateOffset();
        if (offset != 0) {
            this.space();
            this.print("offset=");
            this.printLiteral(Literal.forInt(offset));
        }
    }

    @Override
    public void visitLoad(Instruction.Load inst) {
        this.printType(inst.stackType);
        this.print(".load");
        if (inst.memoryWidth != 0) {
            this.printInt(inst.memoryWidth);
            this.print('_');
            this.print(inst.signed ? (char)'s' : 'u');
        }
        this.printMemarg(inst);
        try (Indenter ignored = new Indenter();){
            this.visitInstruction(inst.baseAddress);
        }
        this.newline();
    }

    @Override
    public void visitStore(Instruction.Store inst) {
        this.printType(inst.stackType);
        this.print(".store");
        if (inst.memoryWidth != 0) {
            this.printInt(inst.memoryWidth);
        }
        this.printMemarg(inst);
        try (Indenter ignored = new Indenter();){
            this.visitInstruction(inst.baseAddress);
            this.visitInstruction(inst.value);
        }
        this.newline();
    }

    @Override
    public void visitMemorySize(Instruction.MemorySize inst) {
        this.print("memory.size");
    }

    @Override
    public void visitMemoryGrow(Instruction.MemoryGrow inst) {
        this.print("memory.grow");
        try (Indenter ignored = new Indenter();){
            super.visitMemoryGrow(inst);
        }
        this.newline();
    }

    @Override
    public void visitMemoryFill(Instruction.MemoryFill inst) {
        this.print("memory.fill");
        try (Indenter ignored = new Indenter();){
            super.visitMemoryFill(inst);
        }
        this.newline();
    }

    @Override
    public void visitMemoryCopy(Instruction.MemoryCopy inst) {
        this.print("memory.copy");
        try (Indenter ignored = new Indenter();){
            super.visitMemoryCopy(inst);
        }
        this.newline();
    }

    @Override
    public void visitMemoryInit(Instruction.MemoryInit inst) {
        this.print("memory.init");
        this.space();
        this.visitId(inst.dataSegment);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitMemoryInit(inst);
        }
        this.newline();
    }

    @Override
    public void visitDataDrop(Instruction.DataDrop inst) {
        this.print("data.drop");
        this.space();
        this.visitId(inst.dataSegment);
    }

    @Override
    public void visitRefNull(Instruction.RefNull inst) {
        this.print("ref.null");
        this.space();
        this.printHeapType(inst.heapType);
    }

    @Override
    public void visitRefFunc(Instruction.RefFunc inst) {
        this.print("ref.func");
        this.space();
        this.printId(inst.func);
    }

    @Override
    public void visitRefTest(Instruction.RefTest inst) {
        this.print("ref.test");
        this.space();
        this.printType(inst.testType);
        try (Indenter ignored = new Indenter();){
            super.visitRefTest(inst);
        }
        this.newline();
    }

    @Override
    public void visitRefCast(Instruction.RefCast inst) {
        this.print("ref.cast");
        this.space();
        this.printType(inst.newType);
        try (Indenter ignored = new Indenter();){
            super.visitRefCast(inst);
        }
        this.newline();
    }

    @Override
    public void visitStructNew(Instruction.StructNew inst) {
        this.print("struct.new");
        if (inst.isDefault()) {
            this.print("_default");
        }
        this.space();
        this.printId(inst.type);
        if (!inst.isDefault()) {
            try (Indenter ignored = new Indenter();){
                this.visitInstructions(inst.getFieldValues());
            }
            this.newline();
        }
    }

    @Override
    public void visitStructGet(Instruction.StructGet inst) {
        this.print("struct.get");
        this.printExtensionSuffix(inst.extension);
        this.space();
        this.printId(inst.refType);
        this.space();
        this.printId(inst.fieldId);
        try (Indenter ignored = new Indenter();){
            super.visitStructGet(inst);
        }
        this.newline();
    }

    @Override
    public void visitStructSet(Instruction.StructSet inst) {
        this.print("struct.set");
        this.space();
        this.printId(inst.refType);
        this.space();
        this.printId(inst.fieldId);
        try (Indenter ignored = new Indenter();){
            super.visitStructSet(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayNew(Instruction.ArrayNew inst) {
        this.print("array.new");
        if (inst.isDefault()) {
            this.print("_default");
        }
        this.space();
        this.printId(inst.type);
        try (Indenter ignored = new Indenter();){
            super.visitArrayNew(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayNewFixed(Instruction.ArrayNewFixed inst) {
        this.print("array.new_fixed");
        this.space();
        this.printId(inst.type);
        this.space();
        this.printInt(inst.getLength());
        try (Indenter ignored = new Indenter();){
            super.visitArrayNewFixed(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayNewData(Instruction.ArrayNewData inst) {
        this.print("array.new_data");
        this.space();
        this.printId(inst.type);
        this.space();
        this.printId(inst.dataSegment);
        try (Indenter ignored = new Indenter();){
            super.visitArrayNewData(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayLen(Instruction.ArrayLen inst) {
        this.print("array.len");
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitArrayLen(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayFill(Instruction.ArrayFill inst) {
        this.print("array.fill");
        this.space();
        this.printId(inst.arrayType);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitArrayFill(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayGet(Instruction.ArrayGet inst) {
        this.print("array.get");
        this.printExtensionSuffix(inst.extension);
        this.space();
        this.printId(inst.refType);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitArrayGet(inst);
        }
        this.newline();
    }

    @Override
    public void visitArraySet(Instruction.ArraySet inst) {
        this.print("array.set");
        this.space();
        this.printId(inst.refType);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitArraySet(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayCopy(Instruction.ArrayCopy inst) {
        this.print("array.copy");
        this.space();
        this.printId(inst.destType);
        this.space();
        this.printId(inst.srcType);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitArrayCopy(inst);
        }
        this.newline();
    }

    @Override
    public void visitArrayInitData(Instruction.ArrayInitData inst) {
        this.print("array.init_data");
        this.space();
        this.printId(inst.type);
        this.space();
        this.printId(inst.dataSegment);
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitArrayInitData(inst);
        }
        this.newline();
    }

    @Override
    public void visitAnyExternConversion(Instruction.AnyExternConversion inst) {
        this.print(inst.isToExtern ? "extern.convert_any" : "any.convert_extern");
        this.space();
        try (Indenter ignored = new Indenter();){
            super.visitAnyExternConversion(inst);
        }
        this.newline();
    }

    static class WriterWrapper {
        private final Writer writer;
        private boolean isNewLine = true;
        private int indent = 0;

        WriterWrapper(Writer writer) {
            this.writer = writer;
        }

        private void writeString(String str) {
            try {
                this.writer.write(str);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeChar(char c) {
            try {
                this.writer.write(c);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void maybePrintIndent() {
            if (this.isNewLine) {
                this.isNewLine = false;
                this.writeString(" ".repeat(this.indent * 2));
            }
        }

        public void print(String str) {
            this.maybePrintIndent();
            this.writeString(str);
        }

        public void print(char c) {
            this.maybePrintIndent();
            this.writeChar(c);
        }

        public void newline() {
            this.writeString(System.lineSeparator());
            this.isNewLine = true;
        }
    }

    class Indenter
    implements AutoCloseable {
        Indenter() {
            assert (NumUtil.assertNonNegativeInt((int)WasmPrinter.this.writer.indent));
            ++WasmPrinter.this.writer.indent;
        }

        @Override
        public void close() {
            assert (NumUtil.assertPositiveInt((int)WasmPrinter.this.writer.indent));
            --WasmPrinter.this.writer.indent;
        }
    }
}

