/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.visitors;

import com.oracle.svm.hosted.webimage.wasm.ast.id.ResolverContext;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmVisitor;
import java.util.Collection;
import java.util.Collections;

public class WasmIdResolver
extends WasmVisitor {
    protected final ResolverContext context;
    protected final Collection<WasmId> expectedIds;

    public WasmIdResolver(ResolverContext ctxt, WasmIdFactory idFactory) {
        this.context = ctxt;
        this.expectedIds = Collections.unmodifiableCollection(idFactory.allIds());
    }

    @Override
    protected void visitId(WasmId id) {
        if (id == null) {
            return;
        }
        if (!id.isResolved()) {
            assert (this.expectedIds.contains(id)) : "Id was not created in factory: " + String.valueOf(id);
            id.resolve(this.context);
        }
        super.visitId(id);
    }
}

