/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.visitors;

import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Import;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Tag;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmVisitor;
import com.oracle.svm.hosted.webimage.wasmgc.ast.RecursiveGroup;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.graalvm.collections.EconomicSet;

public class WasmElementCreator
extends WasmVisitor {
    protected Function currentFunction = null;
    protected EconomicSet<WasmId.Local> currentLocals;
    protected EconomicSet<WebImageWasmIds.DescriptorFuncType> funcTypes = EconomicSet.create();

    private void prepareForFunction(Function f) {
        this.currentFunction = f;
        this.currentLocals = EconomicSet.create();
    }

    private void postProcessFunction() {
        this.currentLocals.forEach(this.currentFunction::allocateVariable);
        this.currentFunction = null;
        this.currentLocals = null;
    }

    private void registerLocal(WasmId.Local id) {
        if (id instanceof WebImageWasmIds.Param) {
            return;
        }
        if (!this.currentLocals.contains((Object)id)) {
            this.currentLocals.add((Object)id);
        }
    }

    private void registerImport(WasmId.Import<?> id) {
        if (!this.module.getImports().containsKey(id)) {
            this.module.addImport(new Import(id));
        }
    }

    private void registerTag(WasmId.Tag id) {
        if (this.module.getTags().stream().map(t -> t.id).noneMatch(tagId -> tagId == id)) {
            this.module.addTag(new Tag(id, null));
        }
    }

    @Override
    protected void visitId(WasmId id) {
        if (id == null) {
            return;
        }
        WasmId wasmId = id;
        Objects.requireNonNull(wasmId);
        WasmId wasmId2 = wasmId;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WasmId.Type.class, WasmId.Import.class, WasmId.Local.class, WasmId.Tag.class}, (Object)wasmId2, n)) {
            case 0: {
                WasmId.Type t = (WasmId.Type)wasmId2;
                this.registerType(t);
                break;
            }
            case 1: {
                WasmId.Import i = (WasmId.Import)((Object)wasmId2);
                this.registerImport(i);
                break;
            }
            case 2: {
                WasmId.Local l = (WasmId.Local)wasmId2;
                this.registerLocal(l);
                break;
            }
            case 3: {
                WasmId.Tag t = (WasmId.Tag)wasmId2;
                this.registerTag(t);
                break;
            }
        }
        super.visitId(id);
    }

    protected void registerType(WasmId.Type id) {
        if (id instanceof WebImageWasmIds.DescriptorFuncType) {
            WebImageWasmIds.DescriptorFuncType funcType = (WebImageWasmIds.DescriptorFuncType)id;
            this.registerFunctionType(funcType);
        }
    }

    protected void registerFunctionType(WebImageWasmIds.DescriptorFuncType funcType) {
        if (this.funcTypes.add((Object)funcType)) {
            this.registerNewFunctionType(funcType);
        }
    }

    protected void registerNewFunctionType(WebImageWasmIds.DescriptorFuncType funcType) {
        this.module.addRecursiveGroup(RecursiveGroup.singletonGroup(funcType.createTypeDefinition(null)));
    }

    @Override
    public void visitFunction(Function f) {
        this.prepareForFunction(f);
        super.visitFunction(f);
        this.postProcessFunction();
    }

    @Override
    public void visitBreakTable(Instruction.BreakTable inst) {
        super.visitBreakTable(inst);
        inst.fillTargets();
    }
}

