/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.id;

import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.ResolverContext;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasmgc.ast.FunctionType;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlock;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class WebImageWasmIds {

    public static class DescriptorFuncType
    extends WasmId.FuncType {
        private final FunctionTypeDescriptor descriptor;
        static AtomicInteger num = new AtomicInteger(0);

        public DescriptorFuncType(FunctionTypeDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "func." + num.getAndIncrement();
        }

        public FunctionType createTypeDefinition(Object comment) {
            return this.descriptor.toTypeDefinition(this, comment);
        }

        public TypeUse getTypeUse() {
            return this.descriptor.typeUse();
        }
    }

    public static class TempLocal
    extends WasmId.Local {
        static AtomicInteger num = new AtomicInteger(0);

        protected TempLocal(WasmValType variableType) {
            super(variableType);
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "TEMP_" + num.getAndIncrement();
        }
    }

    public static class Param
    extends WasmId.Local {
        public final int idx;

        protected Param(int idx, WasmValType variableType) {
            super(variableType);
            this.idx = idx;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "p" + this.idx;
        }

        @Override
        public String toInnerString() {
            return String.valueOf(this.idx);
        }
    }

    public static class NodeVariable
    extends WasmId.Local {
        final ResolvedVar var;

        protected NodeVariable(ResolvedVar var, WasmValType variableType) {
            super(variableType);
            this.var = var;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            assert (this.var.born()) : this.var;
            return this.var.getName();
        }

        @Override
        public String toInnerString() {
            return this.var.getName();
        }
    }

    public static class InternalLabel
    extends WasmId.Label {
        public final String name;

        public InternalLabel(String name) {
            this.name = name;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "label." + this.name;
        }
    }

    public static class SwitchLabel
    extends WasmId.Label {
        static AtomicInteger num = new AtomicInteger(0);

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "switch_" + num.getAndIncrement();
        }
    }

    public static class BlockLabel
    extends WasmId.Label {
        final LabeledBlock labeledBlock;

        protected BlockLabel(LabeledBlock labeledBlock) {
            this.labeledBlock = labeledBlock;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return this.labeledBlock.getLabel();
        }

        @Override
        public String toInnerString() {
            return this.labeledBlock.getLabel();
        }
    }

    public static class LoopLabel
    extends WasmId.Label {
        final HIRBlock loopHeader;

        protected LoopLabel(HIRBlock loopHeader) {
            this.loopHeader = loopHeader;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return ResolverContext.getLoopLabel(this.loopHeader);
        }

        @Override
        public String toInnerString() {
            return String.valueOf(this.loopHeader.getId());
        }
    }

    public static class InternalFunction
    extends WasmId.Func {
        public final String name;

        protected InternalFunction(String name) {
            this.name = name;
        }

        @Override
        public String doResolve(ResolverContext ctxt) {
            return "func." + this.name;
        }

        @Override
        public String toInnerString() {
            return this.name;
        }
    }

    public static class MethodName
    extends WasmId.Func {
        final ResolvedJavaMethod method;

        protected MethodName(ResolvedJavaMethod method) {
            this.method = method;
        }

        @Override
        public String doResolve(ResolverContext ctxt) {
            return ctxt.namingConvention.identForType(this.method.getDeclaringClass()) + "_" + ctxt.namingConvention.identForMethod(this.method);
        }

        @Override
        public String toInnerString() {
            return this.method.format("%H.%n(%P)%R");
        }
    }
}

