/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.id;

import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasmgc.ast.id.WebImageWasmGCIds;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlock;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WasmIdFactory {
    private final AtomicBoolean frozen = new AtomicBoolean(false);
    private final Set<WasmId> allIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ResolvedJavaMethod, WebImageWasmIds.MethodName> methodIds = new ConcurrentHashMap<ResolvedJavaMethod, WebImageWasmIds.MethodName>();
    private final ConcurrentMap<HIRBlock, WebImageWasmIds.LoopLabel> loopLabels = new ConcurrentHashMap<HIRBlock, WebImageWasmIds.LoopLabel>();
    private final ConcurrentMap<LabeledBlock, WebImageWasmIds.BlockLabel> blockLabels = new ConcurrentHashMap<LabeledBlock, WebImageWasmIds.BlockLabel>();
    private final Set<WebImageWasmIds.SwitchLabel> switchLabels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ResolvedVar, WebImageWasmIds.NodeVariable> localVars = new ConcurrentHashMap<ResolvedVar, WebImageWasmIds.NodeVariable>();
    private final Set<WebImageWasmIds.Param> parameters = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WebImageWasmIds.TempLocal> temporaryVariables = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WasmId.Table> tables = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ImportDescriptor.Function, WasmId.FunctionImport> functionImports = new ConcurrentHashMap<ImportDescriptor.Function, WasmId.FunctionImport>();
    private final ConcurrentMap<Integer, WasmId.Memory> memories = new ConcurrentHashMap<Integer, WasmId.Memory>();
    private final Set<WasmId.Tag> tags = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WasmId.Global> globals = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ResolvedJavaType, WebImageWasmGCIds.JavaStruct> javaStructs = new ConcurrentHashMap<ResolvedJavaType, WebImageWasmGCIds.JavaStruct>();
    private final ConcurrentMap<JavaKind, WebImageWasmGCIds.JavaArrayStruct> javaArrayStructs = new ConcurrentHashMap<JavaKind, WebImageWasmGCIds.JavaArrayStruct>();
    private final ConcurrentMap<ResolvedJavaField, WebImageWasmGCIds.JavaField> javaFields = new ConcurrentHashMap<ResolvedJavaField, WebImageWasmGCIds.JavaField>();
    private final ConcurrentMap<JavaKind, WebImageWasmGCIds.JavaInnerArray> javaInnerArrays = new ConcurrentHashMap<JavaKind, WebImageWasmGCIds.JavaInnerArray>();
    private final Set<WebImageWasmGCIds.InternalField> internalFields = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WebImageWasmGCIds.InternalStruct> internalStructs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WebImageWasmGCIds.InternalArray> internalArrays = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WasmId.Data> dataSegments = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<FunctionTypeDescriptor, WebImageWasmIds.DescriptorFuncType> descriptorFuncTypes = new ConcurrentHashMap<FunctionTypeDescriptor, WebImageWasmIds.DescriptorFuncType>();
    private final Set<WebImageWasmGCIds.InternalFuncType> internalFuncTypes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WebImageWasmIds.InternalFunction> internalFunctions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WebImageWasmIds.InternalLabel> internalLabels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ResolvedJavaField, WebImageWasmGCIds.StaticField> staticFields = new ConcurrentHashMap<ResolvedJavaField, WebImageWasmGCIds.StaticField>();

    public boolean isFrozen() {
        return this.frozen.get();
    }

    private boolean assertNotFrozen() {
        assert (!this.isFrozen()) : "Attempt to modify frozen factory";
        return true;
    }

    public void freeze() {
        assert (!this.isFrozen()) : "Factory is already frozen";
        this.frozen.set(true);
    }

    public Collection<WasmId> allIds() {
        assert (this.isFrozen()) : "Ids can only be retrieved once factory is frozen.";
        return Collections.unmodifiableSet(this.allIds);
    }

    private <T extends WasmId> T addId(T id) {
        assert (id != null);
        boolean wasAdded = this.allIds.add(id);
        assert (wasAdded) : id;
        return id;
    }

    private <T, I extends WasmId> I createForKey(T key, Map<T, I> map, Function<T, I> constructor) {
        assert (key != null);
        return (I)map.computeIfAbsent(key, k -> {
            assert (this.assertNotFrozen());
            return this.addId((WasmId)constructor.apply(k));
        });
    }

    private <T extends WasmId> T insert(Set<T> set, Supplier<T> constructor) {
        assert (this.assertNotFrozen());
        WasmId id = this.addId((WasmId)constructor.get());
        set.add(id);
        return (T)id;
    }

    public WebImageWasmIds.MethodName forMethod(ResolvedJavaMethod method) {
        return this.createForKey(method, this.methodIds, WebImageWasmIds.MethodName::new);
    }

    public boolean hasMethod(ResolvedJavaMethod method) {
        return this.methodIds.containsKey(method);
    }

    public WebImageWasmIds.LoopLabel forLoopLabel(HIRBlock loopHeader) {
        return this.createForKey(loopHeader, this.loopLabels, WebImageWasmIds.LoopLabel::new);
    }

    public WebImageWasmIds.BlockLabel forBlockLabel(LabeledBlock block) {
        return this.createForKey(block, this.blockLabels, WebImageWasmIds.BlockLabel::new);
    }

    public WebImageWasmIds.SwitchLabel newSwitchLabel() {
        return this.insert(this.switchLabels, WebImageWasmIds.SwitchLabel::new);
    }

    public WebImageWasmIds.NodeVariable forVariable(ResolvedVar resolvedVar, WasmValType type) {
        return this.createForKey(resolvedVar, this.localVars, var -> new WebImageWasmIds.NodeVariable((ResolvedVar)var, type));
    }

    public WebImageWasmIds.Param newParam(int idx, WasmValType type) {
        assert (NumUtil.assertNonNegativeInt((int)idx));
        return this.insert(this.parameters, () -> new WebImageWasmIds.Param(idx, type));
    }

    public WebImageWasmIds.TempLocal newTemporaryVariable(WasmValType type) {
        return this.insert(this.temporaryVariables, () -> new WebImageWasmIds.TempLocal(type));
    }

    public WasmId.Table newTable() {
        return this.insert(this.tables, WasmId.Table::new);
    }

    public WasmId.FunctionImport forFunctionImport(ImportDescriptor.Function wasmImport) {
        return this.createForKey(wasmImport, this.functionImports, WasmId.FunctionImport::new);
    }

    public WasmId.Memory forMemory(int num) {
        assert (num == 0) : "Only memory index 0 is allowed: " + num;
        return this.createForKey(num, this.memories, WasmId.Memory::new);
    }

    public WasmId.Tag newTag(TypeUse typeUse) {
        return this.insert(this.tags, () -> new WasmId.Tag(typeUse));
    }

    public WasmId.Global newGlobal(WasmValType type, String name) {
        return this.insert(this.globals, () -> new WasmId.Global(type, name));
    }

    public WebImageWasmGCIds.JavaStruct newJavaStruct(ResolvedJavaType type) {
        return this.createForKey(type, this.javaStructs, WebImageWasmGCIds.JavaStruct::new);
    }

    public WebImageWasmGCIds.JavaArrayStruct newJavaArrayStruct(JavaKind kind) {
        return this.createForKey(kind, this.javaArrayStructs, WebImageWasmGCIds.JavaArrayStruct::new);
    }

    public WebImageWasmGCIds.JavaField newJavaField(ResolvedJavaField field) {
        return this.createForKey(field, this.javaFields, WebImageWasmGCIds.JavaField::new);
    }

    public WebImageWasmGCIds.JavaInnerArray newJavaInnerArray(JavaKind kind) {
        return this.createForKey(kind, this.javaInnerArrays, WebImageWasmGCIds.JavaInnerArray::new);
    }

    public WebImageWasmGCIds.InternalField newInternalField(String name) {
        return this.insert(this.internalFields, () -> new WebImageWasmGCIds.InternalField(name));
    }

    public WebImageWasmGCIds.InternalStruct newInternalStruct(String name) {
        return this.insert(this.internalStructs, () -> new WebImageWasmGCIds.InternalStruct(name));
    }

    public WebImageWasmGCIds.InternalArray newInternalArray(String name) {
        return this.insert(this.internalArrays, () -> new WebImageWasmGCIds.InternalArray(name));
    }

    public WasmId.Data newDataSegment(String name) {
        return this.insert(this.dataSegments, () -> new WasmId.Data(name));
    }

    public WebImageWasmIds.DescriptorFuncType newFuncType(FunctionTypeDescriptor descriptor) {
        return this.createForKey(descriptor, this.descriptorFuncTypes, WebImageWasmIds.DescriptorFuncType::new);
    }

    public WebImageWasmGCIds.InternalFuncType newInternalFuncType(String name) {
        return this.insert(this.internalFuncTypes, () -> new WebImageWasmGCIds.InternalFuncType(name));
    }

    public WebImageWasmIds.InternalFunction newInternalFunction(String name) {
        return this.insert(this.internalFunctions, () -> new WebImageWasmIds.InternalFunction(name));
    }

    public WebImageWasmIds.InternalLabel newInternalLabel(String name) {
        return this.insert(this.internalLabels, () -> new WebImageWasmIds.InternalLabel(name));
    }

    public WebImageWasmGCIds.StaticField forStaticField(WasmValType fieldType, ResolvedJavaField field) {
        return this.createForKey(field, this.staticFields, f -> new WebImageWasmGCIds.StaticField(fieldType, (ResolvedJavaField)f));
    }
}

