/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.id;

import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.ResolverContext;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.core.common.NumUtil;

public abstract sealed class WasmId {
    protected String resolvedName = null;

    public void resolve(ResolverContext ctxt) {
        assert (!this.isResolved()) : "Id already resolved: " + String.valueOf(this);
        String name = this.doResolve(ctxt);
        assert (name != null);
        this.resolvedName = name;
    }

    public boolean isResolved() {
        return this.resolvedName != null;
    }

    public String getName() {
        assert (this.isResolved()) : "Id not yet resolved: " + String.valueOf(this);
        return this.resolvedName;
    }

    protected abstract String doResolve(ResolverContext var1);

    public String toString() {
        String inner = this.toInnerString();
        String name = ClassUtil.getUnqualifiedName(this.getClass());
        return name + "{" + (String)(this.isResolved() ? this.getName() + ", " : "") + inner + "}";
    }

    protected String toInnerString() {
        return Integer.toHexString(this.hashCode());
    }

    public static abstract non-sealed class Field
    extends WasmId {
    }

    public static non-sealed class Tag
    extends WasmId {
        public final TypeUse typeUse;
        static AtomicInteger num = new AtomicInteger(0);

        public Tag(TypeUse typeUse) {
            assert (typeUse.results.isEmpty()) : "Tag typeUses cannot have a result: " + String.valueOf(typeUse);
            this.typeUse = typeUse;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "tag" + num.getAndIncrement();
        }

        @Override
        protected String toInnerString() {
            return this.typeUse.toString() + ", " + super.toInnerString();
        }
    }

    public static abstract non-sealed class Label
    extends WasmId {
    }

    public static non-sealed class Data
    extends WasmId {
        public final String name;

        public Data(String name) {
            this.name = name;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "data." + this.name;
        }
    }

    public static abstract non-sealed class Local
    extends Variable {
        protected Local(WasmValType variableType) {
            super(variableType);
        }

        @Override
        public Instruction.LocalGet getter() {
            return new Instruction.LocalGet(this);
        }

        @Override
        public Instruction.LocalSet setter(Instruction value) {
            return new Instruction.LocalSet(this, value);
        }

        public Instruction.LocalTee tee(Instruction value) {
            return new Instruction.LocalTee(this, value);
        }
    }

    public static non-sealed class Global
    extends Variable {
        public final String name;

        public Global(WasmValType variableType, String name) {
            super(variableType);
            this.name = name;
        }

        @Override
        public Instruction.GlobalGet getter() {
            return new Instruction.GlobalGet(this);
        }

        @Override
        public Instruction.GlobalSet setter(Instruction value) {
            return new Instruction.GlobalSet(this, value);
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return this.name;
        }

        @Override
        protected String toInnerString() {
            return this.name;
        }
    }

    public static abstract sealed class Variable
    extends WasmId
    permits Global, Local {
        private final WasmValType variableType;

        protected Variable(WasmValType variableType) {
            assert (variableType != null);
            this.variableType = variableType;
        }

        public final WasmValType getVariableType() {
            return this.variableType;
        }

        public abstract Instruction getter();

        public abstract Instruction setter(Instruction var1);
    }

    public static non-sealed class Memory
    extends WasmId {
        public final int num;

        public Memory(int num) {
            assert (NumUtil.assertNonNegativeInt((int)num));
            this.num = num;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "mem" + this.num;
        }

        @Override
        protected String toInnerString() {
            return String.valueOf(this.num);
        }
    }

    public static non-sealed class Table
    extends WasmId {
        static AtomicInteger num = new AtomicInteger(0);

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return "table" + num.getAndIncrement();
        }
    }

    public static class FunctionImport
    extends Func
    implements Import<ImportDescriptor.Function> {
        public final ImportDescriptor.Function descriptor;

        protected FunctionImport(ImportDescriptor.Function descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        protected String doResolve(ResolverContext ctxt) {
            return this.descriptor.module + "_" + this.descriptor.name;
        }

        @Override
        public String toInnerString() {
            return this.descriptor.toString();
        }

        @Override
        public FunctionImport getId() {
            return this;
        }

        @Override
        public ImportDescriptor.Function getDescriptor() {
            return this.descriptor;
        }
    }

    public static abstract non-sealed class Func
    extends WasmId {
    }

    public static abstract non-sealed class ArrayType
    extends Type {
    }

    public static abstract non-sealed class StructType
    extends Type {
    }

    public static abstract non-sealed class FuncType
    extends Type {
    }

    public static abstract sealed class Type
    extends WasmId
    permits FuncType, StructType, ArrayType {
        public WasmRefType asNullable() {
            return WasmRefType.nullable(this);
        }

        public WasmRefType asNonNull() {
            return WasmRefType.nonNull(this);
        }
    }

    public static sealed interface Import<T extends ImportDescriptor>
    permits FunctionImport {
        public WasmId getId();

        public T getDescriptor();
    }
}

