/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast.id;

import com.oracle.svm.hosted.webimage.wasm.ast.Export;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import java.util.List;

public class KnownIds {
    public final WasmId.Table functionTable;
    public final WasmId.Memory heapMemory;
    private WasmId.Tag javaThrowableTag;
    public final WasmId.Global stackPointer;

    public KnownIds(WasmIdFactory idFactory) {
        this.functionTable = idFactory.newTable();
        this.heapMemory = idFactory.forMemory(0);
        this.stackPointer = idFactory.newGlobal(WasmPrimitiveType.i32, "stackPointer");
    }

    public void initializeJavaThrowableTag(WebImageWasmProviders providers) {
        assert (this.javaThrowableTag == null) : "Java throwable tag already set";
        this.javaThrowableTag = providers.idFactory().newTag(TypeUse.withoutResult(providers.util().getThrowableType()));
    }

    public WasmId.Tag getJavaThrowableTag() {
        assert (this.javaThrowableTag != null) : "Java throwable tag not yet set";
        return this.javaThrowableTag;
    }

    public List<WasmFunctionTemplate<?>> getFunctionTemplates() {
        return List.of();
    }

    public List<WasmFunctionTemplate<?>> getLateFunctionTemplates() {
        return List.of();
    }

    public List<Export> getExports() {
        return List.of();
    }
}

