/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.ActiveData;
import com.oracle.svm.hosted.webimage.wasm.ast.Data;
import com.oracle.svm.hosted.webimage.wasm.ast.Export;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Global;
import com.oracle.svm.hosted.webimage.wasm.ast.Import;
import com.oracle.svm.hosted.webimage.wasm.ast.Memory;
import com.oracle.svm.hosted.webimage.wasm.ast.StartFunction;
import com.oracle.svm.hosted.webimage.wasm.ast.Table;
import com.oracle.svm.hosted.webimage.wasm.ast.Tag;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasmgc.ast.RecursiveGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.SequencedMap;

public class WasmModule {
    public static final int MAX_DATA_SEGMENTS = 100000;
    protected List<Function> functions = new ArrayList<Function>();
    protected Memory memory = null;
    protected List<Tag> tags = new ArrayList<Tag>();
    protected List<RecursiveGroup> recGroups = new ArrayList<RecursiveGroup>();
    protected SequencedMap<WasmId.Global, Global> globals = new LinkedHashMap<WasmId.Global, Global>();
    protected SequencedMap<String, Export> exports = new LinkedHashMap<String, Export>();
    protected SequencedMap<WasmId.Import<?>, Import> imports = new LinkedHashMap();
    protected List<Table> tables = new ArrayList<Table>();
    protected List<Data> dataSegments = new ArrayList<Data>();
    protected final ActiveData activeData = new ActiveData();
    protected StartFunction startFunction = null;

    public void addFunction(Function fun) {
        this.functions.add(Objects.requireNonNull(fun));
    }

    public List<Function> getFunctions() {
        return Collections.unmodifiableList(this.functions);
    }

    public void setStartFunction(StartFunction startFunction) {
        assert (this.startFunction == null) : "Duplicate start function: " + String.valueOf(startFunction);
        this.startFunction = startFunction;
    }

    public StartFunction getStartFunction() {
        return this.startFunction;
    }

    public void setMemory(Memory memory) {
        assert (this.memory == null);
        this.memory = memory;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public void addTag(Tag tag) {
        this.tags.add(tag);
    }

    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public void addRecursiveGroup(RecursiveGroup recGroup) {
        this.recGroups.add(recGroup);
    }

    public List<RecursiveGroup> getRecursiveGroups() {
        return Collections.unmodifiableList(this.recGroups);
    }

    public void addGlobal(Global global) {
        assert (!this.globals.containsKey(global.getId())) : "Global with id " + String.valueOf(global.getId()) + " already exists";
        this.globals.put(global.getId(), global);
    }

    public SequencedMap<WasmId.Global, Global> getGlobals() {
        return Collections.unmodifiableSequencedMap(this.globals);
    }

    public void addExport(Export export) {
        String name = export.name;
        assert (!this.exports.containsKey(name)) : "Export with name " + name + " already exists. Existing id: " + String.valueOf(((Export)this.exports.get((Object)name)).id) + ". New id: " + String.valueOf(export.id);
        this.exports.put(name, export);
    }

    public void addFunctionExport(WasmId.Func id, String name, Object comment) {
        this.addExport(Export.forFunction(id, name, comment));
    }

    public SequencedMap<String, Export> getExports() {
        return Collections.unmodifiableSequencedMap(this.exports);
    }

    public void addImport(Import importDecl) {
        assert (!this.imports.containsKey(importDecl.getImportId())) : "Import with id " + String.valueOf(importDecl.getImportId()) + " already exists";
        this.imports.put(importDecl.getImportId(), importDecl);
    }

    public SequencedMap<WasmId.Import<?>, Import> getImports() {
        return Collections.unmodifiableSequencedMap(this.imports);
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }

    public List<Table> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public void addData(Data dataField) {
        this.dataSegments.add(dataField);
    }

    public List<Data> getDataSegments() {
        return Collections.unmodifiableList(this.dataSegments);
    }

    public void addActiveData(long offset, byte[] data) {
        this.activeData.addData(offset, data);
    }

    public void constructActiveDataSegments() {
        this.activeData.constructDataSegments(100000 - this.dataSegments.size()).forEach(this::addData);
    }
}

