/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.debug.GraalError;

public class TypeUse {
    public final List<WasmValType> params;
    public final List<WasmValType> results;

    public TypeUse(List<WasmValType> params, List<WasmValType> results) {
        this.params = Collections.unmodifiableList(params);
        this.results = Collections.unmodifiableList(results);
    }

    public static TypeUse withOptionalResult(WasmValType result, WasmValType ... args) {
        if (result == null) {
            return TypeUse.withoutResult(args);
        }
        return TypeUse.withResult(result, args);
    }

    public static TypeUse withResult(WasmValType result, WasmValType ... args) {
        return new TypeUse(Arrays.asList(args), Collections.singletonList(result));
    }

    public static TypeUse withoutResult(WasmValType ... args) {
        return new TypeUse(Arrays.asList(args), Collections.emptyList());
    }

    public static TypeUse forUnary(WasmValType result, WasmValType input) {
        return TypeUse.withResult(result, input);
    }

    public static TypeUse forBinary(WasmValType result, WasmValType left, WasmValType right) {
        return TypeUse.withResult(result, left, right);
    }

    public boolean hasResults() {
        return !this.results.isEmpty();
    }

    public WasmValType getSingleResult() {
        if (this.hasResults()) {
            GraalError.guarantee((this.results.size() == 1 ? 1 : 0) != 0, (String)"This type use should have exactly one result, has: %d", (Object)this.results.size());
            return this.results.getFirst();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeUse typeUse = (TypeUse)o;
        return Objects.equals(this.params, typeUse.params) && Objects.equals(this.results, typeUse.results);
    }

    public int hashCode() {
        return Objects.hash(this.params, this.results);
    }

    public String toString() {
        return "TypeUse{params=" + String.valueOf(this.params) + ", results=" + String.valueOf(this.results) + "}";
    }
}

