/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.ActiveElements;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Limit;
import com.oracle.svm.hosted.webimage.wasm.ast.ModuleField;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;

public class Table
extends ModuleField {
    public final WasmId.Table id;
    public final Limit limit;
    public final WasmRefType elementType;
    public final Instruction[] elements;

    public Table(WasmId.Table id, ActiveElements activeElements, Object comment) {
        this(id, Limit.fixed(activeElements.size()), activeElements.elementType, activeElements.getElements(), comment);
        assert (activeElements.offset == 0) : "Can't create table from active elements with offset other than 0: " + activeElements.offset;
    }

    public Table(WasmId.Table id, Limit limit, WasmRefType elementType, Object comment) {
        this(id, limit, elementType, null, comment);
    }

    private Table(WasmId.Table id, Limit limit, WasmRefType elementType, Instruction[] elements, Object comment) {
        super(comment);
        this.elements = elements;
        this.id = id;
        this.limit = limit;
        this.elementType = elementType;
    }
}

