/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;

public final class Literal {
    public final WasmPrimitiveType type;
    PrimitiveConstant primitive;

    private Literal(PrimitiveConstant primitive) {
        JavaKind kind = primitive.getJavaKind();
        assert (kind.isNumericInteger() || kind.isNumericFloat()) : primitive;
        this.type = WasmUtil.mapPrimitiveType(kind);
        this.primitive = primitive;
    }

    public static Literal defaultForType(WasmPrimitiveType type) {
        JavaKind kind = switch (type) {
            default -> throw new MatchException(null, null);
            case WasmPrimitiveType.i32 -> JavaKind.Int;
            case WasmPrimitiveType.i64 -> JavaKind.Long;
            case WasmPrimitiveType.f32 -> JavaKind.Float;
            case WasmPrimitiveType.f64 -> JavaKind.Double;
        };
        return Literal.forConstant((PrimitiveConstant)JavaConstant.defaultForKind((JavaKind)kind));
    }

    public static Literal forConstant(PrimitiveConstant constant) {
        return new Literal(constant);
    }

    public static Literal forInt(int value) {
        return new Literal(JavaConstant.forInt((int)value));
    }

    public static Literal forLong(long value) {
        return new Literal(JavaConstant.forLong((long)value));
    }

    public static Literal forFloat(float value) {
        return new Literal(JavaConstant.forFloat((float)value));
    }

    public static Literal forDouble(double value) {
        return new Literal(JavaConstant.forDouble((double)value));
    }

    public int getI32() {
        assert (this.type == WasmPrimitiveType.i32) : this.type;
        return this.primitive.asInt();
    }

    public long getI64() {
        assert (this.type == WasmPrimitiveType.i64) : this.type;
        return this.primitive.asLong();
    }

    public float getF32() {
        assert (this.type == WasmPrimitiveType.f32) : this.type;
        return this.primitive.asFloat();
    }

    public double getF64() {
        assert (this.type == WasmPrimitiveType.f64) : this.type;
        return this.primitive.asDouble();
    }

    public String asText() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case i32: {
                sb.append("0x").append(Integer.toHexString(this.getI32()));
                break;
            }
            case i64: {
                sb.append("0x").append(Long.toHexString(this.getI64()));
                break;
            }
            case f32: {
                float f = this.getF32();
                if (Float.isNaN(f)) {
                    sb.append("nan");
                    break;
                }
                if (f == Float.NEGATIVE_INFINITY) {
                    sb.append("-inf");
                    break;
                }
                if (f == Float.POSITIVE_INFINITY) {
                    sb.append("+inf");
                    break;
                }
                sb.append(f);
                break;
            }
            case f64: {
                double d = this.getF64();
                if (Double.isNaN(d)) {
                    sb.append("nan");
                    break;
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    sb.append("-inf");
                    break;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    sb.append("+inf");
                    break;
                }
                sb.append(d);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)this.type.name());
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "Literal{" + String.valueOf(this.type) + ", " + this.asText() + "}";
    }
}

