/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

public final class Limit {
    private final int min;
    private final int max;
    private final boolean hasMax;

    private Limit(int min, int max, boolean hasMax) {
        this.min = min;
        this.max = max;
        this.hasMax = hasMax;
    }

    public static Limit withoutMax(int min) {
        return new Limit(min, 0, false);
    }

    public static Limit withMax(int min, int max) {
        assert (max >= min) : max + " < " + min;
        return new Limit(min, max, true);
    }

    public static Limit fixed(int num) {
        return new Limit(num, num, true);
    }

    public boolean hasMax() {
        return this.hasMax;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        assert (this.hasMax()) : "This limit does not have an upper bound";
        return this.max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Limit{");
        sb.append(this.min);
        sb.append(", ");
        if (this.hasMax()) {
            sb.append("<no max>");
        } else {
            sb.append(this.max);
        }
        sb.append('}');
        return sb.toString();
    }
}

