/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.Literal;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.word.WordBase;

public abstract class Instruction {
    protected Object comment = null;

    public Object getComment() {
        return this.comment;
    }

    public Instruction setComment(Object comment) {
        this.comment = comment;
        return this;
    }

    public static Const asConst(Instruction instr) {
        if (instr instanceof Const) {
            Const constant = (Const)instr;
            return constant;
        }
        if (instr instanceof Relocation) {
            Relocation relocation = (Relocation)instr;
            GraalError.guarantee((boolean)relocation.wasProcessed(), (String)"Found unprocessed relocation when trying to resolve constant: %s", (Object)relocation);
            return Instruction.asConst(relocation.getValue());
        }
        throw GraalError.shouldNotReachHere((String)("Found non-constant instruction when trying to resolve constant: " + String.valueOf(instr)));
    }

    public final String toString() {
        String innerString = this.toInnerString();
        Object commentString = this.getComment();
        Object finalInnerString = innerString != null ? (commentString != null ? innerString + ", " + String.valueOf(commentString) : innerString) : String.valueOf(commentString);
        return ClassUtil.getUnqualifiedName(this.getClass()) + "{" + (String)finalInnerString + "}";
    }

    protected String toInnerString() {
        return null;
    }

    public static final class Const
    extends Instruction {
        public final Literal literal;

        public Const(Literal literal) {
            this.literal = literal;
        }

        public static Const defaultForType(WasmValType type) {
            return new Const(Literal.defaultForType(type.asPrimitive()));
        }

        public static Const forConstant(PrimitiveConstant primitiveConstant) {
            return new Const(Literal.forConstant(primitiveConstant));
        }

        public static Const forBoolean(boolean value) {
            return Const.forInt(value ? 1 : 0);
        }

        public static Const forInt(int value) {
            return new Const(Literal.forInt(value));
        }

        public static Const forLong(long value) {
            return new Const(Literal.forLong(value));
        }

        public static Const forFloat(float value) {
            return new Const(Literal.forFloat(value));
        }

        public static Const forDouble(double value) {
            return new Const(Literal.forDouble(value));
        }

        public static Const forNull() {
            return Const.forInt(0);
        }

        public static Const forWord(WordBase word) {
            return Const.forLong(word.rawValue());
        }
    }

    public static final class Relocation
    extends Instruction {
        public final Reference target;
        private Instruction value;

        public Relocation(Reference target) {
            this.target = Objects.requireNonNull(target);
        }

        public static Relocation forConstant(JavaConstant constant) {
            return Relocation.forConstant((VMConstant)constant);
        }

        public static Relocation forConstant(VMConstant constant) {
            return new Relocation((Reference)new ConstantReference(constant));
        }

        public boolean wasProcessed() {
            return this.value != null;
        }

        public Instruction getValue() {
            assert (this.wasProcessed()) : "Relocation has no value yet";
            return this.value;
        }

        public void setValue(Instruction value) {
            assert (!this.wasProcessed()) : "Value is already set";
            assert (value != null);
            this.value = value;
        }

        @Override
        protected String toInnerString() {
            return this.target.toString();
        }
    }

    public static final class AnyExternConversion
    extends Instruction {
        public final boolean isToExtern;
        public final Instruction input;

        private AnyExternConversion(boolean isToExtern, Instruction input) {
            this.isToExtern = isToExtern;
            this.input = input;
        }

        public static AnyExternConversion toExtern(Instruction input) {
            return new AnyExternConversion(true, input);
        }

        public static AnyExternConversion toAny(Instruction input) {
            return new AnyExternConversion(false, input);
        }
    }

    public static final class ArrayInitData
    extends Instruction {
        public final WasmId.ArrayType type;
        public final WasmId.Data dataSegment;
        public final Instruction dest;
        public final Instruction destOffset;
        public final Instruction srcOffset;
        public final Instruction size;

        public ArrayInitData(WasmId.ArrayType type, WasmId.Data dataSegment, Instruction dest, Instruction destOffset, Instruction srcOffset, Instruction size) {
            this.type = type;
            this.dataSegment = dataSegment;
            this.dest = dest;
            this.destOffset = destOffset;
            this.srcOffset = srcOffset;
            this.size = size;
        }
    }

    public static final class ArrayCopy
    extends Instruction {
        public final WasmId.ArrayType destType;
        public final WasmId.ArrayType srcType;
        public final Instruction dest;
        public final Instruction destOffset;
        public final Instruction src;
        public final Instruction srcOffset;
        public final Instruction size;

        public ArrayCopy(WasmId.ArrayType destType, WasmId.ArrayType srcType, Instruction dest, Instruction destOffset, Instruction src, Instruction srcOffset, Instruction size) {
            this.destType = destType;
            this.srcType = srcType;
            this.dest = dest;
            this.destOffset = destOffset;
            this.src = src;
            this.srcOffset = srcOffset;
            this.size = size;
        }
    }

    public static final class ArraySet
    extends Instruction {
        public final WasmId.ArrayType refType;
        public final Instruction ref;
        public final Instruction idx;
        public final Instruction value;

        public ArraySet(WasmId.ArrayType refType, Instruction ref, Instruction idx, Instruction value) {
            this.refType = refType;
            this.ref = ref;
            this.idx = idx;
            this.value = value;
        }
    }

    public static final class ArrayGet
    extends Instruction {
        public final WasmId.ArrayType refType;
        public final WasmUtil.Extension extension;
        public final Instruction ref;
        public final Instruction idx;

        public ArrayGet(WasmId.ArrayType refType, WasmUtil.Extension extension, Instruction ref, Instruction idx) {
            this.refType = refType;
            this.extension = extension;
            this.ref = ref;
            this.idx = idx;
        }
    }

    public static final class ArrayFill
    extends Instruction {
        public final WasmId.ArrayType arrayType;
        public final Instruction array;
        public final Instruction offset;
        public final Instruction value;
        public final Instruction size;

        public ArrayFill(WasmId.ArrayType arrayType, Instruction array, Instruction offset, Instruction value, Instruction size) {
            this.arrayType = arrayType;
            this.array = array;
            this.offset = offset;
            this.value = value;
            this.size = size;
        }
    }

    public static final class ArrayLen
    extends Instruction {
        public final Instruction ref;

        public ArrayLen(Instruction ref) {
            this.ref = ref;
        }
    }

    public static final class ArrayNewData
    extends Instruction {
        public final WasmId.ArrayType type;
        public final WasmId.Data dataSegment;
        public final Instruction offset;
        public final Instruction size;

        public ArrayNewData(WasmId.ArrayType type, WasmId.Data dataSegment, Instruction offset, Instruction size) {
            this.type = type;
            this.dataSegment = dataSegment;
            this.offset = offset;
            this.size = size;
        }
    }

    public static final class ArrayNewFixed
    extends Instruction {
        public static final int MAX_LENGTH = 10000;
        public final WasmId.ArrayType type;
        public final Instructions elementValues;

        public ArrayNewFixed(WasmId.ArrayType type, Instruction ... elements) {
            this.type = type;
            this.elementValues = Instructions.asInstructions(elements);
            assert (elements.length <= 10000) : "array.new_fixed has too many elements: " + elements.length + " (max: 10000)";
        }

        public int getLength() {
            return this.elementValues.get().size();
        }
    }

    public static final class ArrayNew
    extends Instruction {
        public final WasmId.ArrayType type;
        private final Instruction elementValue;
        public final Instruction length;

        public ArrayNew(WasmId.ArrayType type, Instruction length) {
            this(type, null, length);
        }

        public ArrayNew(WasmId.ArrayType type, Instruction elementValue, Instruction length) {
            this.type = type;
            this.elementValue = elementValue;
            this.length = length;
        }

        public boolean isDefault() {
            return this.elementValue == null;
        }

        public Instruction getElementValue() {
            assert (!this.isDefault()) : "There is no element value for array.new_default";
            return this.elementValue;
        }
    }

    public static final class StructSet
    extends Instruction {
        public final WasmId.StructType refType;
        public final WasmId.Field fieldId;
        public final Instruction ref;
        public final Instruction value;

        public StructSet(WasmId.StructType refType, WasmId.Field fieldId, Instruction ref, Instruction value) {
            this.refType = refType;
            this.fieldId = fieldId;
            this.ref = ref;
            this.value = value;
        }
    }

    public static final class StructGet
    extends Instruction {
        public final WasmId.StructType refType;
        public final WasmId.Field fieldId;
        public final WasmUtil.Extension extension;
        public final Instruction ref;

        public StructGet(WasmId.StructType refType, WasmId.Field fieldId, WasmUtil.Extension extension, Instruction ref) {
            this.refType = refType;
            this.fieldId = fieldId;
            this.extension = extension;
            this.ref = ref;
        }
    }

    public static final class StructNew
    extends Instruction {
        public final WasmId.StructType type;
        private final Instructions fieldValues;

        public StructNew(WasmId.StructType type) {
            this.type = type;
            this.fieldValues = null;
        }

        public StructNew(WasmId.StructType type, Instruction ... fieldValues) {
            this.type = type;
            this.fieldValues = Instructions.asInstructions(fieldValues);
        }

        public boolean isDefault() {
            return this.fieldValues == null;
        }

        public Instructions getFieldValues() {
            assert (!this.isDefault()) : "There are no field values for struct.new_default";
            return this.fieldValues;
        }
    }

    public static final class RefCast
    extends Instruction {
        public final Instruction input;
        public final WasmRefType newType;

        public RefCast(Instruction input, WasmRefType newType) {
            this.input = input;
            this.newType = newType;
        }
    }

    public static final class RefTest
    extends Instruction {
        public final Instruction input;
        public final WasmRefType testType;

        public RefTest(Instruction input, WasmRefType testType) {
            this.input = input;
            this.testType = testType;
        }
    }

    public static final class RefFunc
    extends Instruction {
        public final WasmId.Func func;

        public RefFunc(WasmId.Func func) {
            this.func = func;
        }
    }

    public static final class RefNull
    extends Instruction {
        public final WasmRefType heapType;

        public RefNull(WasmRefType heapType) {
            this.heapType = heapType;
            assert (heapType.nullable) : "Given type for ref.null must be nullable: " + String.valueOf(heapType);
        }

        public RefNull(WasmId.Type heapType) {
            this(heapType.asNullable());
        }
    }

    public static final class DataDrop
    extends Instruction {
        public final WasmId.Data dataSegment;

        public DataDrop(WasmId.Data dataSegment) {
            this.dataSegment = dataSegment;
        }
    }

    public static final class MemoryInit
    extends Instruction {
        public final WasmId.Data dataSegment;
        public final Instruction destOffset;
        public final Instruction srcOffset;
        public final Instruction size;

        public MemoryInit(WasmId.Data dataSegment, Instruction destOffset, Instruction srcOffset, Instruction size) {
            this.dataSegment = dataSegment;
            this.destOffset = destOffset;
            this.srcOffset = srcOffset;
            this.size = size;
        }
    }

    public static final class MemoryCopy
    extends Instruction {
        public final Instruction destOffset;
        public final Instruction srcOffset;
        public final Instruction size;

        public MemoryCopy(Instruction destOffset, Instruction srcOffset, Instruction size) {
            this.destOffset = destOffset;
            this.srcOffset = srcOffset;
            this.size = size;
        }
    }

    public static final class MemoryFill
    extends Instruction {
        public final Instruction start;
        public final Instruction fillValue;
        public final Instruction size;

        public MemoryFill(Instruction start, Instruction fillValue, Instruction size) {
            this.start = start;
            this.fillValue = fillValue;
            this.size = size;
        }
    }

    public static final class MemoryGrow
    extends Instruction {
        public final Instruction numPages;

        public MemoryGrow(Instruction numPages) {
            this.numPages = numPages;
        }
    }

    public static final class MemorySize
    extends Instruction {
    }

    public static final class Store
    extends Memory {
        public final Instruction value;
        public final Instruction baseAddress;

        public Store(WasmPrimitiveType stackType, Instruction value, Instruction baseAddress) {
            this(stackType, 0, value, baseAddress);
        }

        public Store(WasmPrimitiveType stackType, int offset, Instruction value, Instruction baseAddress) {
            this(stackType, offset, value, baseAddress, 0);
        }

        public Store(WasmPrimitiveType stackType, int offset, Instruction value, Instruction baseAddress, int memoryWidth) {
            this(stackType, Const.forInt(offset), value, baseAddress, memoryWidth);
        }

        public Store(WasmPrimitiveType stackType, Instruction offset, Instruction value, Instruction baseAddress, int memoryWidth) {
            super(false, stackType, memoryWidth, offset);
            this.value = value;
            this.baseAddress = baseAddress;
        }
    }

    public static final class Load
    extends Memory {
        public final Instruction baseAddress;
        public final boolean signed;

        public Load(WasmPrimitiveType stackType, int offset, Instruction baseAddress, int memoryWidth, boolean signed) {
            this(stackType, Const.forInt(offset), baseAddress, memoryWidth, signed);
        }

        public Load(WasmPrimitiveType stackType, Instruction offset, Instruction baseAddress, int memoryWidth, boolean signed) {
            super(true, stackType, memoryWidth, offset);
            this.baseAddress = baseAddress;
            this.signed = signed;
        }
    }

    public static abstract class Memory
    extends Instruction {
        public final boolean isLoad;
        public final WasmPrimitiveType stackType;
        public final int memoryWidth;
        private final Instruction offset;

        protected Memory(boolean isLoad, WasmPrimitiveType stackType, int memoryWidth, Instruction offset) {
            assert (memoryWidth == 0 || memoryWidth == 8 || memoryWidth == 16 || memoryWidth == 32 || memoryWidth == 64) : memoryWidth;
            this.memoryWidth = memoryWidth == stackType.getBitCount() ? 0 : memoryWidth;
            this.isLoad = isLoad;
            this.stackType = stackType;
            this.offset = offset;
        }

        public int calculateOffset() {
            Literal lit = Memory.asConst((Instruction)this.offset).literal;
            GraalError.guarantee((lit.type == WasmPrimitiveType.i32 ? 1 : 0) != 0, (String)"Memory offset is not a 32-bit integer: %s", (Object)lit);
            int val = lit.getI32();
            GraalError.guarantee((val >= 0 ? 1 : 0) != 0, (String)"Memory offset is negative: %d", (Object)val);
            return val;
        }

        public Instruction getOffset() {
            return this.offset;
        }
    }

    public static final class TableCopy
    extends Instruction {
        public final WasmId.Table destTable;
        public final WasmId.Table srcTable;
        public final Instruction destOffset;
        public final Instruction srcOffset;
        public final Instruction size;

        public TableCopy(WasmId.Table destTable, WasmId.Table srcTable, Instruction destOffset, Instruction srcOffset, Instruction size) {
            this.destTable = destTable;
            this.srcTable = srcTable;
            this.destOffset = destOffset;
            this.srcOffset = srcOffset;
            this.size = size;
        }
    }

    public static final class TableFill
    extends Instruction {
        public final WasmId.Table table;
        public final Instruction offset;
        public final Instruction value;
        public final Instruction size;

        public TableFill(WasmId.Table table, Instruction offset, Instruction value, Instruction size) {
            this.table = table;
            this.offset = offset;
            this.value = value;
            this.size = size;
        }
    }

    public static final class TableGrow
    extends Instruction {
        public final WasmId.Table table;
        public final Instruction initValue;
        public final Instruction delta;

        public TableGrow(WasmId.Table table, Instruction initValue, Instruction delta) {
            this.table = table;
            this.initValue = initValue;
            this.delta = delta;
        }
    }

    public static final class TableSize
    extends Instruction {
        public final WasmId.Table table;

        public TableSize(WasmId.Table table) {
            this.table = table;
        }
    }

    public static final class TableSet
    extends Instruction {
        public final WasmId.Table table;
        public final Instruction index;
        public final Instruction value;

        public TableSet(WasmId.Table table, Instruction index, Instruction value) {
            this.table = table;
            this.index = index;
            this.value = value;
        }
    }

    public static final class TableGet
    extends Instruction {
        public final WasmId.Table table;
        public final Instruction index;

        public TableGet(WasmId.Table table, Instruction index) {
            this.table = table;
            this.index = index;
        }
    }

    public static final class GlobalSet
    extends Instruction {
        private final WasmId.Global global;
        public final Instruction value;

        public GlobalSet(WasmId.Global global, Instruction value) {
            this.global = global;
            this.value = value;
        }

        public WasmId.Global getGlobal() {
            return this.global;
        }

        public WasmValType getType() {
            return this.global.getVariableType();
        }
    }

    public static final class GlobalGet
    extends Instruction {
        private final WasmId.Global global;

        public GlobalGet(WasmId.Global global) {
            this.global = global;
        }

        public WasmId.Global getGlobal() {
            return this.global;
        }

        public WasmValType getType() {
            return this.global.getVariableType();
        }
    }

    public static final class LocalTee
    extends Instruction {
        private final WasmId.Local local;
        public final Instruction value;

        public LocalTee(WasmId.Local local, Instruction value) {
            this.local = local;
            this.value = value;
        }

        public WasmId.Local getLocal() {
            return this.local;
        }

        public WasmValType getType() {
            return this.local.getVariableType();
        }
    }

    public static final class LocalSet
    extends Instruction {
        private final WasmId.Local local;
        public final Instruction value;

        public LocalSet(WasmId.Local local, Instruction value) {
            this.local = local;
            this.value = value;
        }

        public WasmId.Local getLocal() {
            return this.local;
        }

        public WasmValType getType() {
            return this.local.getVariableType();
        }
    }

    public static final class LocalGet
    extends Instruction {
        private final WasmId.Local local;

        public LocalGet(WasmId.Local local) {
            this.local = local;
        }

        public WasmId.Local getLocal() {
            return this.local;
        }

        public WasmValType getType() {
            return this.local.getVariableType();
        }
    }

    public static final class Select
    extends Instruction {
        public final Instruction condition;
        public final Instruction trueValue;
        public final Instruction falseValue;
        public final WasmValType type;

        public Select(Instruction trueValue, Instruction falseValue, Instruction condition, WasmValType type) {
            this.condition = condition;
            this.trueValue = trueValue;
            this.falseValue = falseValue;
            this.type = type;
            assert (type != null);
        }
    }

    public static final class Drop
    extends Instruction {
        public final Instruction value;

        public Drop(Instruction value) {
            this.value = value;
        }
    }

    public static final class Binary
    extends Instruction {
        public final Op op;
        public final Instruction left;
        public final Instruction right;

        private Binary(Op op, Instruction left, Instruction right) {
            this.op = op;
            this.left = left;
            this.right = right;
        }

        public static enum Op {
            I32Add("i32.add", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Sub("i32.sub", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Mul("i32.mul", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32DivU("i32.div_u", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32DivS("i32.div_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32RemU("i32.rem_u", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32RemS("i32.rem_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32And("i32.and", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Or("i32.or", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Xor("i32.xor", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Shl("i32.shl", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32ShrU("i32.shr_u", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32ShrS("i32.shr_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Eq("i32.eq", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Ne("i32.ne", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32LtU("i32.lt_u", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32LtS("i32.lt_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32GtU("i32.gt_u", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32GtS("i32.gt_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32LeU("i32.le_u", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32LeS("i32.le_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32GeU("i32.ge_u", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32GeS("i32.ge_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I64Add("i64.add", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Sub("i64.sub", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Mul("i64.mul", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64DivU("i64.div_u", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64DivS("i64.div_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64RemU("i64.rem_u", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64RemS("i64.rem_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64And("i64.and", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Or("i64.or", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Xor("i64.xor", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Shl("i64.shl", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64ShrU("i64.shr_u", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64ShrS("i64.shr_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Eq("i64.eq", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64Ne("i64.ne", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64LtU("i64.lt_u", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64LtS("i64.lt_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64GtU("i64.gt_u", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64GtS("i64.gt_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64LeU("i64.le_u", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64LeS("i64.le_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64GeU("i64.ge_u", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I64GeS("i64.ge_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            F32Add("f32.add", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Sub("f32.sub", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Mul("f32.mul", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Div("f32.div", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Min("f32.min", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Max("f32.max", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32CopySign("f32.copysign", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F64Add("f64.add", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Sub("f64.sub", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Mul("f64.mul", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Div("f64.div", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Min("f64.min", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Max("f64.max", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64CopySign("f64.copysign", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F32Eq("f32.eq", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.i32),
            F32Lt("f32.lt", WasmPrimitiveType.f32, WasmPrimitiveType.f32, WasmPrimitiveType.i32),
            F64Eq("f64.eq", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.i32),
            F64Lt("f64.lt", WasmPrimitiveType.f64, WasmPrimitiveType.f64, WasmPrimitiveType.i32),
            RefEq("ref.eq", WasmRefType.ANYREF, WasmRefType.ANYREF, WasmPrimitiveType.i32);

            public final String opName;
            public final WasmValType leftInputType;
            public final WasmValType rightInputType;
            public final WasmValType outputType;

            private Op(String opName, WasmValType leftInputType, WasmValType rightInputType, WasmValType outputType) {
                this.opName = opName;
                this.leftInputType = leftInputType;
                this.rightInputType = rightInputType;
                this.outputType = outputType;
            }

            public Binary create(Instruction left, Instruction right) {
                return new Binary(this, left, right);
            }
        }
    }

    public static final class Unary
    extends Instruction {
        public final Op op;
        public final Instruction value;

        private Unary(Op op, Instruction value) {
            this.op = op;
            this.value = value;
        }

        public static enum Op {
            Nop("", null, null),
            I32Clz("i32.clz", WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Ctz("i32.ctz", WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Popcnt("i32.popcnt", WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I32Eqz("i32.eqz", WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I64Clz("i64.clz", WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Ctz("i64.ctz", WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Popcnt("i64.popcnt", WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Eqz("i64.eqz", WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            I32Extend8("i32.extend8_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I64Extend8("i64.extend8_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I32Extend16("i32.extend16_s", WasmPrimitiveType.i32, WasmPrimitiveType.i32),
            I64Extend16("i64.extend16_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64Extend32("i64.extend32_s", WasmPrimitiveType.i64, WasmPrimitiveType.i64),
            I64ExtendI32U("i64.extend_i32_u", WasmPrimitiveType.i32, WasmPrimitiveType.i64),
            I64ExtendI32S("i64.extend_i32_s", WasmPrimitiveType.i32, WasmPrimitiveType.i64),
            F32Abs("f32.abs", WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Neg("f32.neg", WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Sqrt("f32.sqrt", WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Ceil("f32.ceil", WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Floor("f32.floor", WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Trunc("f32.trunc", WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F32Nearest("f32.nearest", WasmPrimitiveType.f32, WasmPrimitiveType.f32),
            F64Abs("f64.abs", WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Neg("f64.neg", WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Sqrt("f64.sqrt", WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Ceil("f64.ceil", WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Floor("f64.floor", WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Trunc("f64.trunc", WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            F64Nearest("f64.nearest", WasmPrimitiveType.f64, WasmPrimitiveType.f64),
            I32Wrap64("i32.wrap_i64", WasmPrimitiveType.i64, WasmPrimitiveType.i32),
            F32Demote64("f32.demote_f64", WasmPrimitiveType.f64, WasmPrimitiveType.f32),
            F64Promote32("f64.promote_f32", WasmPrimitiveType.f32, WasmPrimitiveType.f64),
            F32ConvertI32S("f32.convert_i32_s", WasmPrimitiveType.i32, WasmPrimitiveType.f32),
            F32ConvertI64S("f32.convert_i64_s", WasmPrimitiveType.i64, WasmPrimitiveType.f32),
            F64ConvertI32S("f64.convert_i32_s", WasmPrimitiveType.i32, WasmPrimitiveType.f64),
            F64ConvertI64S("f64.convert_i64_s", WasmPrimitiveType.i64, WasmPrimitiveType.f64),
            I32TruncSatF32S("i32.trunc_sat_f32_s", WasmPrimitiveType.f32, WasmPrimitiveType.i32),
            I32TruncSatF64S("i32.trunc_sat_f64_s", WasmPrimitiveType.f64, WasmPrimitiveType.i32),
            I64TruncSatF32S("i64.trunc_sat_f32_s", WasmPrimitiveType.f32, WasmPrimitiveType.i64),
            I64TruncSatF64S("i64.trunc_sat_f64_s", WasmPrimitiveType.f64, WasmPrimitiveType.i64),
            I32ReinterpretF32("i32.reinterpret_f32", WasmPrimitiveType.f32, WasmPrimitiveType.i32),
            I64ReinterpretF64("i64.reinterpret_f64", WasmPrimitiveType.f64, WasmPrimitiveType.i64),
            F32ReinterpretI32("f32.reinterpret_i32", WasmPrimitiveType.i32, WasmPrimitiveType.f32),
            F64ReinterpretI64("f64.reinterpret_i64", WasmPrimitiveType.i64, WasmPrimitiveType.f64),
            RefIsNull("ref.is_null", WasmRefType.ANYREF, WasmPrimitiveType.i32),
            RefAsNonNull("ref.as_non_null", WasmRefType.ANYREF, WasmRefType.ANYREF.asNonNull());

            public final String opName;
            public final WasmValType inputType;
            public final WasmValType outputType;

            private Op(String opName, WasmValType inputType, WasmValType outputType) {
                this.opName = opName;
                this.inputType = inputType;
                this.outputType = outputType;
            }

            public Unary create(Instruction input) {
                return new Unary(this, input);
            }
        }
    }

    public static final class Throw
    extends Instruction {
        public final WasmId.Tag tag;
        public final Instructions arguments;

        public Throw(WasmId.Tag tag, Instructions arguments) {
            this.tag = tag;
            this.arguments = arguments;
        }

        public Throw(WasmId.Tag tag, Instruction ... args) {
            this(tag, Instructions.asInstructions(args));
        }
    }

    public static final class Return
    extends Instruction {
        public final Instruction result;

        public Return() {
            this(null);
        }

        public Return(Instruction result) {
            this.result = result;
        }

        public boolean isVoid() {
            return this.result == null;
        }
    }

    public static final class CallIndirect
    extends AbstractCall {
        public final WasmId.Table table;
        public final Instruction index;
        public final WasmId.FuncType funcId;
        public final TypeUse signature;

        public CallIndirect(WasmId.Table table, Instruction index, WasmId.FuncType funcId, TypeUse signature, Instructions args) {
            super(args);
            assert (signature.params.size() == args.get().size()) : "Number of arguments in signature (" + signature.params.size() + ") must match number of arguments given (" + args.get().size() + ")";
            this.table = table;
            this.index = index;
            this.funcId = funcId;
            this.signature = signature;
        }

        @Override
        public String toInnerString() {
            return "call_indirect " + String.valueOf(this.table) + " " + String.valueOf(this.signature);
        }
    }

    public static final class CallRef
    extends AbstractCall {
        public final WasmId.Type functionType;
        public final Instruction functionReference;

        public CallRef(WasmId.Type functionType, Instruction functionReference, Instructions args) {
            super(args);
            this.functionType = functionType;
            this.functionReference = functionReference;
        }
    }

    public static final class Call
    extends AbstractCall {
        private final WasmId.Func target;

        public Call(WasmId.Func target, Instructions args) {
            super(args);
            this.target = target;
        }

        public Call(WasmId.Func target, Instruction ... args) {
            this(target, Instructions.asInstructions(args));
        }

        public WasmId.Func getTarget() {
            return this.target;
        }
    }

    public static abstract class AbstractCall
    extends Instruction {
        public final Instructions args;

        protected AbstractCall(Instructions args) {
            this.args = args;
        }

        protected AbstractCall(Instruction ... args) {
            this(Instructions.asInstructions(args));
        }
    }

    public static final class BreakTable
    extends Instruction {
        private final List<WasmId.Label> targets = new ArrayList<WasmId.Label>();
        private WasmId.Label defaultTarget;
        public final Instruction index;

        public BreakTable(Instruction index) {
            this.index = index;
        }

        public int numTargets() {
            return this.targets.size();
        }

        public WasmId.Label getTarget(int idx) {
            return this.targets.get(idx);
        }

        public void setTarget(int key, WasmId.Label target) {
            assert (NumUtil.assertNonNegativeInt((int)key));
            if (key >= this.targets.size()) {
                this.targets.addAll(Collections.nCopies(key - this.targets.size() + 1, null));
            }
            this.targets.set(key, target);
        }

        public void fillTargets() {
            this.targets.replaceAll(t -> t == null ? this.defaultTarget : t);
        }

        public WasmId.Label getDefaultTarget() {
            return this.defaultTarget;
        }

        public void setDefaultTarget(WasmId.Label defaultTarget) {
            this.defaultTarget = defaultTarget;
        }
    }

    public static final class Break
    extends Instruction {
        private final WasmId.Label target;
        public final Instruction condition;

        public Break(WasmId.Label target) {
            this(target, null);
        }

        public Break(WasmId.Label target, Instruction condition) {
            this.target = target;
            this.condition = condition;
        }

        public WasmId.Label getTarget() {
            return this.target;
        }
    }

    public static final class Unreachable
    extends Instruction {
    }

    public static final class Nop
    extends Instruction {
    }

    public static final class Try
    extends WasmBlock {
        public final Instructions instructions = new Instructions();
        public final List<Catch> catchBlocks = new ArrayList<Catch>();

        public Try(WasmId.Label label) {
            super(label);
        }

        public Instructions addCatch(WasmId.Tag tag) {
            Catch catchBlock = new Catch(tag);
            this.catchBlocks.add(catchBlock);
            return catchBlock.instructions;
        }

        public static final class Catch {
            public final WasmId.Tag tag;
            public final Instructions instructions = new Instructions();

            private Catch(WasmId.Tag tag) {
                this.tag = tag;
            }
        }
    }

    public static final class If
    extends WasmBlock {
        public final Instructions thenInstructions = new Instructions();
        public final Instructions elseInstructions = new Instructions();
        public final Instruction condition;

        public If(WasmId.Label label, Instruction condition) {
            super(label);
            this.condition = condition;
        }

        public boolean hasElse() {
            return !this.elseInstructions.get().isEmpty();
        }
    }

    public static final class Loop
    extends WasmBlock {
        public final Instructions instructions = new Instructions();

        public Loop(WasmId.Label label) {
            super(label);
        }
    }

    public static final class Block
    extends WasmBlock {
        public final Instructions instructions = new Instructions();

        public Block(WasmId.Label label) {
            super(label);
        }
    }

    public static abstract class WasmBlock
    extends Instruction {
        protected final WasmId.Label label;

        public WasmBlock(WasmId.Label label) {
            this.label = label;
        }

        public WasmId.Label getLabel() {
            return this.label;
        }
    }
}

