/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import java.util.Objects;

public abstract sealed class ImportDescriptor {
    public final String module;
    public final String name;
    public final Object comment;

    protected ImportDescriptor(String module, String name, Object comment) {
        this.module = module;
        this.name = name;
        this.comment = comment;
    }

    public abstract String getType();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.module).append('.').append(this.name);
        if (this.comment != null) {
            sb.append(" (").append(this.comment).append(")");
        }
        return sb.toString();
    }

    public static final class Function
    extends ImportDescriptor {
        public final TypeUse typeUse;

        public Function(String module, String name, TypeUse typeUse, Object comment) {
            super(module, name, comment);
            this.typeUse = typeUse;
        }

        @Override
        public String getType() {
            return "func";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Function function = (Function)o;
            return Objects.equals(this.module, function.module) && Objects.equals(this.name, function.name) && Objects.equals(this.typeUse, function.typeUse);
        }

        public int hashCode() {
            return Objects.hash(this.module, this.name, this.typeUse);
        }
    }
}

