/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.ModuleField;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Function
extends ModuleField {
    private final WasmId.Func id;
    public final List<WasmId.Local> params;
    private final List<WasmId.Local> locals = new ArrayList<WasmId.Local>();
    private final Instructions instructions = new Instructions();
    private final WasmId.FuncType funcType;
    private final TypeUse signature;

    public Function(WasmId.Func id, List<WasmId.Local> params, WasmId.FuncType funcType, TypeUse signature, Object comment) {
        super(comment);
        this.id = id;
        this.params = Collections.unmodifiableList(params);
        this.funcType = funcType;
        this.signature = signature;
        assert (this.signature.params.size() == params.size()) : this.signature.params.size() + " != " + params.size();
    }

    public static Function create(WasmIdFactory idFactory, WasmId.Func id, WasmId.FuncType funcType, TypeUse signature, Object comment) {
        ArrayList<WasmId.Local> params = new ArrayList<WasmId.Local>(signature.params.size());
        for (int i = 0; i < signature.params.size(); ++i) {
            WasmValType paramType = signature.params.get(i);
            assert (paramType != null);
            params.add(idFactory.newParam(i, paramType));
        }
        return new Function(id, params, funcType, signature, comment);
    }

    public static Function createSimple(WasmIdFactory idFactory, WasmId.Func id, TypeUse signature, Object comment) {
        return Function.create(idFactory, id, idFactory.newFuncType(FunctionTypeDescriptor.createSimple(signature)), signature, comment);
    }

    public WasmId.Func getId() {
        return this.id;
    }

    public WasmId.FuncType getFuncType() {
        return this.funcType;
    }

    public TypeUse getSignature() {
        return this.signature;
    }

    public void allocateVariable(WasmId.Local varId) {
        this.locals.add(varId);
    }

    public List<WasmId.Local> getLocals() {
        return Collections.unmodifiableList(this.locals);
    }

    public WasmId.Local getParam(int idx) {
        return this.params.get(idx);
    }

    public List<WasmId.Local> getParams() {
        return this.params;
    }

    public List<WasmValType> getResults() {
        return this.getSignature().results;
    }

    public Instructions getInstructions() {
        return this.instructions;
    }
}

