/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.ModuleField;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;

public class Export
extends ModuleField {
    public final Type type;
    public final String name;
    protected WasmId id;

    public Export(Type type, WasmId id, String name, Object comment) {
        super(comment);
        this.type = type;
        this.name = name;
        this.id = id;
        assert ((switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> WasmId.Func.class;
            case 1 -> WasmId.Table.class;
            case 2 -> WasmId.Memory.class;
            case 3 -> WasmId.Global.class;
            case 4 -> WasmId.Tag.class;
        }).isAssignableFrom(id.getClass())) : "type=" + String.valueOf((Object)type) + ", id=" + String.valueOf(id);
    }

    public static Export forFunction(WasmId.Func id, String name, Object comment) {
        return new Export(Type.FUNC, id, name, comment);
    }

    public WasmId getId() {
        return this.id;
    }

    public WasmId.Func getFuncId() {
        assert (this.type == Type.FUNC);
        return (WasmId.Func)this.id;
    }

    public WasmId.Table getTableId() {
        assert (this.type == Type.TABLE);
        return (WasmId.Table)this.id;
    }

    public WasmId.Memory getMemoryId() {
        assert (this.type == Type.MEM);
        return (WasmId.Memory)this.id;
    }

    public WasmId.Global getGlobalId() {
        assert (this.type == Type.GLOBAL);
        return (WasmId.Global)this.id;
    }

    public WasmId.Tag getTagId() {
        assert (this.type == Type.TAG);
        return (WasmId.Tag)this.id;
    }

    public String toString() {
        return String.format("(export \"%s\" (%s %s))", this.name, this.type.name, this.id);
    }

    public static enum Type {
        FUNC("func"),
        TABLE("table"),
        MEM("memory"),
        GLOBAL("global"),
        TAG("tag");

        public final String name;

        private Type(String name) {
            this.name = name;
        }
    }
}

