/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.ast;

import com.oracle.svm.hosted.webimage.wasm.ast.Data;
import com.oracle.svm.util.ClassUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class ActiveData {
    public static final int NULL_COUNT_THRESHOLD = 14;
    protected final TreeSet<Segment> segments = new TreeSet();

    public List<Segment> getSegments() {
        return new ArrayList<Segment>(this.segments);
    }

    protected boolean doesIntersect(long offset, long size) {
        return this.segments.stream().anyMatch(segment -> segment.overlaps(offset, size));
    }

    public void addData(long offset, byte[] data) {
        assert (!this.doesIntersect(offset, data.length)) : "Data segment at " + offset + " and size " + data.length + " overlaps with existing segments.";
        ByteArrayOutputStream os = new ByteArrayOutputStream(data.length);
        int numTrailingNulls = 0;
        AtomicLong segmentStart = new AtomicLong(0L);
        boolean isInNullSegment = false;
        Consumer<Segment> addSegment = segment -> {
            this.segments.add((Segment)segment);
            segmentStart.addAndGet(segment.getSize());
        };
        Runnable addDataSegment = () -> {
            if (os.size() > 0) {
                addSegment.accept(new DataSegment(offset + segmentStart.get(), os.toByteArray()));
                os.reset();
            }
        };
        IntConsumer addNullSegment = size -> addSegment.accept(new NullSegment(offset + segmentStart.get(), size));
        for (byte b : data) {
            if (b == 0) {
                if (++numTrailingNulls != 14) continue;
                isInNullSegment = true;
                addDataSegment.run();
                continue;
            }
            if (isInNullSegment) {
                assert (os.size() == 0) : "In a NullSegment, output must be empty, was: " + Arrays.toString(os.toByteArray());
                addNullSegment.accept(numTrailingNulls);
                isInNullSegment = false;
            } else if (numTrailingNulls > 0) {
                os.writeBytes(new byte[numTrailingNulls]);
            }
            numTrailingNulls = 0;
            os.write(b);
        }
        if (os.size() > 0) {
            assert (!isInNullSegment) : "Cannot be in NullSegment if there is output: " + Arrays.toString(os.toByteArray());
            addDataSegment.run();
        }
        assert (os.size() == 0) : Arrays.toString(os.toByteArray());
        if (numTrailingNulls > 0) {
            addNullSegment.accept(numTrailingNulls);
        }
        assert (segmentStart.get() == (long)data.length) : segmentStart.get() + " != " + data.length;
    }

    public List<Data> constructDataSegments(int maxSegments) {
        assert (maxSegments >= 1) : "Must request at least one data segment, requested " + maxSegments;
        List<DataSegment> dataSegments = this.segments.stream().filter(DataSegment.class::isInstance).map(DataSegment.class::cast).toList();
        List<Data> list = dataSegments.size() > maxSegments ? ActiveData.mergeAllSegments(dataSegments, maxSegments) : dataSegments.stream().map(segment -> new Data(null, (byte[])segment.data.clone(), segment.offset, null)).toList();
        this.segments.clear();
        return list;
    }

    private static List<Data> mergeAllSegments(List<DataSegment> dataSegments, int maxSegments) {
        BitSet toMerge = ActiveData.findSegmentsToMerge(dataSegments, maxSegments);
        ArrayList<Data> list = new ArrayList<Data>(maxSegments);
        ListIterator<DataSegment> it = dataSegments.listIterator();
        while (it.hasNext()) {
            int idx = it.nextIndex();
            DataSegment thisSegment = it.next();
            int endIdx = idx;
            while (toMerge.get(endIdx)) {
                assert (it.hasNext()) : "The last segment was marked to be merged with the next one";
                endIdx = it.nextIndex();
                it.next();
            }
            byte[] data = ActiveData.mergeSegments(dataSegments, idx, endIdx);
            list.add(new Data(null, data, thisSegment.offset, null));
        }
        assert (list.size() == maxSegments) : list.size() + " != " + maxSegments;
        return list;
    }

    private static byte[] mergeSegments(List<DataSegment> dataSegments, int start, int end) {
        DataSegment startSegment = dataSegments.get(start);
        int newSize = Math.toIntExact(dataSegments.get(end).getEnd() - startSegment.offset);
        byte[] data = Arrays.copyOf(startSegment.data, newSize);
        for (int i = start + 1; i <= end; ++i) {
            DataSegment s = dataSegments.get(i);
            System.arraycopy(s.data, 0, data, Math.toIntExact(s.offset - startSegment.offset), Math.toIntExact(s.getSize()));
        }
        return data;
    }

    private static BitSet findSegmentsToMerge(List<DataSegment> dataSegments, int maxSegments) {
        int numMerges = dataSegments.size() - maxSegments;
        assert (numMerges > 0) : "No merges required. Only call this method if merges are required.";
        PriorityQueue<GapEntry> gaps = new PriorityQueue<GapEntry>(dataSegments.size() - 1);
        for (int i = 0; i < dataSegments.size() - 1; ++i) {
            gaps.add(new GapEntry(dataSegments.get((int)(i + 1)).offset - dataSegments.get(i + 1).getEnd(), i));
        }
        BitSet toMerge = new BitSet(dataSegments.size());
        for (int i = 0; i < numMerges; ++i) {
            GapEntry gap = (GapEntry)gaps.poll();
            assert (gap != null);
            toMerge.set(gap.leftSegmentIdx);
        }
        return toMerge;
    }

    public static class DataSegment
    extends Segment {
        final byte[] data;

        DataSegment(long offset, byte[] data) {
            super(offset);
            assert (data.length > 0) : "Empty data segments are not allowed/necessary";
            this.data = data;
            assert (this.checkNullBytes());
        }

        @Override
        public long getSize() {
            return this.data.length;
        }

        boolean checkNullBytes() {
            int longestStreak = 0;
            for (byte b : this.data) {
                if (b == 0) {
                    assert (++longestStreak < 14) : longestStreak;
                    continue;
                }
                longestStreak = 0;
            }
            return true;
        }
    }

    private record GapEntry(long gap, int leftSegmentIdx) implements Comparable<GapEntry>
    {
        @Override
        public int compareTo(GapEntry o) {
            if (this.gap == o.gap) {
                return Integer.compare(this.leftSegmentIdx, o.leftSegmentIdx);
            }
            return Long.compare(this.gap, o.gap);
        }
    }

    public static class NullSegment
    extends Segment {
        final long size;

        NullSegment(long offset, long size) {
            super(offset);
            assert (size > 0L) : size;
            this.size = size;
        }

        @Override
        public long getSize() {
            return this.size;
        }
    }

    public static abstract class Segment
    implements Comparable<Segment> {
        final long offset;

        Segment(long offset) {
            this.offset = offset;
        }

        public abstract long getSize();

        public long getEnd() {
            return this.offset + this.getSize();
        }

        boolean overlaps(long start, long size) {
            return start < this.offset + this.getSize() && this.offset < start + size;
        }

        @Override
        public int compareTo(Segment o) {
            return Long.compare(this.offset, o.offset);
        }

        public String toString() {
            return ClassUtil.getUnqualifiedName(this.getClass()) + "{offset=" + this.offset + ", size=" + this.getSize() + ", [" + this.offset + ", " + (this.offset + this.getSize()) + ")}";
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

