/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class WebImageWasmOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(WebImageWasmOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "DebugNames": {
                return OptionDescriptor.create((String)"DebugNames", (OptionType)OptionType.Debug, Boolean.class, (String)"Assemble the Wasm binary file with debug names.", (Object)this.getContainer(), WebImageWasmOptions.DebugNames, (String)"DebugNames", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "FatalUnsupportedNodes": {
                return OptionDescriptor.create((String)"FatalUnsupportedNodes", (OptionType)OptionType.Debug, Boolean.class, (String)"Unsupported nodes trap with error message at runtime. If false, they are no-ops with a stub value.", (Object)this.getContainer(), WebImageWasmOptions.FatalUnsupportedNodes, (String)"FatalUnsupportedNodes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImageHeapObjectsPerFunction": {
                return OptionDescriptor.create((String)"ImageHeapObjectsPerFunction", (OptionType)OptionType.Expert, Integer.class, (String)"At most this many image heap objects are initialized in a single function. Only applies to the WasmGC backend", (Object)this.getContainer(), WebImageWasmOptions.ImageHeapObjectsPerFunction, (String)"ImageHeapObjectsPerFunction", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StackSize": {
                return OptionDescriptor.create((String)"StackSize", (OptionType)OptionType.Debug, Integer.class, (String)"Size of the WASM shadow stack (in 64KiB pages).", (Object)this.getContainer(), WebImageWasmOptions.StackSize, (String)"StackSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "WasmComments": {
                return OptionDescriptor.create((String)"WasmComments", (OptionType)OptionType.Debug, WebImageOptions.CommentVerbosity.class, (String)"Determine the level of verbosity for comments in the WASM text format.Has no effect on code size, the binary format does not have comments.", (Object)this.getContainer(), WebImageWasmOptions.WasmComments, (String)"WasmComments", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 5;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return WebImageWasmOptions_OptionDescriptors.this.get("DebugNames");
                    }
                    case 1: {
                        return WebImageWasmOptions_OptionDescriptors.this.get("FatalUnsupportedNodes");
                    }
                    case 2: {
                        return WebImageWasmOptions_OptionDescriptors.this.get("ImageHeapObjectsPerFunction");
                    }
                    case 3: {
                        return WebImageWasmOptions_OptionDescriptors.this.get("StackSize");
                    }
                    case 4: {
                        return WebImageWasmOptions_OptionDescriptors.this.get("WasmComments");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

