/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import jdk.graal.compiler.options.EnumOptionKey;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class WebImageWasmOptions {
    public static final HostedOptionKey<Integer> StackSize = new HostedOptionKey((Object)16);
    public static final EnumOptionKey<WebImageOptions.CommentVerbosity> WasmComments = new EnumOptionKey((Enum)WebImageOptions.CommentVerbosity.NORMAL);
    public static final HostedOptionKey<Boolean> DebugNames = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        public Boolean getValue(OptionValues values) {
            assert (this.checkDescriptorExists());
            return this.getValueOrDefault(values.getMap());
        }

        public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
            if (values.containsKey((Object)this)) {
                return (Boolean)values.get((Object)this);
            }
            return (Integer)SubstrateOptions.GenerateDebugInfo.getValueOrDefault(values) > 0;
        }
    };
    public static final HostedOptionKey<Boolean> FatalUnsupportedNodes = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        public Boolean getValue(OptionValues values) {
            assert (this.checkDescriptorExists());
            return this.getValueOrDefault(values.getMap());
        }

        public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
            if (values.containsKey((Object)this)) {
                return (Boolean)values.get((Object)this);
            }
            return (Integer)SubstrateOptions.GenerateDebugInfo.getValueOrDefault(values) > 0;
        }
    };
    public static final HostedOptionKey<Integer> ImageHeapObjectsPerFunction = new HostedOptionKey((Object)100000, optionKey -> {
        if (optionKey.hasBeenSet() && (Integer)optionKey.getValue() <= 0) {
            throw UserError.abort((String)"Option '%s' must be a positive number", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)optionKey, (String)((Integer)optionKey.getValue()).toString())});
        }
    });

    public static boolean fatalUnsupportedNodes() {
        return (Boolean)FatalUnsupportedNodes.getValue();
    }

    public static int getNumberOfImageHeapObjectsPerFunction() {
        return (Integer)ImageHeapObjectsPerFunction.getValue();
    }

    public static boolean genComments(WebImageOptions.CommentVerbosity verbosity) {
        return ((WebImageOptions.CommentVerbosity)((Object)WasmComments.getValue(HostedOptionValues.singleton()))).isEnabled(verbosity);
    }

    public static boolean genComments() {
        return WebImageWasmOptions.genComments(WebImageOptions.CommentVerbosity.NORMAL);
    }
}

