/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.hosted.webimage.wasm.gc.MemoryLayout;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.WordBase;

@AutomaticallyRegisteredImageSingleton(value={StackOverflowCheck.PlatformSupport.class})
@Platforms(value={WebImageWasmLMPlatform.class})
final class WebImageWasmLMStackOverflowSupport
implements StackOverflowCheck.PlatformSupport {
    WebImageWasmLMStackOverflowSupport() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean lookupStack(WordPointer stackBasePtr, WordPointer stackEndPtr) {
        stackBasePtr.write((WordBase)MemoryLayout.getStackBase());
        stackEndPtr.write((WordBase)MemoryLayout.getStackBottom());
        return true;
    }
}

