/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.hosted.webimage.wasm.annotation.WasmStartFunction;
import com.oracle.svm.hosted.webimage.wasm.gc.MemoryLayout;
import com.oracle.svm.webimage.WebImageJavaMainSupport;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;

@Platforms(value={WebImageWasmLMPlatform.class})
public class WebImageWasmLMJavaMainSupport
extends WebImageJavaMainSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public WebImageWasmLMJavaMainSupport(Method javaMainMethod) throws IllegalAccessException {
        super(javaMainMethod);
    }

    public static int run(int argc, CIntPointer argLengthArray, CShortPointer argChars) {
        return WebImageJavaMainSupport.run(WebImageWasmLMJavaMainSupport.readArguments(argc, argLengthArray, argChars));
    }

    public static int initializeLibrary(int argc, CIntPointer argLengthArray, CShortPointer argChars) {
        return WebImageJavaMainSupport.initializeLibrary(WebImageWasmLMJavaMainSupport.readArguments(argc, argLengthArray, argChars));
    }

    private static String[] readArguments(int argc, CIntPointer argLengthArray, CShortPointer argChars) {
        String[] args = new String[argc];
        int base = 0;
        for (int i = 0; i < argc; ++i) {
            int argLength = argLengthArray.read(i);
            char[] chars = new char[argLength];
            for (int j = 0; j < argLength; ++j) {
                chars[j] = (char)argChars.read(base + j);
            }
            args[i] = new String(chars);
            base += argLength;
        }
        return args;
    }

    @WasmStartFunction
    @Uninterruptible(reason="Runs while module is constructed")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator not yet initialized")
    public static void initialize() {
        StackOverflowCheck.singleton().initialize();
        MemoryLayout.initialize();
        VMThreads.StatusSupport.setStatusJavaUnguarded();
    }
}

