/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.code.SubstrateSuitesCreatorProvider;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.ExceptionSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.hosted.webimage.codegen.WebImageNoRegisterConfig;
import com.oracle.svm.hosted.webimage.wasm.WasmLMGraphBuilderPlugins;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmLMLoweringProvider;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmReservedRegisters;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmAssembler;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmLMBackend;
import com.oracle.svm.hosted.webimage.wasm.phases.WebImageWasmLMSuitesCreatorProvider;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.java.LoadExceptionObjectNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageWasmLMPlatform.class})
public class WebImageWasmLMFeature
implements InternalFeature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        WasmAssembler.install();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateRegisterConfigFactory.class, (config, metaAccess, target, preserveFramePointer) -> new WebImageNoRegisterConfig());
        ImageSingletons.add(ReservedRegisters.class, (Object)((Object)new WebImageWasmReservedRegisters()));
        ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(this){

            public SubstrateBackend newBackend(Providers newProviders) {
                return new WebImageWasmLMBackend(newProviders);
            }
        });
        ImageSingletons.add(SubstrateLoweringProviderFactory.class, WebImageWasmLMLoweringProvider::new);
        ImageSingletons.add(TargetGraphBuilderPlugins.class, (Object)new WasmLMGraphBuilderPlugins());
        ImageSingletons.add(SubstrateSuitesCreatorProvider.class, (Object)((Object)new WebImageWasmLMSuitesCreatorProvider()));
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        lowerings.put((Class<Node>)LoadExceptionObjectNode.class, (NodeLoweringProvider<?>)new ExceptionSnippets.LoadExceptionObjectLowering());
    }
}

