/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.code.WebImageCompileQueue;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.phases.common.AddressLoweringPhase;
import jdk.graal.compiler.phases.tiers.Suites;

public class WebImageWasmLMCompileQueue
extends WebImageCompileQueue {
    public WebImageWasmLMCompileQueue(FeatureHandler featureHandler, HostedUniverse hUniverse, RuntimeConfiguration runtimeConfiguration, DebugContext debug) {
        super(featureHandler, hUniverse, runtimeConfiguration, debug);
    }

    @Override
    protected Suites createRegularSuites() {
        SubstrateBackend backend = this.runtimeConfig.getBackendForNormalMethod();
        Suites suites = super.createRegularSuites();
        suites.getLowTier().replacePlaceholder(AddressLoweringPhase.class, backend.newAddressLoweringPhase(backend.getCodeCache()));
        this.featureHandler.forEachGraalFeature(feature -> feature.registerGraalPhases(backend.getProviders(), suites, true));
        return suites;
    }
}

