/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCompilationResult;
import com.oracle.svm.webimage.wasm.code.FrameData;
import com.oracle.svm.webimage.wasm.code.WasmCodeInfoHolder;
import com.oracle.svm.webimage.wasm.code.WasmCodeInfoQueryResult;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.UnsignedWord;

public class WebImageWasmCodeCache
extends WebImageCodeCache {
    private final HashMap<Integer, WasmCodeInfoQueryResult> codeInfoMap = new HashMap();

    public WebImageWasmCodeCache(Map<HostedMethod, CompilationResult> compilationResultMap, NativeImageHeap imageHeap) {
        super(compilationResultMap, imageHeap);
    }

    @Override
    public int codeSizeFor(HostedMethod method) {
        int methodStart = method.getCodeAddressOffset();
        int methodEnd = WebImageWasmCodeCache.computeNextMethodStart(methodStart, this.compilationResultFor(method).getTargetCodeSize());
        return methodEnd - methodStart;
    }

    @Override
    public void layoutMethods(DebugContext debug, BigBang bb) {
        try (Indent indent = debug.logAndIndent("layout methods");){
            int curPos = 0;
            for (Pair entry : this.getOrderedCompilations()) {
                HostedMethod method = (HostedMethod)entry.getLeft();
                CompilationResult compilation = (CompilationResult)entry.getRight();
                method.setCodeAddressOffset(curPos);
                curPos = WebImageWasmCodeCache.computeNextMethodStart(curPos, compilation.getTargetCodeSize());
            }
            this.setCodeAreaSize(curPos);
        }
    }

    protected void buildRuntimeMetadata(DebugContext debug, SnippetReflectionProvider snippetReflection, CFunctionPointer firstMethod, UnsignedWord codeSize) {
        super.buildRuntimeMetadata(debug, snippetReflection, firstMethod, codeSize);
        int maxIP = this.codeInfoMap.keySet().stream().max(Integer::compareTo).orElse(-1);
        WasmCodeInfoQueryResult[] codeInfos = new WasmCodeInfoQueryResult[maxIP + 1];
        this.codeInfoMap.forEach((ip, info) -> {
            codeInfos[ip.intValue()] = info;
        });
        WasmCodeInfoHolder.setCodeInfos(codeInfos);
    }

    @Override
    protected boolean verifyMethods(DebugContext debug, HostedUniverse hUniverse, CodeInfoEncoder codeInfoEncoder, CodeInfo codeInfo, FrameInfoDecoder.ConstantAccess constantAccess) {
        return true;
    }

    @Override
    protected void encodeMethod(CodeInfoEncoder codeInfoEncoder, Pair<HostedMethod, CompilationResult> pair) {
        HostedMethod method = (HostedMethod)pair.getLeft();
        WebImageWasmCompilationResult compilation = (WebImageWasmCompilationResult)((Object)pair.getRight());
        int compilationOffset = method.getCodeAddressOffset();
        EconomicSet infopointOffsets = EconomicSet.create();
        FrameData data = new FrameData(compilation.getTotalFrameSize(), method.format("%H.%n(%P)%R"));
        WasmCodeInfoQueryResult queryResult = new WasmCodeInfoQueryResult(data, compilation.getLiveSlots().stream().mapToInt(s -> s.getOffset(compilation.getTotalFrameSize())).toArray());
        this.codeInfoMap.put(compilationOffset, queryResult);
        for (Infopoint infopoint : compilation.getInfopoints()) {
            if (!(infopoint instanceof Call)) continue;
            Call call = (Call)infopoint;
            int offset = call.pcOffset + call.size;
            boolean added = infopointOffsets.add((Object)offset);
            if (!added) {
                throw VMError.shouldNotReachHere((String)("Encoding two infopoints at same offset. Conflicting infopoint: " + String.valueOf(infopoint)));
            }
            int ip = compilationOffset + offset;
            this.codeInfoMap.put(ip, queryResult);
        }
    }

    private static int computeNextMethodStart(int current, int addend) {
        try {
            return Math.addExact(current, addend);
        }
        catch (ArithmeticException e) {
            throw VMError.shouldNotReachHere((String)"Code size is larger than 2GB");
        }
    }
}

