/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.hosted.webimage.wasm.nodes.WasmPrintNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmTrapNode;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionIntrinsics;
import com.oracle.svm.webimage.print.WebImagePrintingProvider;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public class WasmLogHandler
implements LogHandler {
    public void log(CCharPointer bytes, UnsignedWord length) {
        WasmPrintNode.print(WasmLogHandler.getOutputFile().num, 1, (PointerBase)bytes, length);
    }

    public void flush() {
        WebImagePrintingProvider.singleton().flush(WasmLogHandler.getOutputFile());
    }

    public void fatalError() {
        JSFunctionIntrinsics.setExitCode(99);
        WasmTrapNode.trap();
    }

    private static WebImagePrintingProvider.Descriptor getOutputFile() {
        return WebImagePrintingProvider.Descriptor.ERR;
    }
}

