/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmAllocation;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredImageSingleton(value={UnmanagedMemorySupport.class})
@Platforms(value={WebImageWasmLMPlatform.class})
public class WasmLMUnmanagedMemorySupport
implements UnmanagedMemorySupport {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T malloc(UnsignedWord size) {
        return (T)WasmAllocation.doMalloc(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T calloc(UnsignedWord size) {
        T ptr = this.malloc(size);
        if (ptr.isNonNull()) {
            UnmanagedMemoryUtil.fill((Pointer)((Pointer)ptr), (UnsignedWord)size, (byte)0);
        }
        return ptr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T realloc(T ptr, UnsignedWord size) {
        return (T)WasmAllocation.doRealloc((Pointer)ptr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void free(PointerBase ptr) {
        WasmAllocation.doFree((Pointer)ptr);
    }
}

