/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.hosted.webimage.wasm.gc.WasmAllocation;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import com.oracle.svm.webimage.wasmgc.annotation.WasmExport;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.word.Pointer;

@Platforms(value={WebImageWasmLMPlatform.class})
public class WasmLMStringSupport {
    @WasmExport(value="string.prepare")
    private static CShortPointer prepare(int numChars) {
        assert (numChars >= 0);
        return (CShortPointer)WasmAllocation.malloc(Word.unsigned((int)(2 * numChars)));
    }

    @WasmExport(value="string.finish")
    private static String finish(int numChars, CShortPointer charPointer) {
        char[] chars = new char[numChars];
        for (int i = 0; i < numChars; ++i) {
            chars[i] = (char)charPointer.read(i);
        }
        WasmAllocation.free((Pointer)charPointer);
        return new String(chars);
    }
}

