/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.hosted.webimage.JSGraphBuilderPlugins;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemoryCopyNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemoryFillNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmPopcntNode;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.CopySignNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.MaxNode;
import jdk.graal.compiler.nodes.calc.MinNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.RoundNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.IndexAddressNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.BigIntegerSnippets;
import jdk.graal.compiler.replacements.SnippetSubstitutionInvocationPlugin;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.StringUTF16Snippets;
import jdk.graal.compiler.replacements.TargetGraphBuilderPlugins;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.graal.compiler.word.WordCastNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class WasmLMGraphBuilderPlugins
implements TargetGraphBuilderPlugins {
    public void registerPlugins(GraphBuilderConfiguration.Plugins plugins, OptionValues options) {
        InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
        invocationPlugins.defer(() -> {
            WasmLMGraphBuilderPlugins.registerStringPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Int);
            WasmLMGraphBuilderPlugins.registerIntegerLongPlugins(invocationPlugins, JavaKind.Long);
            WasmLMGraphBuilderPlugins.registerCharacterPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerShortPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerMathPlugins(Math.class, invocationPlugins);
            WasmLMGraphBuilderPlugins.registerMathPlugins(StrictMath.class, invocationPlugins);
            WasmLMGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerArraysPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.unregisterArrayFillPlugins(invocationPlugins);
            WasmLMGraphBuilderPlugins.registerMemoryPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerThreadPlugins(invocationPlugins);
            JSGraphBuilderPlugins.registerCurrentIsolatePlugins(invocationPlugins);
        });
    }

    private static void registerStringPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, String.class).setAllowOverwrite(true);
        WasmLMGraphBuilderPlugins.unregisterEquals(r, new Type[]{InvocationPlugin.Receiver.class, Object.class});
        InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, StringUTF16Snippets.class);
        utf16r.register(new InvocationPlugin("getChar", new Type[]{byte[].class, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.addPush(JavaKind.Char, (ValueNode)new JavaReadNode(JavaKind.Char, (AddressNode)new IndexAddressNode(arg1, (ValueNode)new LeftShiftNode(arg2, (ValueNode)ConstantNode.forInt((int)1)), JavaKind.Byte), NamedLocationIdentity.getArrayLocation((JavaKind)JavaKind.Byte), BarrierType.NONE, MemoryOrderMode.PLAIN, false));
                return true;
            }
        });
    }

    public static void registerMathPlugins(Class<?> mathImpl, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, mathImpl).setAllowOverwrite(true);
        WasmLMGraphBuilderPlugins.registerUnaryMath(r, "log", UnaryMathIntrinsicNode.UnaryOperation.LOG);
        WasmLMGraphBuilderPlugins.registerUnaryMath(r, "log10", UnaryMathIntrinsicNode.UnaryOperation.LOG10);
        WasmLMGraphBuilderPlugins.registerUnaryMath(r, "exp", UnaryMathIntrinsicNode.UnaryOperation.EXP);
        WasmLMGraphBuilderPlugins.registerBinaryMath(r, "pow", BinaryMathIntrinsicNode.BinaryOperation.POW);
        WasmLMGraphBuilderPlugins.registerUnaryMath(r, "sin", UnaryMathIntrinsicNode.UnaryOperation.SIN);
        WasmLMGraphBuilderPlugins.registerUnaryMath(r, "cos", UnaryMathIntrinsicNode.UnaryOperation.COS);
        WasmLMGraphBuilderPlugins.registerUnaryMath(r, "tan", UnaryMathIntrinsicNode.UnaryOperation.TAN);
        WasmLMGraphBuilderPlugins.registerMinMax(r);
        r.register(new InvocationPlugin("copySign", new Type[]{Float.TYPE, Float.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode magnitude, ValueNode sign) {
                b.addPush(JavaKind.Float, (ValueNode)new CopySignNode(magnitude, sign));
                return true;
            }
        });
        r.register(new InvocationPlugin("copySign", new Type[]{Double.TYPE, Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode magnitude, ValueNode sign) {
                b.addPush(JavaKind.Double, (ValueNode)new CopySignNode(magnitude, sign));
                return true;
            }
        });
        r.register(new InvocationPlugin("rint", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)RoundNode.create((ValueNode)arg, (ArithmeticLIRGeneratorTool.RoundingMode)ArithmeticLIRGeneratorTool.RoundingMode.NEAREST)));
                return true;
            }
        });
        r.register(new InvocationPlugin("ceil", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)RoundNode.create((ValueNode)arg, (ArithmeticLIRGeneratorTool.RoundingMode)ArithmeticLIRGeneratorTool.RoundingMode.UP)));
                return true;
            }
        });
        r.register(new InvocationPlugin("floor", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)RoundNode.create((ValueNode)arg, (ArithmeticLIRGeneratorTool.RoundingMode)ArithmeticLIRGeneratorTool.RoundingMode.DOWN)));
                return true;
            }
        });
        r.register(new InvocationPlugin("signum", new Type[]{Float.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode f) {
                return false;
            }
        });
        r.register(new InvocationPlugin("signum", new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode d) {
                return false;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
        r.register(new InvocationPlugin("abs", new Type[]{Long.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
        r.register(new InvocationPlugin("multiplyHigh", new Type[]{Long.TYPE, Long.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                return false;
            }
        });
        r.register(new InvocationPlugin("unsignedMultiplyHigh", new Type[]{Long.TYPE, Long.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                return false;
            }
        });
    }

    private static void registerUnaryMath(InvocationPlugins.Registration r, String name, final UnaryMathIntrinsicNode.UnaryOperation operation) {
        r.register(new InvocationPlugin(name, new Type[]{Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)UnaryMathIntrinsicNode.create((ValueNode)value, (UnaryMathIntrinsicNode.UnaryOperation)operation)));
                return true;
            }
        });
    }

    private static void registerBinaryMath(InvocationPlugins.Registration r, String name, final BinaryMathIntrinsicNode.BinaryOperation operation) {
        r.register(new InvocationPlugin(name, new Type[]{Double.TYPE, Double.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                b.push(JavaKind.Double, (ValueNode)b.append((Node)BinaryMathIntrinsicNode.create((ValueNode)x, (ValueNode)y, (BinaryMathIntrinsicNode.BinaryOperation)operation)));
                return true;
            }
        });
    }

    private static void registerMinMax(InvocationPlugins.Registration r) {
        JavaKind[] supportedKinds;
        for (final JavaKind kind : supportedKinds = new JavaKind[]{JavaKind.Float, JavaKind.Double}) {
            r.register(new InvocationPlugin("max", new Type[]{kind.toJavaClass(), kind.toJavaClass()}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(kind, (ValueNode)b.append((Node)MaxNode.create((ValueNode)x, (ValueNode)y, (NodeView)NodeView.DEFAULT)));
                    return true;
                }
            });
            r.register(new InvocationPlugin("min", new Type[]{kind.toJavaClass(), kind.toJavaClass()}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.push(kind, (ValueNode)b.append((Node)MinNode.create((ValueNode)x, (ValueNode)y, (NodeView)NodeView.DEFAULT)));
                    return true;
                }
            });
        }
    }

    public static void registerIntegerLongPlugins(InvocationPlugins plugins, JavaKind kind) {
        Class declaringClass = kind.toBoxedJavaClass();
        Class type = kind.toJavaClass();
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)declaringClass).setAllowOverwrite(true);
        r.register(new InvocationPlugin("bitCount", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                ValueNode popcnt = (ValueNode)b.add((Node)((ValueNode)new WasmPopcntNode(value).canonical(null)));
                if (popcnt.getStackKind() == JavaKind.Long) {
                    b.addPush(JavaKind.Int, (ValueNode)((NarrowNode)b.add((Node)new NarrowNode(popcnt, 64, 32))));
                } else {
                    b.addPush(JavaKind.Int, popcnt);
                }
                return true;
            }
        });
        r.register(new InvocationPlugin("reverseBytes", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
        r.register(new InvocationPlugin("reverse", new Type[]{type}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                return false;
            }
        });
    }

    public static void registerCharacterPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Character.class).setAllowOverwrite(true);
        r.register(new InvocationPlugin("reverseBytes", new Type[]{Character.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
    }

    public static void registerShortPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Short.class).setAllowOverwrite(true);
        r.register(new InvocationPlugin("reverseBytes", new Type[]{Short.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                return false;
            }
        });
    }

    public static void registerArraysPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Arrays.class).setAllowOverwrite(true);
        WasmLMGraphBuilderPlugins.unregisterEquals(r, new Type[]{boolean[].class, boolean[].class});
        WasmLMGraphBuilderPlugins.unregisterEquals(r, new Type[]{byte[].class, byte[].class});
        WasmLMGraphBuilderPlugins.unregisterEquals(r, new Type[]{short[].class, short[].class});
        WasmLMGraphBuilderPlugins.unregisterEquals(r, new Type[]{char[].class, char[].class});
        WasmLMGraphBuilderPlugins.unregisterEquals(r, new Type[]{int[].class, int[].class});
        WasmLMGraphBuilderPlugins.unregisterEquals(r, new Type[]{long[].class, long[].class});
    }

    private static void unregisterEquals(InvocationPlugins.Registration r, Type ... argumentTypes) {
        r.register(new InvocationPlugin("equals", argumentTypes){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1) {
                return false;
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                return false;
            }
        });
    }

    public static void unregisterArrayFillPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Arrays.class).setAllowOverwrite(true);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Boolean.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Byte.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Character.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Short.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Integer.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Float.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Long.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Double.TYPE);
        WasmLMGraphBuilderPlugins.unregisterArrayFill(r, Object.class);
    }

    private static void unregisterArrayFill(InvocationPlugins.Registration r, Class<?> componentType) {
        r.register(new InvocationPlugin("fill", new Type[]{componentType.arrayType(), componentType}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode value) {
                return false;
            }
        });
        r.register(new InvocationPlugin("fill", new Type[]{componentType.arrayType(), Integer.TYPE, Integer.TYPE, componentType}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode toIndex, ValueNode value) {
                return false;
            }
        });
    }

    public static void registerBigIntegerPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, BigInteger.class).setAllowOverwrite(true);
        r.register((InvocationPlugin)new SnippetSubstitutionInvocationPlugin<BigIntegerSnippets.Templates>(BigIntegerSnippets.Templates.class, "implMultiplyToLen", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class}){

            public SnippetTemplate.SnippetInfo getSnippet(BigIntegerSnippets.Templates templates) {
                return null;
            }

            public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode[] args) {
                return false;
            }
        });
    }

    private static void registerMemoryPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration unmanagedMemUtil = new InvocationPlugins.Registration(plugins, UnmanagedMemoryUtil.class);
        InvocationPlugins.Registration javaMemUtil = new InvocationPlugins.Registration(plugins, JavaMemoryUtil.class);
        WasmLMGraphBuilderPlugins.registerFillPlugins(unmanagedMemUtil, javaMemUtil);
        WasmLMGraphBuilderPlugins.registerRawCopyPlugins(unmanagedMemUtil, javaMemUtil);
    }

    private static void registerFillPlugins(InvocationPlugins.Registration unmanagedMemUtil, InvocationPlugins.Registration javaMemUtil) {
        unmanagedMemUtil.register((InvocationPlugin)new FillPlugin("fill"));
        javaMemUtil.register((InvocationPlugin)new FillPlugin("fill"));
    }

    private static void registerRawCopyPlugins(InvocationPlugins.Registration unmanagedMemUtil, InvocationPlugins.Registration javaMemUtil) {
        unmanagedMemUtil.register((InvocationPlugin)new CopyPlugin("copy"));
        unmanagedMemUtil.register((InvocationPlugin)new CopyPlugin("copyForward"));
        unmanagedMemUtil.register((InvocationPlugin)new CopyPlugin("copyBackward"));
        unmanagedMemUtil.register((InvocationPlugin)new CopyPlugin("copyWordsForward"));
        unmanagedMemUtil.register((InvocationPlugin)new CopyPlugin("copyLongsForward"));
        unmanagedMemUtil.register((InvocationPlugin)new CopyPlugin("copyLongsBackward"));
        javaMemUtil.register((InvocationPlugin)new CopyPlugin("copyForward"));
        javaMemUtil.register((InvocationPlugin)new CopyPlugin("copyBackward"));
        javaMemUtil.register((InvocationPlugin)new CopyOffsetPlugin("copy"));
        javaMemUtil.register((InvocationPlugin)new CopyOffsetPlugin("copyForward"));
        javaMemUtil.register((InvocationPlugin)new CopyOffsetPlugin("copyBackward"));
    }

    private static class FillPlugin
    extends InvocationPlugin.RequiredInvocationPlugin {
        FillPlugin(String name) {
            super(name, new Type[]{Pointer.class, UnsignedWord.class, Byte.TYPE});
        }

        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode to, ValueNode size, ValueNode value) {
            b.add((Node)new WasmMemoryFillNode(NarrowNode.create((ValueNode)to, (int)32, (NodeView)NodeView.DEFAULT), value, NarrowNode.create((ValueNode)size, (int)32, (NodeView)NodeView.DEFAULT)));
            return true;
        }
    }

    private static class CopyPlugin
    extends InvocationPlugin.RequiredInvocationPlugin {
        CopyPlugin(String name) {
            super(name, new Type[]{Pointer.class, Pointer.class, UnsignedWord.class});
        }

        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode from, ValueNode to, ValueNode size) {
            b.add((Node)new WasmMemoryCopyNode(NarrowNode.create((ValueNode)to, (int)32, (NodeView)NodeView.DEFAULT), NarrowNode.create((ValueNode)from, (int)32, (NodeView)NodeView.DEFAULT), NarrowNode.create((ValueNode)size, (int)32, (NodeView)NodeView.DEFAULT)));
            return true;
        }
    }

    private static class CopyOffsetPlugin
    extends InvocationPlugin.RequiredInvocationPlugin {
        private final CopyPlugin copyPlugin;

        CopyOffsetPlugin(String name) {
            super(name, new Type[]{Object.class, UnsignedWord.class, Object.class, UnsignedWord.class, UnsignedWord.class});
            this.copyPlugin = new CopyPlugin(name);
        }

        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode from, ValueNode fromOffset, ValueNode to, ValueNode toOffset, ValueNode size) {
            WordCastNode fromUntracked = (WordCastNode)b.add((Node)WordCastNode.objectToUntrackedPointer((ValueNode)from, (JavaKind)ConfigurationValues.getWordKind()));
            WordCastNode toUntracked = (WordCastNode)b.add((Node)WordCastNode.objectToUntrackedPointer((ValueNode)to, (JavaKind)ConfigurationValues.getWordKind()));
            ValueNode fromPointer = (ValueNode)b.add((Node)BinaryArithmeticNode.add((ValueNode)fromUntracked, (ValueNode)fromOffset));
            ValueNode toPointer = (ValueNode)b.add((Node)BinaryArithmeticNode.add((ValueNode)toUntracked, (ValueNode)toOffset));
            return this.copyPlugin.apply(b, targetMethod, receiver, fromPointer, toPointer, size);
        }
    }
}

