/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm;

import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.functionintrinsics.JSSystemFunction;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;

public class WasmJSCounterparts {
    public static final String JSFUNCTION_MODULE_NAME = "interop";
    public static final String JSBODY_MODULE_NAME = "jsbody";
    private final ConcurrentMap<JSSystemFunction, WasmId.FunctionImport> jsFunctions = new ConcurrentHashMap<JSSystemFunction, WasmId.FunctionImport>();
    private final ConcurrentMap<JSBody.JSCode, WasmId.FunctionImport> jsBodies = new ConcurrentHashMap<JSBody.JSCode, WasmId.FunctionImport>();

    public List<JSSystemFunction> getFunctions() {
        return this.jsFunctions.keySet().stream().toList();
    }

    public Map<JSBody.JSCode, WasmId.FunctionImport> getJsBodyFunctions() {
        return Collections.unmodifiableMap(this.jsBodies);
    }

    public WasmId.Func idForJSFunction(WebImageWasmProviders wasmProviders, JSSystemFunction function) {
        return this.jsFunctions.computeIfAbsent(function, fun -> wasmProviders.idFactory().forFunctionImport(WasmJSCounterparts.createImport(wasmProviders.util(), fun)));
    }

    public WasmId.Func idForJSBody(WebImageWasmProviders wasmProviders, JSBody jsBody) {
        return this.jsBodies.computeIfAbsent(jsBody.getJsCode(), code -> wasmProviders.idFactory().forFunctionImport(WasmJSCounterparts.createImportForJSBody(wasmProviders.util(), jsBody)));
    }

    private static WasmValType getArgumentType(JavaKind argumentKind, WasmUtil util) {
        return argumentKind == JavaKind.Object ? WasmRefType.EXTERNREF : util.mapType(argumentKind);
    }

    private static WasmValType getReturnType(Stamp returnStamp, WasmUtil util) {
        if (Platform.includedIn(WebImageWasmGCPlatform.class) && returnStamp.isObjectStamp()) {
            return WasmRefType.EXTERNREF;
        }
        return util.typeForStamp(returnStamp);
    }

    private static ImportDescriptor.Function createImport(WasmUtil util, JSSystemFunction function) {
        WasmValType[] argTypes = (WasmValType[])Arrays.stream(function.getArgKinds()).map(kind -> WasmJSCounterparts.getArgumentType(kind, util)).toArray(WasmValType[]::new);
        WasmValType returnType = WasmJSCounterparts.getReturnType(function.stamp(), util);
        TypeUse typeUse = TypeUse.withOptionalResult(returnType, argTypes);
        return new ImportDescriptor.Function(JSFUNCTION_MODULE_NAME, function.getFunctionName(), typeUse, function.toString());
    }

    private static ImportDescriptor.Function createImportForJSBody(WasmUtil util, JSBody jsBody) {
        JSBody.JSCode jsCode = jsBody.getJsCode();
        ResolvedJavaMethod method = jsBody.getMethod();
        WebImageNamingConvention namingConvention = WebImageNamingConvention.getInstance();
        WasmValType[] argTypes = (WasmValType[])jsBody.getArguments().stream().map(argNode -> {
            JavaKind kind = util.kindForNode((ValueNode)argNode);
            return WasmJSCounterparts.getArgumentType(kind, util);
        }).toArray(WasmValType[]::new);
        WasmValType returnType = WasmJSCounterparts.getReturnType(jsBody.asNode().stamp(NodeView.DEFAULT), util);
        TypeUse typeUse = TypeUse.withOptionalResult(returnType, argTypes);
        StringBuilder comment = new StringBuilder("User-provided JS code in ");
        comment.append(method.format("%H.%n(%P)%R")).append(": function(");
        for (int i = 0; i < jsCode.getArgs().length; ++i) {
            if (i != 0) {
                comment.append(", ");
            }
            comment.append(jsCode.getArgs()[i]);
        }
        comment.append(") { ").append(jsCode.getBody()).append(" }");
        return new ImportDescriptor.Function(JSBODY_MODULE_NAME, namingConvention.identForType(method.getDeclaringClass()) + "." + namingConvention.identForMethod(method), typeUse, comment.toString());
    }
}

