/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.util.metrics;

import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.debug.MetricKey;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class MetricsUtil {
    public static List<MetricKey> getClassMetricKeys(Class<?> clazz) {
        ArrayList<MetricKey> metricKeys;
        block3: {
            Field[] fields = clazz.getFields();
            metricKeys = new ArrayList<MetricKey>(fields.length);
            try {
                for (Field f : fields) {
                    if (!Modifier.isStatic(f.getModifiers()) || !(f.get(null) instanceof MetricKey)) continue;
                    metricKeys.add((MetricKey)f.get(null));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Unexpected non-static field in a *MetricKeys class");
            }
        }
        return metricKeys;
    }

    public static void propagateMetricsExcept(LoggerScope parent, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics, Collection<MetricKey> ignoredMetricKeys) {
        StreamSupport.stream(metrics.getKeys().spliterator(), false).filter(key -> !ignoredMetricKeys.contains(key)).forEach(key -> parent.counter((MetricKey)key).add(MetricsUtil.getOrDefault(metrics, key)));
    }

    public static void propagateMetricsExcept(LoggerScope parent, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics, Class<?> clazz) {
        MetricsUtil.propagateMetricsExcept(parent, metrics, MetricsUtil.getClassMetricKeys(clazz));
    }

    public static void propagateMetrics(LoggerScope parent, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
        MetricsUtil.propagateMetricsExcept(parent, metrics, Collections.emptyList());
    }

    public static long getOrDefault(UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics, MetricKey metric) {
        return metrics.containsKey((Object)metric) ? ((LoggableMetric)metrics.get((Object)metric)).get() : 0L;
    }

    public static void forceMetricExistence(LoggerScope scope, MetricKey ... metricKeys) {
        Arrays.stream(metricKeys).forEach(scope::counter);
    }

    public static void forceMetricExistence(LoggerScope scope, Class<?> clazz) {
        MetricsUtil.forceMetricExistence(scope, MetricsUtil.getClassMetricKeys(clazz).toArray(new MetricKey[0]));
    }
}

