/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.util.metrics;

import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.MethodMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.StackifierMetricKeys;
import com.oracle.svm.hosted.webimage.util.metrics.CodeSizeCollector;
import com.oracle.svm.hosted.webimage.util.metrics.MetricsUtil;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.MetricKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class MethodMetricsCollector {
    private final JSCodeBuffer codeBuffer;
    private final EconomicMap<HostedMethod, ReconstructionType> methodReconstructionMap;
    private final EconomicMap<HostedMethod, UnmodifiableEconomicMap<MetricKey, Number>> methodMetrics;

    public MethodMetricsCollector(JSCodeBuffer codeBuffer) {
        this.codeBuffer = codeBuffer;
        this.methodReconstructionMap = EconomicMap.create();
        this.methodMetrics = EconomicMap.create();
    }

    public Collector collect(HostedMethod m) {
        return new Collector(m);
    }

    public ReconstructionType getMethodReconstructionType(HostedMethod method) {
        return (ReconstructionType)((Object)this.methodReconstructionMap.get((Object)method));
    }

    public Number getMethodMetric(HostedMethod method, MetricKey key) {
        return (Number)((UnmodifiableEconomicMap)this.methodMetrics.get((Object)method)).get((Object)key);
    }

    private static void stackifierMetricAccumulation(LoggerScope parent, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
        MethodMetricsCollector.addOrDefault(parent, metrics, StackifierMetricKeys.NUM_ELSE_SCOPES);
        MethodMetricsCollector.addOrDefault(parent, metrics, StackifierMetricKeys.NUM_THEN_SCOPES);
        MethodMetricsCollector.addOrDefault(parent, metrics, StackifierMetricKeys.NUM_FORWARD_BLOCKS);
        MethodMetricsCollector.addOrDefault(parent, metrics, StackifierMetricKeys.NUM_LOOP_SCOPES);
    }

    private static void addOrDefault(LoggerScope parent, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics, MetricKey key) {
        parent.counter(key).add(MetricsUtil.getOrDefault(metrics, key));
    }

    public class Collector
    implements AutoCloseable {
        private final HostedMethod method;
        private final LoggerScope loggerScope;
        private final CodeSizeCollector codeSizeCollector;

        protected Collector(HostedMethod method) {
            this.method = method;
            this.loggerScope = LoggerContext.currentContext().scope(method, this::onCloseHandler);
            this.codeSizeCollector = new CodeSizeCollector(MethodMetricKeys.METHOD_SIZE, () -> ((JSCodeBuffer)MethodMetricsCollector.this.codeBuffer).codeSize());
        }

        private void setMethodReconstructionType() {
            if (LoggerContext.counter(MethodMetricKeys.NUM_SPLITS).get() > 0L) {
                MethodMetricsCollector.this.methodReconstructionMap.put((Object)this.method, (Object)ReconstructionType.RECONSTRUCTED);
            } else {
                MethodMetricsCollector.this.methodReconstructionMap.put((Object)this.method, (Object)ReconstructionType.NO_CONTROL_FLOW);
            }
        }

        private void onCloseHandler(LoggerScope scope, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
            MetricKey sizeAccumulator;
            LoggerScope parent = scope.parent();
            MethodMetricsCollector.this.methodMetrics.put((Object)this.method, scope.getExtractedMetrics());
            MethodMetricsCollector.addOrDefault(parent, metrics, MethodMetricKeys.NUM_BLOCKS);
            MethodMetricsCollector.addOrDefault(parent, metrics, MethodMetricKeys.NUM_COMPOUND_COND_XOOY);
            MethodMetricsCollector.addOrDefault(parent, metrics, MethodMetricKeys.NUM_COMPOUND_COND_XAAY);
            MetricsUtil.forceMetricExistence(parent, MethodMetricKeys.NUM_RECONSTRUCTED, MethodMetricKeys.NUM_NO_CF);
            ReconstructionType reconstructionType = (ReconstructionType)((Object)MethodMetricsCollector.this.methodReconstructionMap.get((Object)this.method));
            MetricKey counter = switch (reconstructionType.ordinal()) {
                case 0 -> {
                    sizeAccumulator = ImageBreakdownMetricKeys.RECONSTRUCTED_SIZE;
                    yield MethodMetricKeys.NUM_RECONSTRUCTED;
                }
                case 1 -> {
                    sizeAccumulator = ImageBreakdownMetricKeys.NO_CF_SIZE;
                    yield MethodMetricKeys.NUM_NO_CF;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)((Object)reconstructionType));
            };
            long methodSize = ((LoggableMetric)metrics.get((Object)MethodMetricKeys.METHOD_SIZE)).get();
            parent.counter(ImageBreakdownMetricKeys.TOTAL_METHOD_SIZE).add(methodSize);
            parent.counter(sizeAccumulator).add(methodSize);
            parent.counter(counter).increment();
            MethodMetricsCollector.stackifierMetricAccumulation(parent, metrics);
            MetricsUtil.propagateMetricsExcept(parent, metrics, MethodMetricKeys.class);
        }

        @Override
        public void close() {
            this.codeSizeCollector.close();
            this.setMethodReconstructionType();
            this.loggerScope.close();
        }
    }

    public static enum ReconstructionType {
        RECONSTRUCTED,
        NO_CONTROL_FLOW;

    }
}

