/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.util.metrics;

import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.util.metrics.MethodMetricsCollector;
import com.oracle.svm.hosted.webimage.util.metrics.MetricsUtil;
import com.oracle.svm.webimage.Labeler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.LongSupplier;
import jdk.graal.compiler.debug.MetricKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;

public abstract class ImageMetricsCollector
implements AutoCloseable {
    public static final MetricKey[] SAVED_SIZE_BREAKDOWN_KEYS = new MetricKey[]{ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE, ImageBreakdownMetricKeys.EXTRA_DEFINITIONS_SIZE, ImageBreakdownMetricKeys.STATIC_FIELDS_SIZE, ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE, ImageBreakdownMetricKeys.TOTAL_METHOD_SIZE, ImageBreakdownMetricKeys.RECONSTRUCTED_SIZE, ImageBreakdownMetricKeys.NO_CF_SIZE, ImageBreakdownMetricKeys.CONSTANTS_SIZE, ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE};
    public static final String PRE_CLOSURE_SCOPE_NAME = "Pre-Closure";
    public static final String CLOSURE_SCOPE_NAME = "Closure-Compiler";
    protected final LoggerScope scope;
    protected final boolean reportImageSizeBreakdown;
    protected final boolean reportEntireSize;
    protected static final List<Pair<MetricKey, LongSupplier>> additionalBreakdownKeys = new ArrayList<Pair<MetricKey, LongSupplier>>();

    protected ImageMetricsCollector(String scopeName, boolean reportImageSizeBreakdown, boolean reportEntireSize) {
        this.scope = LoggerContext.currentContext().scope(scopeName, this::onCloseHandler);
        this.reportImageSizeBreakdown = reportImageSizeBreakdown;
        this.reportEntireSize = reportEntireSize;
    }

    public static void addAdditionalBreakdownKey(MetricKey key, LongSupplier supplier) {
        additionalBreakdownKeys.add((Pair<MetricKey, LongSupplier>)Pair.create((Object)key, (Object)supplier));
    }

    public static long addAdditionBreakdownKeysToScope() {
        return additionalBreakdownKeys.stream().mapToLong(pair -> {
            long size = ((LongSupplier)pair.getRight()).getAsLong();
            LoggerContext.counter((MetricKey)pair.getLeft()).add(size);
            return size;
        }).sum();
    }

    protected abstract void collectMetrics();

    protected void onCloseHandler(LoggerScope s, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
        LoggerScope parent = s.parent();
        if (this.reportImageSizeBreakdown) {
            MetricsUtil.propagateMetrics(parent, metrics);
        } else {
            HashSet<MetricKey> ignoredKeys = new HashSet<MetricKey>(additionalBreakdownKeys.size());
            ignoredKeys.addAll(additionalBreakdownKeys.stream().map(Pair::getLeft).toList());
            ignoredKeys.addAll(MetricsUtil.getClassMetricKeys(ImageBreakdownMetricKeys.class));
            if (this.reportEntireSize) {
                ignoredKeys.remove(ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE);
            }
            MetricsUtil.propagateMetricsExcept(parent, metrics, ignoredKeys);
        }
    }

    @Override
    public void close() {
        this.collectMetrics();
        this.scope.close();
    }

    public static class PostClosure
    extends ImageMetricsCollector {
        private final Labeler labeler;
        private final JSCodeBuffer codeBuffer;
        private final MethodMetricsCollector methodMetricsCollector;

        public PostClosure(MethodMetricsCollector methodMetricsCollector, Labeler labeler, JSCodeBuffer codeBuffer) {
            super(ImageMetricsCollector.CLOSURE_SCOPE_NAME, (Boolean)WebImageOptions.ReportImageSizeBreakdown.getValue(), true);
            this.labeler = labeler;
            this.codeBuffer = codeBuffer;
            this.methodMetricsCollector = methodMetricsCollector;
        }

        @Override
        protected void onCloseHandler(LoggerScope s, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
            LoggerContext.currentContext().saveCounters(this.scope, SAVED_SIZE_BREAKDOWN_KEYS);
            super.onCloseHandler(s, metrics);
        }

        @Override
        protected void collectMetrics() {
            String jsSource = this.codeBuffer.getCode();
            long additionalSize = PostClosure.addAdditionBreakdownKeysToScope();
            MetricKey[] injectedKeys = new MetricKey[]{ImageBreakdownMetricKeys.CONSTANT_INITS_SIZE, ImageBreakdownMetricKeys.CONSTANT_DEFS_SIZE, ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE, ImageBreakdownMetricKeys.STATIC_FIELDS_SIZE, ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE, ImageBreakdownMetricKeys.EXTRA_DEFINITIONS_SIZE};
            EconomicMap metricMap = EconomicMap.create((int)injectedKeys.length);
            for (MetricKey key2 : injectedKeys) {
                assert (!metricMap.containsKey((Object)key2.getName())) : "Duplicate key = " + key2.getName();
                metricMap.put((Object)key2.getName(), (Object)key2);
            }
            MetricsUtil.forceMetricExistence(LoggerContext.currentContext().currentScope(), ImageBreakdownMetricKeys.RECONSTRUCTED_SIZE, ImageBreakdownMetricKeys.NO_CF_SIZE);
            long imageLabelsSize = this.labeler.getSizeBetweenMetricLabels(jsSource, (key, size) -> {
                if (key instanceof String) {
                    String label = (String)key;
                    MetricKey metricKey = (MetricKey)metricMap.get((Object)label);
                    if (metricKey != null) {
                        LoggerContext.counter(metricKey).add(size);
                    }
                } else if (key instanceof HostedMethod) {
                    HostedMethod m = (HostedMethod)key;
                    MetricKey metricKey = switch (this.methodMetricsCollector.getMethodReconstructionType(m)) {
                        default -> throw new MatchException(null, null);
                        case MethodMetricsCollector.ReconstructionType.RECONSTRUCTED -> ImageBreakdownMetricKeys.RECONSTRUCTED_SIZE;
                        case MethodMetricsCollector.ReconstructionType.NO_CONTROL_FLOW -> ImageBreakdownMetricKeys.NO_CF_SIZE;
                    };
                    LoggerContext.counter(ImageBreakdownMetricKeys.TOTAL_METHOD_SIZE).add(size);
                    LoggerContext.counter(metricKey).add(size);
                }
            });
            long totalConstantInitSize = LoggerContext.counter(ImageBreakdownMetricKeys.CONSTANT_INITS_SIZE).get();
            long constantDefSize = LoggerContext.counter(ImageBreakdownMetricKeys.CONSTANT_DEFS_SIZE).get();
            long methodSize = LoggerContext.counter(ImageBreakdownMetricKeys.TOTAL_METHOD_SIZE).get();
            long jsFileSize = (long)jsSource.length() - imageLabelsSize;
            LoggerContext.counter(ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE).add(-methodSize);
            LoggerContext.counter(ImageBreakdownMetricKeys.CONSTANTS_SIZE).add(totalConstantInitSize + constantDefSize);
            LoggerContext.counter(ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE).add(jsFileSize + additionalSize);
            LoggerContext.counter(ImageBreakdownMetricKeys.JS_IMAGE_SIZE).add(jsFileSize);
        }
    }

    public static class PreClosure
    extends ImageMetricsCollector {
        private final JSCodeBuffer codeBuffer;

        public PreClosure(JSCodeBuffer codeBuffer) {
            super(ImageMetricsCollector.PRE_CLOSURE_SCOPE_NAME, (Boolean)WebImageOptions.ReportImageSizeBreakdown.getValue() != false && (Boolean)WebImageOptions.ClosureCompiler.getValue() == false, (Boolean)WebImageOptions.ClosureCompiler.getValue() == false);
            this.codeBuffer = codeBuffer;
        }

        @Override
        protected void onCloseHandler(LoggerScope s, UnmodifiableEconomicMap<MetricKey, LoggableMetric> metrics) {
            LoggerContext.currentContext().saveCounters(this.scope, SAVED_SIZE_BREAKDOWN_KEYS);
            super.onCloseHandler(s, metrics);
        }

        @Override
        protected void collectMetrics() {
            long additionalSize = PreClosure.addAdditionBreakdownKeysToScope();
            int codeSize = this.codeBuffer.codeSize();
            LoggerContext.counter(ImageBreakdownMetricKeys.CONSTANTS_SIZE).add(LoggerContext.counter(ImageBreakdownMetricKeys.CONSTANT_INITS_SIZE).get() + LoggerContext.counter(ImageBreakdownMetricKeys.CONSTANT_DEFS_SIZE).get());
            LoggerContext.counter(ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE).add((long)codeSize + additionalSize);
            LoggerContext.counter(ImageBreakdownMetricKeys.JS_IMAGE_SIZE).add(codeSize);
        }
    }
}

