/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.util.metrics;

import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.MetricKey;

public class CodeSizeCollector
implements AutoCloseable {
    private final Supplier<Integer> codeSizeSupplier;
    private final int startSize;
    private final Consumer<Integer> diffHandler;

    public CodeSizeCollector(Supplier<Integer> codeSizeSupplier, Consumer<Integer> diffHandler) {
        this.codeSizeSupplier = codeSizeSupplier;
        this.startSize = codeSizeSupplier.get();
        this.diffHandler = diffHandler;
    }

    public CodeSizeCollector(MetricKey key, Supplier<Integer> codeSizeSupplier) {
        this(codeSizeSupplier, (Integer diff) -> LoggerContext.counter(key).add(diff.intValue()));
    }

    public static CodeSizeCollector trackObjectSize(Supplier<Integer> codeSizeSupplier) {
        return new CodeSizeCollector(codeSizeSupplier, CodeSizeCollector::incrementConstantSizeClass);
    }

    public static void incrementConstantSizeClass(Integer diff) {
        if (diff == 0) {
            return;
        }
        int sizeClass = 32 - Integer.numberOfLeadingZeros(diff - 1);
        if (sizeClass < ImageBreakdownMetricKeys.CONSTANT_SIZE_CLASSES.size()) {
            LoggerContext.counter(ImageBreakdownMetricKeys.CONSTANT_SIZE_CLASSES.get(sizeClass)).add(1L);
        }
    }

    @Override
    public void close() {
        int diff = this.codeSizeSupplier.get() - this.startSize;
        assert (diff >= 0) : "Negative code size";
        this.diffHandler.accept(diff);
    }
}

