/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.util.metrics;

import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import com.oracle.svm.hosted.webimage.metrickeys.BootHeapMetricKeys;
import com.oracle.svm.hosted.webimage.util.metrics.MetricsUtil;
import com.oracle.svm.webimage.object.ObjectInspector;
import com.oracle.svm.webimage.type.TypeControl;
import jdk.graal.compiler.debug.MetricKey;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaKind;

public class BootHeapMetricsCollector {
    private final LoggerScope scope;
    private final TypeControl typeControl;

    public BootHeapMetricsCollector(LoggerScope scope, TypeControl typeControl) {
        this.scope = scope;
        this.typeControl = typeControl;
        MetricsUtil.forceMetricExistence(scope, BootHeapMetricKeys.class);
    }

    private void logConstant(ConstantType constantType, long constantSize) {
        this.scope.counter((MetricKey)BootHeapMetricKeys.JVM_CONSTANTS_SIZE).add(constantSize);
        if (constantType == ConstantType.OBJECT) {
            this.scope.counter((MetricKey)BootHeapMetricKeys.NUM_OBJECTS).increment();
            this.scope.counter((MetricKey)BootHeapMetricKeys.JVM_OBJECTS_SIZE).add(constantSize);
        } else if (constantType == ConstantType.ARRAY) {
            this.scope.counter((MetricKey)BootHeapMetricKeys.NUM_ARRAYS).increment();
            this.scope.counter((MetricKey)BootHeapMetricKeys.JVM_ARRAYS_SIZE).add(constantSize);
        } else if (constantType == ConstantType.PRIMITIVE) {
            this.scope.counter((MetricKey)BootHeapMetricKeys.NUM_PRIMITIVES).increment();
            this.scope.counter((MetricKey)BootHeapMetricKeys.JVM_PRIMITIVES_SIZE).add(constantSize);
        } else if (constantType == ConstantType.STRING) {
            this.scope.counter((MetricKey)BootHeapMetricKeys.NUM_STRINGS).increment();
            this.scope.counter((MetricKey)BootHeapMetricKeys.JVM_STRINGS_SIZE).add(constantSize);
        } else if (constantType == ConstantType.METHOD_POINTER) {
            this.scope.counter((MetricKey)BootHeapMetricKeys.NUM_METHOD_POINTERS).increment();
            this.scope.counter((MetricKey)BootHeapMetricKeys.JVM_METHOD_POINTERS_SIZE).add(constantSize);
        } else assert (false) : "Unrecognized constant type" + constantType.name();
    }

    public void constantObject(HostedInstanceClass constObjectType) {
        this.logConstant(ConstantType.OBJECT, constObjectType.getInstanceSize());
    }

    public void constantArray(ObjectInspector.ArrayType<?> arrayType) {
        HostedType elemType = arrayType.componentType;
        this.logConstant(ConstantType.ARRAY, (long)this.typeControl.getMetaAccess().getArrayIndexScale(elemType.getJavaKind()) * (long)arrayType.length());
    }

    public void constantPrimitive(ObjectInspector.ValueType valueType) {
        this.logConstant(ConstantType.PRIMITIVE, switch (valueType.kind) {
            case JavaKind.Boolean -> 1L;
            case JavaKind.Byte -> 1L;
            case JavaKind.Short -> 2L;
            case JavaKind.Char -> 2L;
            case JavaKind.Int -> 4L;
            case JavaKind.Float -> 4L;
            case JavaKind.Long -> 8L;
            case JavaKind.Double -> 8L;
            default -> throw JVMCIError.shouldNotReachHere((String)valueType.kind.toString());
        });
    }

    public void constantString(ObjectInspector.StringType stringType) {
        this.logConstant(ConstantType.STRING, stringType.getBytes().length);
    }

    public void constantMethodPointer(ObjectInspector.MethodPointerType methodPointerType) {
        String name = this.typeControl.requestMethodName(methodPointerType.getMethod());
        this.logConstant(ConstantType.METHOD_POINTER, name.length());
    }

    private static enum ConstantType {
        OBJECT,
        PRIMITIVE,
        ARRAY,
        STRING,
        METHOD_POINTER;

    }
}

