/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.util;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.hosted.webimage.metrickeys.MethodMetricKeys;
import com.oracle.svm.hosted.webimage.util.metrics.MethodMetricsCollector;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import com.oracle.svm.webimage.object.ObjectInspector;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.collections.Pair;

public class TypeControlGraphPrinter {
    public static void print(WebImageTypeControl tc, MethodMetricsCollector methodMetricsCollector, String reportsPath, String reportName) {
        Collection<HostedType> types = tc.queryEmittedTypes();
        HashMap nodes = new HashMap();
        for (HostedType hostedType : types) {
            Node<?> typeNode = TypeControlGraphPrinter.getOrCreateNode(nodes, hostedType);
            for (Object reason : tc.getReasons(hostedType)) {
                if (!TypeControlGraphPrinter.isValidReason(reason, hostedType)) continue;
                Node<?> node2 = TypeControlGraphPrinter.getOrCreateNode(nodes, reason);
                typeNode.addReason(node2);
            }
        }
        Iterable<ConstantIdentityMapping.IdentityNode> identityNodes = tc.getConstantMap().identityMapping.identityNodes();
        identityNodes.forEach(node -> nodes.put(node.getDefinition(), new ObjectNode((ConstantIdentityMapping.IdentityNode)node)));
        for (ConstantIdentityMapping.IdentityNode identityNode : identityNodes) {
            ObjectInspector.ObjectDefinition odef = identityNode.getDefinition();
            Node node3 = (Node)nodes.get(odef);
            for (Object reason : odef.getReasons()) {
                if (!TypeControlGraphPrinter.isValidReason(reason, null)) continue;
                Node<?> reasonNode = TypeControlGraphPrinter.getOrCreateNode(nodes, reason);
                node3.addReason(reasonNode);
            }
        }
        nodes.values().stream().filter(e -> e instanceof MethodNode).forEach(n -> {
            MethodNode methodNode = (MethodNode)n;
            methodNode.setMethodSize(methodMetricsCollector.getMethodMetric((HostedMethod)methodNode.obj, MethodMetricKeys.METHOD_SIZE).intValue());
        });
        TypeControlGraphPrinter.toCsvFile("TypeNodes", reportsPath, "types", reportName, writer -> TypeControlGraphPrinter.printNodeCsv(writer, TypeNode.getHeaderNames(), nodes.values().stream().filter(e -> e instanceof TypeNode)));
        TypeControlGraphPrinter.toCsvFile("MethodNodes", reportsPath, "methods", reportName, writer -> TypeControlGraphPrinter.printNodeCsv(writer, MethodNode.getHeaderNames(), nodes.values().stream().filter(e -> e instanceof MethodNode)));
        TypeControlGraphPrinter.toCsvFile("ObjectNodes", reportsPath, "objects", reportName, writer -> TypeControlGraphPrinter.printNodeCsv(writer, ObjectNode.getHeaderNames(), nodes.values().stream().filter(e -> e instanceof ObjectNode)));
        Stream<Map<Boolean, List<Pair>>> stream = nodes.values().stream().flatMap(end -> end.getReasons().stream().map(start -> Pair.create((Object)start, (Object)end)));
        Map<Boolean, List<Pair>> rels = stream.collect(Collectors.partitioningBy(pair -> pair.getLeft() instanceof ObjectNode || pair.getRight() instanceof ObjectNode));
        TypeControlGraphPrinter.toCsvFile("Reasons", reportsPath, "rels", reportName, writer -> TypeControlGraphPrinter.printRels(writer, (List)rels.get(false)));
        TypeControlGraphPrinter.toCsvFile("Reasons (Objects)", reportsPath, "object_rels", reportName, writer -> TypeControlGraphPrinter.printRels(writer, (List)rels.get(true)));
    }

    private static void printRels(PrintWriter writer, List<Pair<Node<?>, Node<?>>> rels) {
        TypeControlGraphPrinter.printCsvLine(writer, new String[]{"StartId", "EndId"});
        rels.forEach(p -> TypeControlGraphPrinter.printCsvLine(writer, new String[]{String.valueOf(((Node)p.getLeft()).id), String.valueOf(((Node)p.getRight()).id)}));
    }

    private static void toCsvFile(String description, String reportsPath, String prefix, String reportName, Consumer<PrintWriter> reporter) {
        String name = prefix + "_" + reportName;
        ReportUtils.report((String)description, (String)reportsPath, (String)name, (String)"csv", reporter);
    }

    private static void printNodeCsv(PrintWriter writer, String[] headers, Stream<Node<?>> stream) {
        TypeControlGraphPrinter.printCsvLine(writer, headers);
        stream.forEach(node -> {
            Object[] values = node.getValues();
            assert (headers.length == values.length) : Arrays.toString(headers) + " vs. " + Arrays.toString(values);
            TypeControlGraphPrinter.printCsvLine(writer, (String[])values);
        });
    }

    private static void printCsvLine(PrintWriter writer, String[] values) {
        writer.println(Arrays.stream(values).map(v -> v.replaceAll("[^\\x20-\\x7E]", "?")).collect(Collectors.joining("\t")));
    }

    private static boolean isValidReason(Object reason, HostedType type) {
        if (reason instanceof HostedType) {
            return !reason.equals(type);
        }
        if (reason instanceof HostedMethod) {
            return !((HostedMethod)reason).getDeclaringClass().equals(type);
        }
        return reason instanceof ObjectInspector.ObjectDefinition;
    }

    private static Node<?> getOrCreateNode(Map<Object, Node<?>> map, Object key) {
        Node<?> node = map.get(key);
        if (node == null) {
            node = TypeControlGraphPrinter.createNode(key, map);
            map.put(key, node);
        }
        return node;
    }

    private static Node<?> createNode(Object reason, Map<Object, Node<?>> map) {
        if (reason instanceof HostedType) {
            return new TypeNode((HostedType)reason);
        }
        if (reason instanceof HostedMethod) {
            HostedType m = ((HostedMethod)reason).getDeclaringClass();
            TypeNode typeNode = (TypeNode)TypeControlGraphPrinter.getOrCreateNode(map, m);
            return new MethodNode((HostedMethod)reason, typeNode);
        }
        throw GraalError.shouldNotReachHere((String)String.valueOf(reason));
    }

    static abstract class Node<T> {
        static int ID = 0;
        final int id;
        final T obj;
        private final Set<Node<?>> reasons = new HashSet();

        Node(T obj) {
            this.id = ID++;
            this.obj = obj;
        }

        void addReason(Node<?> t) {
            Objects.requireNonNull(t);
            this.reasons.add(t);
        }

        Set<Node<?>> getReasons() {
            return Collections.unmodifiableSet(this.reasons);
        }

        public abstract String[] getValues();
    }

    static class TypeNode
    extends Node<HostedType> {
        TypeNode(HostedType t) {
            super(t);
        }

        public static String[] getHeaderNames() {
            return new String[]{"Id", "SimpleName", "Name"};
        }

        @Override
        public String[] getValues() {
            Class clazz = ((HostedType)this.obj).getJavaClass();
            return new String[]{String.valueOf(this.id), ClassUtil.getUnqualifiedName((Class)clazz), clazz.getName()};
        }
    }

    static class MethodNode
    extends Node<HostedMethod> {
        public final TypeNode declaringType;
        private int methodSize = -1;

        MethodNode(HostedMethod obj, TypeNode declaringType) {
            super(obj);
            this.declaringType = Objects.requireNonNull(declaringType);
        }

        public static String[] getHeaderNames() {
            return new String[]{"Id", "SimpleName", "Name", "Size", "TypeId"};
        }

        @Override
        public String[] getValues() {
            return new String[]{String.valueOf(this.id), ((HostedMethod)this.obj).getName(), ((HostedMethod)this.obj).format("%H.%n(%p)%r"), String.valueOf(this.methodSize), String.valueOf(this.declaringType.id)};
        }

        public void setMethodSize(int methodSize) {
            this.methodSize = methodSize;
        }
    }

    static class ObjectNode
    extends Node<ObjectInspector.ObjectDefinition> {
        public final ConstantIdentityMapping.IdentityNode identityNode;

        ObjectNode(ConstantIdentityMapping.IdentityNode node) {
            super(node.getDefinition());
            this.identityNode = node;
        }

        public static String[] getHeaderNames() {
            return new String[]{"Id", "SimpleName", "Name", "Size", "IdentityNodeName", "IdentityNodeNum"};
        }

        @Override
        public String[] getValues() {
            return new String[]{String.valueOf(this.id), ClassUtil.getUnqualifiedName(((ObjectInspector.ObjectDefinition)this.obj).getClass()), ((ObjectInspector.ObjectDefinition)this.obj).toString(), String.valueOf(((ObjectInspector.ObjectDefinition)this.obj).getSize()), this.identityNode.hasName() ? this.identityNode.getName() : "", String.valueOf(this.identityNode.getNum())};
        }
    }
}

