/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.util;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.webimage.api.JS;

public class ReflectUtil {
    private static final HashSet<Method> OBJECT_METHODS = new HashSet();
    private static final ConcurrentHashMap<ResolvedJavaType, Object> SAM_CACHE;

    private static Optional<Method> singleAbstractMethodForInterface(Class<?> javaInterface) {
        if (!javaInterface.isInterface()) {
            return Optional.empty();
        }
        if (javaInterface.getAnnotation(FunctionalInterface.class) == null) {
            return Optional.empty();
        }
        Method sam = null;
        for (Method method : javaInterface.getMethods()) {
            if (OBJECT_METHODS.contains(method) || method.isDefault()) continue;
            sam = method;
            break;
        }
        if (sam == null) {
            return Optional.empty();
        }
        return Optional.of(sam);
    }

    public static <M extends ResolvedJavaMethod & OriginalMethodProvider, T extends ResolvedJavaType & OriginalClassProvider> Optional<M> singleAbstractMethodForClass(MetaAccessProvider metaAccess, T classType) {
        Optional<M> sam = (Optional<M>)SAM_CACHE.get(classType);
        if (sam != null) {
            return sam;
        }
        sam = ReflectUtil.findSingleAbstractMethodForClass(metaAccess, classType);
        SAM_CACHE.putIfAbsent(classType, sam);
        return (Optional)SAM_CACHE.get(classType);
    }

    private static <M extends ResolvedJavaMethod & OriginalMethodProvider, T extends ResolvedJavaType & OriginalClassProvider> Optional<M> findSingleAbstractMethodForClass(MetaAccessProvider metaAccess, T classType) {
        Class javaClass = OriginalClassProvider.getJavaClass(classType);
        LinkedHashSet interfaces = new LinkedHashSet();
        ReflectUtil.findAllInterfaces(javaClass, interfaces);
        Object javaSam = Optional.empty();
        for (Class clazz : interfaces) {
            ResolvedJavaMethod[] candidate = ReflectUtil.singleAbstractMethodForInterface(clazz);
            if (!candidate.isPresent()) continue;
            if (((Optional)javaSam).isPresent()) {
                return Optional.empty();
            }
            javaSam = candidate;
        }
        if (!((Optional)javaSam).isPresent()) {
            return Optional.empty();
        }
        ResolvedJavaMethod sam = null;
        ResolvedJavaType resolvedJavaType = metaAccess.lookupJavaType(((Method)((Optional)javaSam).get()).getDeclaringClass());
        for (ResolvedJavaMethod candidate : resolvedJavaType.getDeclaredMethods(false)) {
            if (!Objects.equals(OriginalMethodProvider.getJavaMethod((ResolvedJavaMethod)candidate), ((Optional)javaSam).get())) continue;
            sam = candidate;
            break;
        }
        if (sam == null) {
            return Optional.empty();
        }
        ResolvedJavaMethod resolved = classType.resolveConcreteMethod(sam, null);
        return Optional.ofNullable(resolved);
    }

    private static void findAllInterfaces(Class<?> type, LinkedHashSet<Class<?>> interfaces) {
        if (interfaces.contains(type)) {
            return;
        }
        if (type.isInterface()) {
            interfaces.add(type);
        }
        for (Class<?> superInterface : type.getInterfaces()) {
            ReflectUtil.findAllInterfaces(superInterface, interfaces);
        }
        if (type.getSuperclass() != null) {
            ReflectUtil.findAllInterfaces(type.getSuperclass(), interfaces);
        }
    }

    public static Set<Method> findBaseMethodsOfJSAnnotated(ImageClassLoader imageClassLoader) {
        HashSet<Method> methods = new HashSet<Method>();
        List annotatedMethods = imageClassLoader.findAnnotatedMethods(JS.class);
        for (Method annotatedMethod : annotatedMethods) {
            ReflectUtil.findBaseMethods(annotatedMethod, annotatedMethod.getDeclaringClass(), methods);
        }
        return methods;
    }

    private static void findBaseMethods(Method originalMethod, Class<?> clazz, Set<Method> jsOverridenMethodSet) {
        if (clazz == null) {
            return;
        }
        Method baseMethod = ReflectionUtil.lookupMethod((boolean)true, clazz, (String)originalMethod.getName(), (Class[])originalMethod.getParameterTypes());
        if (baseMethod != null) {
            jsOverridenMethodSet.add(baseMethod);
        }
        for (Class<?> clazzInterface : clazz.getInterfaces()) {
            ReflectUtil.findBaseMethods(originalMethod, clazzInterface, jsOverridenMethodSet);
        }
        ReflectUtil.findBaseMethods(originalMethod, clazz.getSuperclass(), jsOverridenMethodSet);
    }

    static {
        OBJECT_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        SAM_CACHE = new ConcurrentHashMap();
    }
}

