/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.snippets;

import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.hosted.webimage.codegen.node.ReadIdentityHashCodeNode;
import com.oracle.svm.hosted.webimage.codegen.node.WriteIdentityHashCodeNode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import org.graalvm.word.LocationIdentity;

public class WebImageIdentityHashCodeSnippets
extends IdentityHashCodeSnippets {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor COMPUTE_IDENTITY_HASH_CODE = SnippetRuntime.findForeignCall(WebImageIdentityHashCodeSnippets.class, (String)"doComputeIdentityHashCode", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION});

    public static IdentityHashCodeSnippets.Templates createTemplates(OptionValues options, Providers providers) {
        return new IdentityHashCodeSnippets.Templates((IdentityHashCodeSnippets)new WebImageIdentityHashCodeSnippets(), options, providers, IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
    }

    protected int computeIdentityHashCode(Object thisObj) {
        return WebImageIdentityHashCodeSnippets.callComputeIdentityHashCode((ForeignCallDescriptor)COMPUTE_IDENTITY_HASH_CODE, thisObj);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int callComputeIdentityHashCode(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int doComputeIdentityHashCode(Object obj) {
        int identityHashCode = ReadIdentityHashCodeNode.read(obj);
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (identityHashCode == 0 ? 1 : 0) != 0)) {
            identityHashCode = IdentityHashCodeSupport.generateRandomHashCode();
            WriteIdentityHashCodeNode.set(obj, identityHashCode);
        }
        return identityHashCode;
    }
}

