/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.snippets;

import com.oracle.svm.hosted.webimage.snippets.JSSnippet;
import com.oracle.svm.hosted.webimage.snippets.JSSnippetWithEmitterSupport;
import java.text.MessageFormat;
import java.util.List;
import jdk.graal.compiler.hightiercodegen.Emitter;

public final class JSSnippets {
    private static final String entryFunction = "/** @suppress '{'checkVars,duplicate'}' */ {0}.{1} = async function (vmArgs, config = new {0}.{2}()) '{'\n   let data = new Data(config);\n   for (let libname in config.libraries) '{'\n       const content = await runtime.fetchText(config.libraries[libname]);\n       data.libraries[libname] = content;\n   '}'\n{3}\n   let vm = {4}(vmArgs, data);\n   return vm;\n'}'";
    private static final String exportMirrorClassDefinition = "Object.defineProperty(runtime.ensureExportPackage(''{0}''),\n''{1}'',\n'{' configurable: false, enumerable: true, get: () => '{' {2} return {3}; '}' '}')";
    private static final String signExtend = MessageFormat.format("(({0} << (32 - {0})) >> (32 - {0}))", "##arg##");
    private static final String stringCharConstructor = String.format("function stringCharConstructor(javaStr, charArray) {\n    javaStr.%s(javaStr, charArray);\n}\n", "##arg##");

    public static JSSnippet instantiateEntryFunction(String vmClassName, String runFunctionName, String configClassName, String preCall, String vmFunctionName) {
        return new JSSnippet(MessageFormat.format(entryFunction, vmClassName, runFunctionName, configClassName, preCall, vmFunctionName));
    }

    public static JSSnippet instantiateExportMirrorClassDefinition(String packageName, String className, String hub, String internalMirrorClassName) {
        return new JSSnippet(MessageFormat.format(exportMirrorClassDefinition, packageName, className, hub == null ? "" : "ensureInitialized(" + hub + ");", internalMirrorClassName));
    }

    public static JSSnippetWithEmitterSupport instantiateSignExtendSnippet(List<Emitter> emitters) {
        return new JSSnippetWithEmitterSupport(signExtend, emitters);
    }

    public static JSSnippetWithEmitterSupport instantiateStringCharConstructor(Emitter emitter) {
        return new JSSnippetWithEmitterSupport(stringCharConstructor, List.of(emitter));
    }

    public static JSSnippet emptySnippet() {
        return new JSSnippet("");
    }
}

