/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.snippets;

import com.oracle.svm.hosted.webimage.snippets.JSSnippet;
import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;

public class JSSnippetWithEmitterSupport
extends JSSnippet {
    public static final String EmitterPlaceHolder = "##arg##";
    private final List<Emitter> emitters;

    public JSSnippetWithEmitterSupport(String formattedString, List<Emitter> emitters) {
        super(formattedString);
        this.emitters = emitters;
    }

    @Override
    public void lower(CodeGenTool tool) {
        int emitterIndex = 0;
        for (String line : this.formattedString.split("\n")) {
            int placeHolderStart;
            int current = 0;
            while ((placeHolderStart = line.indexOf(EmitterPlaceHolder, current)) != -1) {
                tool.getCodeBuffer().emitText(line.substring(current, placeHolderStart));
                this.emitters.get(emitterIndex).lower(tool);
                ++emitterIndex;
                current = placeHolderStart + EmitterPlaceHolder.length();
            }
            tool.getCodeBuffer().emitText(line.substring(current));
            tool.getCodeBuffer().emitNewLine();
        }
    }

    @Override
    public String asString() {
        throw GraalError.shouldNotReachHere((String)("Cannot convert a " + this.getClass().getName() + " to a string because it contains emitters"));
    }
}

