/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.webimage.util.ReflectUtil;
import java.util.Optional;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class InterceptJSInvokeTypeFlow
extends TypeFlow<BytecodePosition> {
    private final AnalysisMethod targetMethod;
    private final TypeFlow<?>[] arguments;

    public InterceptJSInvokeTypeFlow(BytecodePosition source, AnalysisMethod targetMethod, TypeFlow<?>[] arguments) {
        super((Object)source, null);
        this.targetMethod = targetMethod;
        this.arguments = arguments;
    }

    private InterceptJSInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, InterceptJSInvokeTypeFlow original) {
        super((TypeFlow)original, methodFlows);
        this.targetMethod = original.targetMethod;
        this.arguments = new TypeFlow[original.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            if (original.arguments[i] == null) continue;
            this.arguments[i] = methodFlows.lookupCloneOf(bb, original.arguments[i]);
        }
    }

    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new InterceptJSInvokeTypeFlow(bb, methodFlows, this);
    }

    public boolean canSaturate(PointsToAnalysis bb) {
        return false;
    }

    protected void onFlowEnabled(PointsToAnalysis bb) {
        super.onFlowEnabled(bb);
        bb.postTask(() -> this.onObservedUpdate(bb));
    }

    public void onObservedUpdate(PointsToAnalysis bb) {
        if (!this.isFlowEnabled()) {
            return;
        }
        for (AnalysisObject object : this.getState().objects((BigBang)bb)) {
            Optional sam = ReflectUtil.singleAbstractMethodForClass((MetaAccessProvider)bb.getMetaAccess(), object.type());
            if (!sam.isPresent()) continue;
            bb.addRootMethod((AnalysisMethod)sam.get(), false, (Object)("SAM method to JS, registered in " + String.valueOf(InterceptJSInvokeTypeFlow.class)), new MultiMethod.MultiMethodKey[0]);
            SubstrateCompilationDirectives.singleton().registerForcedCompilation((ResolvedJavaMethod)sam.get());
        }
    }

    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != observed) continue;
            TypeFlow paramTypeFlow = this.targetMethod.isStatic() ? ((AnalysisType)this.targetMethod.getSignature().getParameterType(i)).getTypeFlow((BigBang)bb, true) : (i == 0 ? this.targetMethod.getDeclaringClass().getTypeFlow((BigBang)bb, true) : ((AnalysisType)this.targetMethod.getSignature().getParameterType(i - 1)).getTypeFlow((BigBang)bb, true));
            this.arguments[i] = paramTypeFlow;
            this.arguments[i].addUse(bb, (TypeFlow)this);
            this.arguments[i].addObserver(bb, (TypeFlow)this);
        }
    }
}

