/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.flow.builder.TypeFlowGraphBuilder;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.svm.hosted.analysis.flow.SVMMethodTypeFlowBuilder;
import com.oracle.svm.hosted.webimage.codegen.node.InterceptJSInvokeNode;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.pointsto.flow.InterceptJSInvokeTypeFlow;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.code.BytecodePosition;

public class WebImageMethodTypeFlowBuilder
extends SVMMethodTypeFlowBuilder {
    public WebImageMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        super(bb, method, flowsGraph, graphKind);
    }

    protected boolean delegateNodeProcessing(FixedNode n, MethodTypeFlowBuilder.TypeFlowsOfNodes state) {
        super.delegateNodeProcessing(n, state);
        return WebImageMethodTypeFlowBuilder.processWebImageNodes(this.bb, this.method, this.typeFlowGraphBuilder, n, state, this.flowsGraph);
    }

    public static boolean processWebImageNodes(PointsToAnalysis bb, PointsToAnalysisMethod method, TypeFlowGraphBuilder typeFlowGraphBuilder, FixedNode n, MethodTypeFlowBuilder.TypeFlowsOfNodes state, MethodFlowsGraph flowsGraph) {
        if (n instanceof InterceptJSInvokeNode) {
            InterceptJSInvokeNode node = (InterceptJSInvokeNode)n;
            TypeFlowBuilder[] argumentBuilders = new TypeFlowBuilder[node.arguments().size()];
            for (int i = 0; i < argumentBuilders.length; ++i) {
                TypeFlowBuilder argumentBuilder;
                ValueNode argument = (ValueNode)node.arguments().get(i);
                if (!(argument.stamp(NodeView.DEFAULT) instanceof ObjectStamp)) continue;
                argumentBuilders[i] = argumentBuilder = state.lookup(argument);
            }
            TypeFlowBuilder interceptBuilder = TypeFlowBuilder.create((PointsToAnalysis)bb, (PointsToAnalysisMethod)method, (Object)state.getPredicate(), (Object)((Object)node), InterceptJSInvokeTypeFlow.class, () -> {
                NodeSourcePosition pos = node.getNodeSourcePosition();
                if (pos == null) {
                    pos = new BytecodePosition(null, node.graph().method(), node.bci());
                }
                TypeFlow[] arguments = new TypeFlow[argumentBuilders.length];
                for (int i = 0; i < arguments.length; ++i) {
                    if (argumentBuilders[i] == null) continue;
                    arguments[i] = argumentBuilders[i].get();
                }
                InterceptJSInvokeTypeFlow intercept = new InterceptJSInvokeTypeFlow((BytecodePosition)pos, (AnalysisMethod)node.targetMethod(), arguments);
                assert (flowsGraph != null);
                flowsGraph.addMiscEntryFlow((TypeFlow)intercept);
                return intercept;
            });
            for (int i = 0; i < argumentBuilders.length; ++i) {
                if (argumentBuilders[i] == null) continue;
                interceptBuilder.addUseDependency(argumentBuilders[i]);
                interceptBuilder.addObserverDependency(argumentBuilders[i]);
            }
            typeFlowGraphBuilder.registerSinkBuilder(interceptBuilder);
            return true;
        }
        if (n instanceof JSBody) {
            JSBody jsBody = (JSBody)n;
            Stamp node = n.stamp(NodeView.DEFAULT);
            if (node instanceof ObjectStamp) {
                ObjectStamp stamp = (ObjectStamp)node;
                node = jsBody.asNode();
                AnalysisType type = stamp.type() == null ? bb.getObjectType() : stamp.type();
                ProxyTypeFlow proxy = new ProxyTypeFlow((BytecodePosition)node.getNodeSourcePosition(), type.getTypeFlow((BigBang)bb, true));
                flowsGraph.addNodeFlow((Node)n, (TypeFlow)proxy);
                return true;
            }
        }
        return false;
    }
}

