/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.phases;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.js.JSBodyWithExceptionNode;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import com.oracle.svm.webimage.functionintrinsics.JSSystemFunction;
import java.lang.reflect.AnnotatedElement;
import java.util.EnumMap;
import java.util.Locale;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.UnreachableControlSinkNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.webimage.api.JSResource;

public class WebImageHostedGraphKit
extends HostedGraphKit {
    public static final EnumMap<JavaKind, JSSystemFunction> TO_JS_CONVERSION_FUNCTIONS = new EnumMap(JavaKind.class);

    public WebImageHostedGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method, GraphProvider.Purpose purpose) {
        super(debug, providers, method);
    }

    public JSCallNode createJSFunctionCall(JSSystemFunction function, ValueNode ... args) {
        return (JSCallNode)this.append((Node)new JSCallNode(function, function.stamp(), args));
    }

    public ValueNode createConvertToJs(ValueNode value, JavaKind kind) {
        return this.createJSFunctionCall(TO_JS_CONVERSION_FUNCTIONS.get(kind), value);
    }

    public JSBody createJSBody(JSBody.JSCode jsCode, ResolvedJavaMethod method, ValueNode[] argNodes, Stamp returnStamp, FrameStateBuilder state, int bci, ResolvedJavaMethod exceptionHandler) {
        ExceptionObjectNode exceptionObject = this.createExceptionObjectNode(state, bci);
        boolean declaresResource = AnnotationAccess.isAnnotationPresent((AnnotatedElement)method.getDeclaringClass(), JSResource.class);
        JSBodyWithExceptionNode jsBody = (JSBodyWithExceptionNode)this.append((Node)new JSBodyWithExceptionNode(jsCode, method, argNodes, returnStamp, exceptionObject, declaresResource));
        this.startWithException(jsBody, exceptionObject, state, bci);
        this.exceptionPart();
        if (exceptionHandler == null) {
            this.append((Node)new UnwindNode((ValueNode)this.exceptionObject()));
        } else {
            this.createInvokeWithExceptionAndUnwind(exceptionHandler, CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), new ValueNode[]{this.exceptionObject()});
            this.append((Node)new UnreachableControlSinkNode());
        }
        this.endWithException();
        return jsBody;
    }

    static {
        for (JavaKind value : JavaKind.values()) {
            if (value == JavaKind.Illegal || value == JavaKind.Void) continue;
            Stamp returnStamp = StampFactory.objectNonNull();
            TO_JS_CONVERSION_FUNCTIONS.put(value, new JSSystemFunction(("$$$" + value.getTypeChar()).toLowerCase(Locale.ROOT), returnStamp, value));
        }
    }
}

