/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.phases;

import com.oracle.svm.webimage.longemulation.Long64;
import java.util.List;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;

public class PrepareLongEmulationPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        graph.getDebug().dump(5, (Object)graph, "Before prepare Long emulation");
        Stamp nonNull = StampFactory.objectNonNull();
        for (Node n : graph.getNodes()) {
            ValueNode vn;
            if (!(n instanceof ValueNode) || !(((ValueNode)n).stamp(NodeView.DEFAULT) instanceof ObjectStamp) || !(vn = (ValueNode)n).stamp(NodeView.DEFAULT).javaType(context.getMetaAccess()).equals((Object)context.getMetaAccess().lookupJavaType(Long64.class))) continue;
            ObjectStamp vnStamp = (ObjectStamp)vn.stamp(NodeView.DEFAULT);
            vn.setStamp(vnStamp.join(nonNull));
        }
        if (graph.method().getDeclaringClass().equals((Object)context.getMetaAccess().lookupJavaType(Long64.class))) {
            for (InvokeWithExceptionNode inv : graph.getNodes(InvokeWithExceptionNode.TYPE)) {
                inv.replaceWithInvoke();
            }
            List unwindNodes = graph.getNodes(UnwindNode.TYPE).snapshot();
            assert (unwindNodes.size() <= 1) : unwindNodes;
            for (UnwindNode unwindNode : unwindNodes) {
                UnreachableNode unreachableNode = new UnreachableNode();
                unreachableNode = (UnreachableNode)graph.add((Node)unreachableNode);
                graph.addBeforeFixed((FixedNode)unwindNode, (FixedWithNextNode)unreachableNode);
            }
        }
        graph.getDebug().dump(5, (Object)graph, "After prepare Long emulation");
    }
}

