/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.phases;

import com.oracle.svm.core.util.VMError;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.JavaKind;

public class MaterializeAllocationsPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (CommitAllocationNode commitAllocation : graph.getNodes().filter(CommitAllocationNode.class)) {
            this.lowerCommitAllocationNode(commitAllocation, context);
        }
    }

    protected void lowerCommitAllocationNode(CommitAllocationNode commit, CoreProviders context) {
        AbstractNewObjectNode[] allocations = this.materializeAllocations(commit);
        this.storeValues(commit, allocations, context);
        FixedValueAnchorNode[] valueAnchors = this.anchorAllocations((FixedWithNextNode)commit, allocations);
        this.replaceUsagesWithAnchors(commit, valueAnchors);
        commit.graph().removeFixed((FixedWithNextNode)commit);
    }

    protected AbstractNewObjectNode[] materializeAllocations(CommitAllocationNode commit) {
        StructuredGraph graph = commit.graph();
        List virtualObjects = commit.getVirtualObjects();
        int numObjects = virtualObjects.size();
        AbstractNewObjectNode[] allocations = new AbstractNewObjectNode[numObjects];
        for (int objIndex = 0; objIndex < numObjects; ++objIndex) {
            VirtualObjectNode virtual = (VirtualObjectNode)virtualObjects.get(objIndex);
            try (DebugCloseable ignored = graph.withNodeSourcePosition((Node)virtual);){
                VirtualObjectNode virtualObjectNode;
                Objects.requireNonNull(virtual);
                int n = 0;
                AbstractNewObjectNode newObject = (AbstractNewObjectNode)graph.addOrUniqueWithInputs((Node)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VirtualInstanceNode.class, VirtualArrayNode.class}, (Object)virtualObjectNode, n)) {
                    case 0 -> {
                        VirtualInstanceNode ignored1 = (VirtualInstanceNode)virtualObjectNode;
                        yield new NewInstanceNode(virtual.type(), true);
                    }
                    case 1 -> {
                        VirtualArrayNode virtualArrayNode = (VirtualArrayNode)virtualObjectNode;
                        yield new NewArrayNode(virtualArrayNode.componentType(), (ValueNode)ConstantNode.forInt((int)virtual.entryCount()), true);
                    }
                    default -> throw VMError.shouldNotReachHere((String)("Unexpected VirtualNode: " + String.valueOf(virtual)));
                }));
                graph.addBeforeFixed((FixedNode)commit, (FixedWithNextNode)newObject);
                allocations[objIndex] = newObject;
                continue;
            }
        }
        return allocations;
    }

    protected void storeValues(CommitAllocationNode commit, AbstractNewObjectNode[] allocations, CoreProviders context) {
        int objIndex;
        StructuredGraph graph = commit.graph();
        FrameState frameState = GraphUtil.findLastFrameState((FixedNode)commit).duplicate();
        List virtualObjects = commit.getVirtualObjects();
        int numObjects = virtualObjects.size();
        int[] valuePositions = new int[numObjects];
        int valuePos = 0;
        for (objIndex = 0; objIndex < numObjects; ++objIndex) {
            valuePositions[objIndex] = valuePos;
            valuePos += ((VirtualObjectNode)virtualObjects.get(objIndex)).entryCount();
        }
        for (objIndex = 0; objIndex < numObjects; ++objIndex) {
            VirtualObjectNode virtual = (VirtualObjectNode)virtualObjects.get(objIndex);
            try (DebugCloseable ignored = graph.withNodeSourcePosition((Node)virtual);){
                AbstractNewObjectNode newObject = allocations[objIndex];
                int baseValuePos = valuePositions[objIndex];
                for (int i = 0; i < virtual.entryCount(); ++i) {
                    VirtualObjectNode virtualObjectNode;
                    ValueNode value = (ValueNode)commit.getValues().get(baseValuePos + i);
                    if (value instanceof VirtualObjectNode) {
                        assert (virtualObjects.contains(value)) : "Virtual object " + String.valueOf(value) + " does not belong to " + String.valueOf(commit);
                        value = allocations[virtualObjects.indexOf(value)];
                    }
                    if (value.isDefaultConstant()) continue;
                    JavaKind storageKind = virtual.entryKind(context.getMetaAccessExtensionProvider(), i);
                    Objects.requireNonNull(virtual);
                    int n = 0;
                    FixedWithNextNode storeNode = (FixedWithNextNode)graph.addOrUniqueWithInputs((Node)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VirtualInstanceNode.class, VirtualArrayNode.class}, (Object)virtualObjectNode, n)) {
                        case 0 -> {
                            VirtualInstanceNode virtualInstance = (VirtualInstanceNode)virtualObjectNode;
                            yield new StoreFieldNode((ValueNode)newObject, virtualInstance.field(i), value);
                        }
                        case 1 -> {
                            VirtualArrayNode ignored1 = (VirtualArrayNode)virtualObjectNode;
                            yield new StoreIndexedNode((ValueNode)newObject, (ValueNode)ConstantNode.forInt((int)i), null, null, storageKind, value);
                        }
                        default -> throw VMError.shouldNotReachHere((String)("Unexpected VirtualNode: " + String.valueOf(virtual)));
                    }));
                    ((StateSplit)storeNode).setStateAfter(frameState);
                    graph.addBeforeFixed((FixedNode)commit, storeNode);
                }
                continue;
            }
        }
    }

    protected FixedValueAnchorNode[] anchorAllocations(FixedWithNextNode anchorPoint, AbstractNewObjectNode[] allocations) {
        StructuredGraph graph = anchorPoint.graph();
        FixedWithNextNode insertionPoint = anchorPoint;
        FixedValueAnchorNode[] valueAnchors = new FixedValueAnchorNode[allocations.length];
        for (int objIndex = 0; objIndex < allocations.length; ++objIndex) {
            FixedValueAnchorNode anchor;
            AbstractNewObjectNode allocation = allocations[objIndex];
            valueAnchors[objIndex] = anchor = (FixedValueAnchorNode)graph.add((Node)new FixedValueAnchorNode((ValueNode)allocation));
            graph.addAfterFixed(insertionPoint, (FixedNode)anchor);
            insertionPoint = anchor;
        }
        return valueAnchors;
    }

    protected void replaceUsagesWithAnchors(CommitAllocationNode commit, FixedValueAnchorNode[] anchors) {
        List virtualObjects = commit.getVirtualObjects();
        for (Node usage : commit.usages().snapshot()) {
            if (usage instanceof AllocatedObjectNode) {
                AllocatedObjectNode addObject = (AllocatedObjectNode)usage;
                int index = virtualObjects.indexOf(addObject.getVirtualObject());
                addObject.replaceAtUsagesAndDelete((Node)anchors[index]);
                continue;
            }
            throw VMError.shouldNotReachHere((String)("Found CommitAllocationNode with unexpected usage: " + String.valueOf(usage)));
        }
        assert (commit.hasNoUsages()) : commit.usages().snapshot();
    }
}

