/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.options;

import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class WebImageOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(WebImageOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "AnalyzeCompoundConditionals": {
                return OptionDescriptor.create((String)"AnalyzeCompoundConditionals", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if compound conditions should be rewritten", (Object)this.getContainer(), WebImageOptions.AnalyzeCompoundConditionals, (String)"AnalyzeCompoundConditionals", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AutoRunLibraries": {
                return OptionDescriptor.create((String)"AutoRunLibraries", (OptionType)OptionType.Debug, String.class, (String)"The list of libraries to fetch before the VM starts (comma-separated <library-name>:<library-url> pairs, where URLs can be relative). Only used when AutoRunVM is enabled.", (Object)this.getContainer(), WebImageOptions.AutoRunLibraries, (String)"AutoRunLibraries", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "AutoRunVM": {
                return OptionDescriptor.create((String)"AutoRunVM", (OptionType)OptionType.Debug, Boolean.class, (String)"Generates code that automatically runs the VM after its code is loaded (otherwise, the user must run the VM manually).", (Object)this.getContainer(), WebImageOptions.AutoRunVM, (String)"AutoRunVM", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "Backend": {
                return OptionDescriptor.create((String)"Backend", (OptionType)OptionType.Debug, WebImageOptions.CompilerBackend.class, (String)"The Web Image Backend to use.", (Object)this.getContainer(), WebImageOptions.Backend, (String)"Backend", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "BenchmarkName": {
                return OptionDescriptor.create((String)"BenchmarkName", (OptionType)OptionType.Debug, String.class, (String)"Set the name of the benchmark that is executed. Allows to output benchmarking data during compilation", (Object)this.getContainer(), WebImageOptions.BenchmarkName, (String)"BenchmarkName", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ClosureCompiler": {
                return OptionDescriptor.create((String)"ClosureCompiler", (OptionType)OptionType.Debug, Boolean.class, (String)"Determine if a last pass using the closure compiler should be done over the generated js code", (Object)this.getContainer(), WebImageOptions.ClosureCompiler, (String)"ClosureCompiler", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ClosurePrettyPrint": {
                return OptionDescriptor.create((String)"ClosurePrettyPrint", (OptionType)OptionType.Debug, WebImageOptions.ClosurePrettyPrintLevel.class, (String)"Pretty-printing level if the closure compiler is enabled to make debugging optimized images easier.", (Object)this.getContainer(), WebImageOptions.ClosurePrettyPrint, (String)"ClosurePrettyPrint", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpPreClosure": {
                return OptionDescriptor.create((String)"DumpPreClosure", (OptionType)OptionType.Debug, Boolean.class, (String)"If the closure compiler is used, also dump the generated code before the closure compiler runs.", (Object)this.getContainer(), WebImageOptions.DumpPreClosure, (String)"DumpPreClosure", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EncodeImageHeapArraysBase64": {
                return OptionDescriptor.create((String)"EncodeImageHeapArraysBase64", (OptionType)OptionType.Debug, Boolean.class, (String)"Lower Image Heap Arrays as a Base64 String. Used to reduce code size.", (Object)this.getContainer(), WebImageOptions.EncodeImageHeapArraysBase64, (String)"EncodeImageHeapArraysBase64", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "EntryPointsConfig": {
                return OptionDescriptor.create((String)"EntryPointsConfig", (OptionType)OptionType.User, String.class, (String)"Provide additional entry points via a configuration file. The format is the same as reflect configuration.", (Object)this.getContainer(), WebImageOptions.EntryPointsConfig, (String)"EntryPointsConfig", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GenerateSourceMap": {
                return OptionDescriptor.create((String)"GenerateSourceMap", (OptionType)OptionType.Debug, Boolean.class, (String)"Generate source maps to debug Java code", (Object)this.getContainer(), WebImageOptions.GenerateSourceMap, (String)"GenerateSourceMap", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JSComments": {
                return OptionDescriptor.create((String)"JSComments", (OptionType)OptionType.Debug, WebImageOptions.CommentVerbosity.class, (String)"Determine the level of verbosity for generated comments.", (Object)this.getContainer(), WebImageOptions.JSComments, (String)"JSComments", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "JSRuntime": {
                return OptionDescriptor.create((String)"JSRuntime", (OptionType)OptionType.Debug, WebImageOptions.VMType.class, (String)"The JavaScript runtime this build should target.", (Object)this.getContainer(), WebImageOptions.JSRuntime, (String)"JSRuntime", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "NamingConvention": {
                return OptionDescriptor.create((String)"NamingConvention", (OptionType)OptionType.Debug, WebImageNamingConvention.NamingMode.class, (String)"Naming Convention for object, method, and property names. (FULL = Always uses qualified names, REDUCED = Plain name is used if possible, MINIMAL = Names replaced with numbered identifiers)", (Object)this.getContainer(), WebImageOptions.NamingConvention, (String)"NamingConvention", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "OutlineRuntimeChecks": {
                return OptionDescriptor.create((String)"OutlineRuntimeChecks", (OptionType)OptionType.Debug, Boolean.class, (String)"Whether the compiler should outline runtime checks (e.g. null checks and array bound checks) to reduce code size.", (Object)this.getContainer(), WebImageOptions.OutlineRuntimeChecks, (String)"OutlineRuntimeChecks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ReportImageSizeBreakdown": {
                return OptionDescriptor.create((String)"ReportImageSizeBreakdown", (OptionType)OptionType.Debug, Boolean.class, (String)"Report the code sizes of different parts of the generated JavaScript image. If the closure compiler is applied, this instruments the generated javascript code by injecting labels.", (Object)this.getContainer(), WebImageOptions.ReportImageSizeBreakdown, (String)"ReportImageSizeBreakdown", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SILENT_COMPILE": {
                return OptionDescriptor.create((String)"SILENT_COMPILE", (OptionType)OptionType.Debug, Boolean.class, (String)"Determine if the Web Image compilation should be silent and not dump info", (Object)this.getContainer(), WebImageOptions.SILENT_COMPILE, (String)"SILENT_COMPILE", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SourceMapSourceRoot": {
                return OptionDescriptor.create((String)"SourceMapSourceRoot", (OptionType)OptionType.Debug, String.class, (String)"Directory containing source files for DevTools. May be relative to output file.", (Object)this.getContainer(), WebImageOptions.SourceMapSourceRoot, (String)"SourceMapSourceRoot", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "StrictWarnings": {
                return OptionDescriptor.create((String)"StrictWarnings", (OptionType)OptionType.Debug, Boolean.class, (String)"Treat warnings as compiler errors (e.g. in the Closure compiler)", (Object)this.getContainer(), WebImageOptions.StrictWarnings, (String)"StrictWarnings", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UsePEA": {
                return OptionDescriptor.create((String)"UsePEA", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines whether partial escape analysis should be used [default false, increases code size but also runtime performance]", (Object)this.getContainer(), WebImageOptions.UsePEA, (String)"UsePEA", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseRandomForTempFiles": {
                return OptionDescriptor.create((String)"UseRandomForTempFiles", (OptionType)OptionType.Debug, Boolean.class, (String)"Use Random instead of SecureRandom for generating temporary file names. This reduces image size when using temporary files.", (Object)this.getContainer(), WebImageOptions.UseRandomForTempFiles, (String)"UseRandomForTempFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "UseVtable": {
                return OptionDescriptor.create((String)"UseVtable", (OptionType)OptionType.Debug, Boolean.class, (String)"Generate vtable code instead of always using JavaScript's dynamic dispatch.Using vtables is slightly faster but also slightly increases code size", (Object)this.getContainer(), WebImageOptions.UseVtable, (String)"UseVtable", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VMClassName": {
                return OptionDescriptor.create((String)"VMClassName", (OptionType)OptionType.Debug, String.class, (String)"Name to use for the JavaScript class that represents the VM.", (Object)this.getContainer(), WebImageOptions.VMClassName, (String)"VMClassName", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 23;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return WebImageOptions_OptionDescriptors.this.get("AnalyzeCompoundConditionals");
                    }
                    case 1: {
                        return WebImageOptions_OptionDescriptors.this.get("AutoRunLibraries");
                    }
                    case 2: {
                        return WebImageOptions_OptionDescriptors.this.get("AutoRunVM");
                    }
                    case 3: {
                        return WebImageOptions_OptionDescriptors.this.get("Backend");
                    }
                    case 4: {
                        return WebImageOptions_OptionDescriptors.this.get("BenchmarkName");
                    }
                    case 5: {
                        return WebImageOptions_OptionDescriptors.this.get("ClosureCompiler");
                    }
                    case 6: {
                        return WebImageOptions_OptionDescriptors.this.get("ClosurePrettyPrint");
                    }
                    case 7: {
                        return WebImageOptions_OptionDescriptors.this.get("DumpPreClosure");
                    }
                    case 8: {
                        return WebImageOptions_OptionDescriptors.this.get("EncodeImageHeapArraysBase64");
                    }
                    case 9: {
                        return WebImageOptions_OptionDescriptors.this.get("EntryPointsConfig");
                    }
                    case 10: {
                        return WebImageOptions_OptionDescriptors.this.get("GenerateSourceMap");
                    }
                    case 11: {
                        return WebImageOptions_OptionDescriptors.this.get("JSComments");
                    }
                    case 12: {
                        return WebImageOptions_OptionDescriptors.this.get("JSRuntime");
                    }
                    case 13: {
                        return WebImageOptions_OptionDescriptors.this.get("NamingConvention");
                    }
                    case 14: {
                        return WebImageOptions_OptionDescriptors.this.get("OutlineRuntimeChecks");
                    }
                    case 15: {
                        return WebImageOptions_OptionDescriptors.this.get("ReportImageSizeBreakdown");
                    }
                    case 16: {
                        return WebImageOptions_OptionDescriptors.this.get("SILENT_COMPILE");
                    }
                    case 17: {
                        return WebImageOptions_OptionDescriptors.this.get("SourceMapSourceRoot");
                    }
                    case 18: {
                        return WebImageOptions_OptionDescriptors.this.get("StrictWarnings");
                    }
                    case 19: {
                        return WebImageOptions_OptionDescriptors.this.get("UsePEA");
                    }
                    case 20: {
                        return WebImageOptions_OptionDescriptors.this.get("UseRandomForTempFiles");
                    }
                    case 21: {
                        return WebImageOptions_OptionDescriptors.this.get("UseVtable");
                    }
                    case 22: {
                        return WebImageOptions_OptionDescriptors.this.get("VMClassName");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

