/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.options;

import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class WebImageOptions_DebugOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(WebImageOptions.DebugOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "DumpCurrentCompiledFunction": {
                return OptionDescriptor.create((String)"DumpCurrentCompiledFunction", (OptionType)OptionType.Debug, Boolean.class, (String)"Dumping during function compilation: every function will be dumped to a separate file, every node from scheduling which is lowered to js will be dumped with the associated scope (with parent relation) it was associated with", (Object)this.getContainer(), WebImageOptions.DebugOptions.DumpCurrentCompiledFunction, (String)"DumpCurrentCompiledFunction", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpProvidedHostedOptionsAndExit": {
                return OptionDescriptor.create((String)"DumpProvidedHostedOptionsAndExit", (OptionType)OptionType.Debug, Boolean.class, (String)"Dump the expected value of the ProvidedHostedOptions property.", (Object)this.getContainer(), WebImageOptions.DebugOptions.DumpProvidedHostedOptionsAndExit, (String)"DumpProvidedHostedOptionsAndExit", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "DumpTypeControlGraph": {
                return OptionDescriptor.create((String)"DumpTypeControlGraph", (OptionType)OptionType.Debug, Boolean.class, (String)"Dump type control graph, a graph of dependencies between types, methods, and inspected objects.", (Object)this.getContainer(), WebImageOptions.DebugOptions.DumpTypeControlGraph, (String)"DumpTypeControlGraph", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GenTimingCode": {
                return OptionDescriptor.create((String)"GenTimingCode", (OptionType)OptionType.Debug, Boolean.class, (String)"Instruments the generated code with timers.", (Object)this.getContainer(), WebImageOptions.DebugOptions.GenTimingCode, (String)"GenTimingCode", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "RuntimeDebugChecks": {
                return OptionDescriptor.create((String)"RuntimeDebugChecks", (OptionType)OptionType.Debug, Boolean.class, (String)"Enables runtime debug checks/assertions", (Object)this.getContainer(), WebImageOptions.DebugOptions.RuntimeDebugChecks, (String)"RuntimeDebugChecks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerificationPhases": {
                return OptionDescriptor.create((String)"VerificationPhases", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable verification phases.", (Object)this.getContainer(), WebImageOptions.DebugOptions.VerificationPhases, (String)"VerificationPhases", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 6;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return WebImageOptions_DebugOptions_OptionDescriptors.this.get("DumpCurrentCompiledFunction");
                    }
                    case 1: {
                        return WebImageOptions_DebugOptions_OptionDescriptors.this.get("DumpProvidedHostedOptionsAndExit");
                    }
                    case 2: {
                        return WebImageOptions_DebugOptions_OptionDescriptors.this.get("DumpTypeControlGraph");
                    }
                    case 3: {
                        return WebImageOptions_DebugOptions_OptionDescriptors.this.get("GenTimingCode");
                    }
                    case 4: {
                        return WebImageOptions_DebugOptions_OptionDescriptors.this.get("RuntimeDebugChecks");
                    }
                    case 5: {
                        return WebImageOptions_DebugOptions_OptionDescriptors.this.get("VerificationPhases");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

