/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.options;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.webimage.codegen.ClosureCompilerSupport;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import com.oracle.svm.webimage.platform.WebImagePlatform;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import java.io.OutputStream;
import java.io.PrintStream;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.EnumOptionKey;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public class WebImageOptions {
    public static final EnumOptionKey<CompilerBackend> Backend = new EnumOptionKey((Enum)CompilerBackend.JS);
    public static final HostedOptionKey<Boolean> ReportImageSizeBreakdown = new HostedOptionKey((Object)false);
    public static final EnumOptionKey<VMType> JSRuntime = new EnumOptionKey((Enum)VMType.Generic);
    public static final EnumOptionKey<WebImageNamingConvention.NamingMode> NamingConvention = new EnumOptionKey((Enum)WebImageNamingConvention.NamingMode.MINIMAL);
    public static final OptionKey<Boolean> UseVtable = new OptionKey((Object)true);
    public static final HostedOptionKey<Boolean> ClosureCompiler = new HostedOptionKey<Boolean>(Boolean.valueOf(true), WebImageOptions::validateClosureCompiler){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (!newValue.booleanValue() && !values.containsKey(NamingConvention)) {
                NamingConvention.update(values, (Object)WebImageNamingConvention.NamingMode.REDUCED);
            }
        }
    };
    public static final EnumOptionKey<ClosurePrettyPrintLevel> ClosurePrettyPrint = new EnumOptionKey<ClosurePrettyPrintLevel>(ClosurePrettyPrintLevel.NONE){

        public void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, ClosurePrettyPrintLevel oldValue, ClosurePrettyPrintLevel newValue) {
            if (!newValue.renameVariables() && !values.containsKey(NamingConvention)) {
                NamingConvention.update(values, (Object)WebImageNamingConvention.NamingMode.REDUCED);
            }
        }
    };
    public static final HostedOptionKey<Boolean> DumpPreClosure = new HostedOptionKey((Object)false);
    public static final HostedOptionKey<Boolean> StrictWarnings = new HostedOptionKey((Object)false);
    public static final OptionKey<Boolean> EncodeImageHeapArraysBase64 = new OptionKey((Object)true);
    public static final OptionKey<String> VMClassName = new OptionKey((Object)"GraalVM");
    public static final OptionKey<Boolean> AutoRunVM = new OptionKey((Object)true);
    public static final OptionKey<String> AutoRunLibraries = new OptionKey((Object)"");
    public static final OptionKey<Boolean> OutlineRuntimeChecks = new OptionKey((Object)true);
    public static final OptionKey<Boolean> GenerateSourceMap = new OptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                SubstrateOptions.IncludeNodeSourcePositions.update(values, (Object)oldValue);
            }
        }
    };
    public static final OptionKey<String> SourceMapSourceRoot = new OptionKey((Object)"");
    public static final OptionKey<Boolean> AnalyzeCompoundConditionals = new OptionKey((Object)true);
    public static final OptionKey<Boolean> UsePEA = new OptionKey((Object)false);
    protected static final EnumOptionKey<CommentVerbosity> JSComments = new EnumOptionKey((Enum)CommentVerbosity.NONE);
    public static final OptionKey<Boolean> UseRandomForTempFiles = new OptionKey((Object)true);
    public static final OptionKey<String> EntryPointsConfig = new OptionKey(null);
    public static final OptionKey<Boolean> SILENT_COMPILE = new OptionKey((Object)false);
    public static final OptionKey<String> BenchmarkName = new OptionKey(null);

    public static String getTargetVM() {
        return ((VMType)((Object)JSRuntime.getValue(HostedOptionValues.singleton()))).name();
    }

    public static boolean supportRuntime(VMType target) {
        return ((VMType)((Object)JSRuntime.getValue(HostedOptionValues.singleton()))).includes(target);
    }

    public static CompilerBackend getBackend() {
        return CompilerBackend.fromPlatform((Platform)ImageSingletons.lookup(Platform.class));
    }

    public static CompilerBackend getBackend(ImageClassLoader loader) {
        return CompilerBackend.fromPlatform(loader.platform);
    }

    @Fold
    public static boolean isNativeImageBackend() {
        return !Boolean.getBoolean("com.oracle.graalvm.iswebimage");
    }

    private static void validateClosureCompiler(HostedOptionKey<Boolean> optionKey) {
        if (((Boolean)optionKey.getValue()).booleanValue() && !ClosureCompilerSupport.isAvailable()) {
            throw UserError.abort((String)"The Google Closure Compiler is not available in this distribution, please turn off the '%s' option", (Object[])new Object[]{optionKey.getName()});
        }
    }

    public static boolean genJSComments() {
        return WebImageOptions.genJSComments(null);
    }

    public static boolean genJSComments(CommentVerbosity verbosity) {
        return ((CommentVerbosity)((Object)JSComments.getValue(HostedOptionValues.singleton()))).isEnabled(verbosity == null ? CommentVerbosity.NORMAL : verbosity);
    }

    public static PrintStream compilerPrinter(OptionValues options) {
        if (((Boolean)SILENT_COMPILE.getValue(options)).booleanValue()) {
            return new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
        }
        return System.out;
    }

    public static enum VMType {
        Browser,
        Node,
        Generic;


        boolean includes(VMType target) {
            if (this == Generic) {
                return true;
            }
            return this == target;
        }
    }

    public static enum CompilerBackend {
        JS(WebImageJSPlatform.class),
        WASM(WebImageWasmLMPlatform.class),
        WASMGC(WebImageWasmGCPlatform.class);

        public final Class<? extends WebImagePlatform> platform;

        private CompilerBackend(Class<? extends WebImagePlatform> platform) {
            this.platform = platform;
        }

        public static CompilerBackend fromPlatform(Platform platform) {
            if (platform instanceof WebImageJSPlatform) {
                return JS;
            }
            if (platform instanceof WebImageWasmLMPlatform) {
                return WASM;
            }
            if (platform instanceof WebImageWasmGCPlatform) {
                return WASMGC;
            }
            throw GraalError.shouldNotReachHere((String)String.valueOf(platform));
        }
    }

    public static enum CommentVerbosity {
        NONE,
        MINIMAL,
        NORMAL,
        VERBOSE;


        public boolean isEnabled(CommentVerbosity required) {
            return required.ordinal() <= this.ordinal();
        }
    }

    public static enum ClosurePrettyPrintLevel {
        NONE,
        SIMPLE,
        FULL;


        public boolean renameVariables() {
            return this.ordinal() < FULL.ordinal();
        }

        public boolean prettyPrint() {
            return this.ordinal() > NONE.ordinal();
        }
    }

    public static final class SemanticOptions {
        public static final OptionKey<Boolean> ForceSinglePrecision = new OptionKey((Object)true);
    }

    public static final class DebugOptions {
        public static final OptionKey<Boolean> DumpCurrentCompiledFunction = new OptionKey((Object)false);
        public static final OptionKey<Boolean> GenTimingCode = new OptionKey((Object)false);
        public static final HostedOptionKey<Boolean> RuntimeDebugChecks = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> VerificationPhases = new HostedOptionKey((Object)false);
        public static final OptionKey<Boolean> DumpTypeControlGraph = new OptionKey((Object)false);
        public static final HostedOptionKey<Boolean> DumpProvidedHostedOptionsAndExit = new HostedOptionKey((Object)false);
    }

    public static final class LoggerOptions {
        public static final EnumOptionKey<LoggingFormat> LoggingStyle = new EnumOptionKey((Enum)LoggingFormat.ReadableText);
        public static final OptionKey<String> LogFilter = new OptionKey(null);
        public static final OptionKey<String> LoggingFile = new OptionKey(null);

        public static enum LoggingFormat {
            ReadableText,
            BenchmarkText;

        }
    }
}

